#!/usr/local/bin/perl -w

require 5.001;
use Date::Manip;
@Date::Manip::TestArgs=();
$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
} elsif ( -f "test.pl" ) {
  require "test.pl";
} else {
  die "ERROR: cannot find test.pl\n";
}
$ntest=41;

print "1..$ntest\n"  if (! $runtests);
&Date_Init(@Date::Manip::TestArgs);

$tests ="

1*1:1:1:0:0:0*EASTER
Jan 1 1997
Jan 1 1997
Jan 1 2000
   ~
   1997033000:00:00
   1998041200:00:00
   1999040400:00:00

*1997-1999:1:1:1:0:0:0*EASTER
   ~
   1997033000:00:00
   1998041200:00:00
   1999040400:00:00

*1999:1:1,2:6:0:0:0*CWD
   ~
   1999010400:00:00
   1999010800:00:00

*1999:1:1,2:6:0:0:0*CWP
   ~
   1998123100:00:00
   1999010800:00:00

*1999:1:1,2:6:0:0:0*CWN
   ~
   1999010400:00:00
   1999010800:00:00

*1999:1-4:2:0:12:00:00*MD4,PD1,BD2,FW2
   ~
   1999010512:00:00
   1999020212:00:00
   1999030212:00:00
   1999033012:00:00

*1999:1-4:2:0:12:00:00*MD4,PD1,BD2
   ~
   1999010212:00:00
   1999013012:00:00
   1999022712:00:00
   1999032712:00:00

*1999:1-4:2:0:12:00:00*MD4,PD1
   ~
   1999010412:00:00
   1999020112:00:00
   1999030112:00:00
   1999032912:00:00

*1999:1-4:2:0:12:00:00*MD4,PT1
   ~
   1999011112:00:00
   1999020812:00:00
   1999030812:00:00
   1999040512:00:00

*1999:1-4:2:0:12:00:00*MD4,PD7
   ~
   1999011012:00:00
   1999020712:00:00
   1999030712:00:00
   1999040412:00:00

*1999:1-4:2:0:12:00:00*MD4
   ~
   1999011112:00:00
   1999020812:00:00
   1999030812:00:00
   1999040512:00:00

*1999:1-4:2:0:12:00:00*MW3
   ~
   1999011112:00:00
   1999020812:00:00
   1999030812:00:00
   1999041212:00:00

0*1-4:2:0:12:00:00*MW3
Jan 1 1999
Jan 1 1999
Jan 1 2000
   ~
   1999011112:00:00
   1999020812:00:00
   1999030812:00:00
   1999041212:00:00

0:1*2:0:12:00:00*MW3
Jan 1 1999
Jan 1 1999
May 1 1999
   ~
   1999011112:00:00
   1999020812:00:00
   1999030812:00:00
   1999041212:00:00

0:0:0:0:12:0:0
Jan 16 1998 at 12:00
Jan 15 1998 at 00:00
Jan 20 1998 at 00:00
   ~
   1998011500:00:00
   1998011512:00:00
   1998011600:00:00
   1998011612:00:00
   1998011700:00:00
   1998011712:00:00
   1998011800:00:00
   1998011812:00:00
   1998011900:00:00
   1998011912:00:00

0:0:0:1*12,14:0,30:0
Jan 16 1998 at 12:00
Jan 15 1998 at 00:00
Jan 20 1998 at 00:00
   ~
   1998011512:00:00
   1998011512:30:00
   1998011514:00:00
   1998011514:30:00
   1998011612:00:00
   1998011612:30:00
   1998011614:00:00
   1998011614:30:00
   1998011712:00:00
   1998011712:30:00
   1998011714:00:00
   1998011714:30:00
   1998011812:00:00
   1998011812:30:00
   1998011814:00:00
   1998011814:30:00
   1998011912:00:00
   1998011912:30:00
   1998011914:00:00
   1998011914:30:00

0:0:0:1:6*0,30:0
Jan 16 1998 at 12:00
Jan 15 1998 at 00:00
Jan 20 1998 at 00:00
   ~
   1998011506:00:00
   1998011506:30:00
   1998011612:00:00
   1998011612:30:00
   1998011718:00:00
   1998011718:30:00
   1998011900:00:00
   1998011900:30:00

2:0:0*045:0:0:0
Jan 1 1998
Jan 1 1980
Jan 1 1990
   ~
   1980021400:00:00
   1982021400:00:00
   1984021400:00:00
   1986021400:00:00
   1988021400:00:00

2:0:0*045-047:0:0:0
Jan 1 1998
Jan 1 1980
Jan 1 1990
   ~
   1980021400:00:00
   1980021500:00:00
   1980021600:00:00
   1982021400:00:00
   1982021500:00:00
   1982021600:00:00
   1984021400:00:00
   1984021500:00:00
   1984021600:00:00
   1986021400:00:00
   1986021500:00:00
   1986021600:00:00
   1988021400:00:00
   1988021500:00:00
   1988021600:00:00

2:1:0*0:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1980110100:00:00
   1982120100:00:00
   1985010100:00:00
   1987020100:00:00
   1989030100:00:00

0:0:2*2:0:0:0
Jan 16 1998
Jan  1 1998
Feb 28 1998
   ~
   1998011300:00:00
   1998012700:00:00
   1998021000:00:00
   1998022400:00:00

0:0:2*2,4:0:0:0
Jan 16 1998
Jan  1 1998
Feb 28 1998
   ~
   1998010100:00:00
   1998011300:00:00
   1998011500:00:00
   1998012700:00:00
   1998012900:00:00
   1998021000:00:00
   1998021200:00:00
   1998022400:00:00
   1998022600:00:00

0:1:0*2,31:0:0:0
Jan 1 1998
Jan 1 1998
Jul 1 1998
   ~
   1998010200:00:00
   1998013100:00:00
   1998020200:00:00
   1998030200:00:00
   1998033100:00:00
   1998040200:00:00
   1998050200:00:00
   1998053100:00:00
   1998060200:00:00

0:1:0*-2:0:0:0
Jan 1 1998
Jan 1 1998
Dec 31 1998
   ~
   1998013000:00:00
   1998022700:00:00
   1998033000:00:00
   1998042900:00:00
   1998053000:00:00
   1998062900:00:00
   1998073000:00:00
   1998083000:00:00
   1998092900:00:00
   1998103000:00:00
   1998112900:00:00
   1998123000:00:00

0:1*2,-1:0:0:0:0
Jan 1 1998
Jan 1 1998
Jul 1 1998
   ~
   1998010500:00:00
   1998011900:00:00
   1998020200:00:00
   1998021600:00:00
   1998030200:00:00
   1998032300:00:00
   1998040600:00:00
   1998042000:00:00
   1998050400:00:00
   1998052500:00:00
   1998060800:00:00
   1998062200:00:00

0:1*2,-2:2:0:0:0
Jan 1 1998
Jan 1 1998
Jul 1 1998
   ~
   1998011300:00:00
   1998012000:00:00
   1998021000:00:00
   1998021700:00:00
   1998031000:00:00
   1998032400:00:00
   1998041400:00:00
   1998042100:00:00
   1998051200:00:00
   1998051900:00:00
   1998060900:00:00
   1998062300:00:00

2:0*10:0:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1981030200:00:00
   1983030700:00:00
   1985030400:00:00
   1987030200:00:00
   1989030600:00:00

2:0*10:2:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1981030300:00:00
   1983030800:00:00
   1985030500:00:00
   1987030300:00:00
   1989030700:00:00

2*3:0:2,30:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1981030200:00:00
   1981033000:00:00
   1983030200:00:00
   1983033000:00:00
   1985030200:00:00
   1985033000:00:00
   1987030200:00:00
   1987033000:00:00
   1989030200:00:00
   1989033000:00:00

2*3:0:0:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1981030100:00:00
   1983030100:00:00
   1985030100:00:00
   1987030100:00:00
   1989030100:00:00

3*2,5:2,-2:0:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1982020800:00:00
   1982021500:00:00
   1982050300:00:00
   1982051700:00:00
   1985020400:00:00
   1985021100:00:00
   1985050600:00:00
   1985051300:00:00
   1988020800:00:00
   1988021500:00:00
   1988050200:00:00
   1988051600:00:00

3*2,5:2:2:0:0:0
Jan 1 1985
Jan 1 1980
Jan 1 1990
   ~
   1982020900:00:00
   1982051100:00:00
   1985021200:00:00
   1985051400:00:00
   1988020900:00:00
   1988051000:00:00

*1990,1992:0:0:45:0:0:0
   ~
   1990021400:00:00
   1992021400:00:00

*1990,1992:0:0:0:0:0:0
   ~
   1990010100:00:00
   1992010100:00:00

*1990,1992:5:0:0:0:0:0
   ~
   1990050100:00:00
   1992050100:00:00

*1990,1992:5:0:12:0:0:0
   ~
   1990051200:00:00
   1992051200:00:00

*1998:0:12,14:0:0:0:0
   ~
   1998031600:00:00
   1998033000:00:00

*1998:0:12,14:2:0:0:0
   ~
   1998031700:00:00
   1998033100:00:00

*1998:2:2,-2:0:0:0:0
   ~
   1998020200:00:00
   1998020900:00:00

*1998:2:2,-2:2:0:0:0
   ~
   1998021000:00:00
   1998021700:00:00

*1998:2:2,-2:2:0:0:0
1998021000:00:00
1998021000:00:00
1998021200:00:00
   ~
   1998021000:00:00

";

print "ParseRecur...\n";
&test_Func($ntest,\&ParseRecur,$tests,$runtests);

1;
