<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
  <head>
    <title>Bienvenido a JWChat</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <script src="config.js" language="JavaScript1.2"></script>
    <script src="browsercheck.js" language="JavaScript1.2"></script>
    <script src="shared.js" language="JavaScript1.2"></script>
    <script src="switchStyle.js"></script>
    <script src="sha1.js"></script>
    <script language="JavaScript">
<!--

 /*
  * JWChat, a web based jabber client
  * Copyright (C) 2003-2004 Stefan Strigler <steve@zeank.in-berlin.de>
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  *
  * Please visit http://jwchat.sourceforge.net for more information!
  */

var jid, pass, register;
var jwchats = new Array();

var JABBERSERVER;
var HTTPBASE;
var BACKEND_TYPE;

function loginCheck(form) { /* check if user want's to register new
																 account and things */
	if (form.jid.value == '') {
		alert("Tienes que proporcionar un nombre de usuario");
		return false;
	}

	if (form.pass.value == '') {
		alert("Tienes que proporcionar una contraseña");
		return false;
	}

	if (document.getElementById('tr_server').style.display != 'none') {
		var val = document.getElementById('server').value;
		if (val == '') {
			alert("You need to supply a jabber server");
			return false;
		}

		JABBERSERVER = val;
	}

  jid = form.jid.value + "@" + JABBERSERVER + "/";
	if (form.res.value != '')
		jid += form.res.value;
	else
		jid += DEFAULTRESOURCE;

  if(!isValidJID(jid))
    return false;

	if (jwchats[jid] && !jwchats[jid].closed) {
		jwchats[jid].focus();
		return false;
	}

  pass = form.pass.value;
	register = form.register.checked;

	jwchats[jid] = window.open('jwchat.html',makeWindowName(jid),'width=180,height=390,resizable=yes');

	return false;
}

function toggleMoreOpts(show) {
	if (show) {
		document.getElementById('showMoreOpts').style.display = 'none';
		document.getElementById('showLessOpts').style.display = '';
	} else {
		document.getElementById('showLessOpts').style.display = 'none';
		document.getElementById('showMoreOpts').style.display = '';
	}

	var rows = document.getElementById('lTable').getElementsByTagName('TBODY').item(0).getElementsByTagName('TR');

	for (var i=0; i<rows.length; i++) {
		if (rows[i].className == 'moreOpts') {
			if (show)
				rows[i].style.display = '';
			else
				rows[i].style.display = 'none';
		}
	}
	return false;
}

function backendSelected() {

	var bs = document.getElementById('backend_selector');
	var servers_allowed, default_server;
	if (bs) {
		servers_allowed = BACKENDS[bs.selectedIndex].servers_allowed;
		default_server = BACKENDS[bs.selectedIndex].default_server;
		if (BACKENDS[bs.selectedIndex].description)
			document.getElementById('backend_description').innerHTML = BACKENDS[bs.selectedIndex].description;
		HTTPBASE = BACKENDS[bs.selectedIndex].httpbase;
		BACKEND_TYPE = BACKENDS[bs.selectedIndex].type;
	}	else {
		servers_allowed = BACKENDS[0].servers_allowed;
		default_server = BACKENDS[0].default_server;
		HTTPBASE = BACKENDS[0].httpbase;
		BACKEND_TYPE = BACKENDS[0].type;
	}

	if (!servers_allowed
			|| servers_allowed.length == 0) 
		{ // allow any
			var tr_server = document.getElementById('tr_server');
			
			var input = document.createElement('input');
			input.setAttribute("type","text");
			input.setAttribute("id","server");
			input.setAttribute("name","server");
			input.setAttribute("tabindex","2");
			input.className = 'input_text';

			if (default_server)
				input.setAttribute("value",default_server);

			var td = tr_server.getElementsByTagName('td').item(0);
			for (var i=0; i<td.childNodes.length; i++)
				td.removeChild(td.childNodes.item(i));
											 
			td.appendChild(input);

			tr_server.style.display = ''; 
		}
	else if (servers_allowed.length == 1) {
		document.getElementById('tr_server').style.display = 'none'
		JABBERSERVER = servers_allowed[0];
	} else { // create selectbox
		var tr_server = document.getElementById('tr_server');
		
		var oSelect = document.createElement('select');
		oSelect.setAttribute('id','server');
		oSelect.setAttribute('name','server');
		oSelect.setAttribute('tabindex',"2");

		var td = tr_server.getElementsByTagName('td').item(0);
		for (var i=0; i<td.childNodes.length; i++)
			td.removeChild(td.childNodes.item(i));

		td.appendChild(oSelect);

		for (var i in servers_allowed) {
			if (typeof(servers_allowed[i]) == 'undefined')
				continue;
			oSelect.options.add(new Option(servers_allowed[i],servers_allowed[i]));
		}

		tr_server.style.display = ''; 
	}

}


function init() {
  var welcome = "Bienvenido a JWChat en "+SITENAME;
  document.title = welcome;
  document.getElementById("welcomeh1").innerHTML = welcome;

	// create backend chooser - if any
	if (typeof(BACKENDS) == 'undefined' || BACKENDS.length == 0) {
		// ...
	} else if (BACKENDS.length == 1) {
		backendSelected();
	} else {
		// create chooser
		var oSelect = document.createElement('select');
		oSelect.setAttribute('id','backend_selector');
		oSelect.setAttribute('name','backend');
		oSelect.setAttribute('tabindex',"1");
		oSelect.onchange = backendSelected;

		var tr = document.createElement('tr');
		var td = tr.appendChild(document.createElement('th'));
		var label = td.appendChild(document.createElement('label'));
		label.setAttribute('for','backend_selector');
		label.appendChild(document.createTextNode("Choose Backend"));

		tr.appendChild(document.createElement('td')).appendChild(oSelect);

		var tr_server = document.getElementById('tr_server');
		tr_server.parentNode.insertBefore(tr,tr_server);

		tr = document.createElement('tr');
		td = tr.appendChild(document.createElement('td'));
		td = document.createElement('td');
		td.setAttribute('id','backend_description');
		td.className= 'desc';
		tr.appendChild(td);

		tr_server.parentNode.insertBefore(tr,tr_server);

		for (var i in BACKENDS) {
			if (typeof(BACKENDS[i]) == 'undefined')
				continue;
			var oOption =  new Option(BACKENDS[i].name,BACKENDS[i].httpbase);
			oOption.setAttribute('description',BACKENDS[i].description);
			oSelect.options[i] = oOption;
		}

		backendSelected();
	}
	document.forms[0].jid.focus();
	document.getElementById('login_button').disabled = false;
}


onload = init;
//-->
    </script>
    <style type="text/css">
			body {
			color: #2a3847;
			background-color: white;
			}

			th {
			font-size: 0.8em;
			text-align: right;
			white-space: nowrap;
			}

			a { color: #2a3847; } 

			h1 { 
			font-size: 1.4em; 
			margin-top:0px; 
			margin-bottom: 0px; 
			}

			h2 { padding-top: 0px; margin-top: 0px; }

			h3 {
			border-bottom: 1px solid #2a3847;
			margin-bottom: 0px;

			font-style: normal;
			font-variant: small-caps;

			text-align: right;
			}
			
			input.input_text {
			border: 1px solid #2a3847;
			}

			input:focus, input:hover {
			background-color: #f9fae1;
			}

      .toggleOpts { cursor: pointer; }

			.desc {
			font-size: 0.65em;
			}

			.form_spacer {
			padding-top: 20px;
			}

			#td_top {
			padding-top: 20px;
			}
			#td_form {
			padding-top: 20px;
			}
			#td_bottom {
			padding: 4px;
			font-size:8pt; 
			border-top:1px solid #2a3847;
			}
			#lTable {
			padding: 8px;

			border: 2px solid #2a3847;
			-moz-border-radius: 8px;

			background-color: #81addc;
			}
			
    </style>
  </head>
  
  <body>
			<table width="100%" height="100%">
					<tr>
						<td align=center id='td_top'>
						<table>
							<tr>
									<td>
										<h1 id="welcomeh1">Bienvenido a JWChat</h1>
										<h2>A web-based Jabber<sup><small>&reg;</small></sup> client</h2>
									</td>
								</tr>
						</table>
						</td>
					</tr>
		<form name="login" onSubmit="return loginCheck(this);">
					<tr>
						<td height="100%" align=center valign=top id='td_form'>
					<table border=0 cellspacing=0 cellpadding=2 id="lTable" align=center width=380>
					<tr>
						<td colspan=2><h3>Conectar<img src="images/available.gif" width=16 height=16></h3></td>
					</tr>
					<tr id="tr_server" style="display:none;">
						<th title="Select Jabber server to connect to"><label for='server'>Servidor</label></th>
						<td></td>
					</tr>
					<tr>
						<th class='form_spacer'><label for='jid'>Nombre</label></td>
						<td class='form_spacer' width="100%"><input type="text" id='jid' name="jid" tabindex=3 class='input_text'></td>
					</tr>
					<tr><td>&nbsp;</td><td nowrap class="desc">El Nombre de usuario no debe contener: <script>document.write(prohibited)</script></td></tr>
					<tr>
						<th><label for='pass'>Contrase&ntilde;a</label></th>
							<td><input type="password" id='pass' name="pass" tabindex=4 class='input_text'></td>
					</tr>
					<tr><td>&nbsp;</td><td><input type=checkbox name=register id=register> <label for="register">Crear esta cuenta</label></td></tr>
					<tr id="showMoreOpts" class="toggleOpts">
							<td>&nbsp;</td>
						<td onClick="return toggleMoreOpts(1);"><img src="images/group_close.gif" title="Mostrar más opciones"> Mostrar más opciones</td>
					</tr>
					<tr id="showLessOpts" class="toggleOpts" style="display:none;">
							<td>&nbsp;</td>
						<td onClick="return toggleMoreOpts(0);"><img src="images/group_open.gif" title="Mostrar menos opciones"> Mostrar menos opciones</td>
					</tr>
					<tr class="moreOpts" style="display:none;">
						<th><label for='res'>Recurso</label></th>
						<td><input type="text" id='res' name="res" class='input_text'></td>
					</tr>
					<tr class="moreOpts" style="display:none;">
						<th><label for='prio'>Prioridad</label></th>
						<td><input type="text" id='prio'  name="prio" class='input_text' disabled></td>
					</tr>
					
					<tr><td>&nbsp;</td><td><button type="submit" id='login_button' tabindex=5 disabled>Conectar</button></td></tr>
			</table>
		</form>	
		</td>
		</tr>
		<tr>
    <td id='td_bottom'>
			<a href="http://sourceforge.net/donate/index.php?group_id=92011"><img src="http://images.sourceforge.net/images/project-support.jpg" width="88" height="32" border="0" alt="Support This Project" align=right /></a>
				For details please visit <a href="http://jwchat.sourceforge.net">JWChat's Homepage</a>.
				<br>
      &copy; 2003-2005 <a href="mailto:steve@zeank.in-berlin.de">Stefan Strigler</a> - 
      <!-- Created: Wed Feb  5 15:19:17 CET 2003 -->
      <!-- hhmts start -->
Last modified: Fri May 20 15:10:14 CEST 2005
<!-- hhmts end -->
    </td>
</tr>
			</table>
  </body>
</html>
