
/*
 * queue.c -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>								 /* malloc(), free(), NULL */
#include <string.h>								 /* strlen(), strcpy() */

#include "typedefs.h"							 /* bool, TRUE, FALSE */
#include "queue.h"								 /* queue_t */

/*
 * Initialize queue.
 */
void queue_init (queue_t **queue)
{
   *queue = NULL;
}

/*
 * Add token to queue. Returns TRUE if successful, FALSE otherwise.
 */
bool queue_add (queue_t **queue,const char *track)
{
   queue_t *nw,*tmp;
   if (strlen (track) > 256) return FALSE;
   if ((nw = (queue_t *) malloc (sizeof (queue_t))) == NULL) return FALSE;
   strcpy (nw->track,track);
   nw->next = NULL;
   if (*queue == NULL)
     *queue = nw;
   else
     {
		tmp = *queue;
		while (tmp->next != NULL) tmp = tmp->next;
		tmp->next = nw;
	 }
   return TRUE;
}

/*
 * Remove first token from queue. Please make sure that track can handle
 * strings up to 256 characters.
 */
void queue_remove (queue_t **queue,char *track)
{
   queue_t *tmp;
   tmp = *queue;
   *queue = (*queue)->next;
   strcpy (track,tmp->track);
   free (tmp);
}

/*
 * Check if queue is empty. Returns TRUE if empty, FALSE if otherwise.
 */
bool queue_empty (queue_t *queue)
{
   return (queue == NULL);
}

/*
 * Destroy queue. NOTE: queue need not be initialized again.
 */
void queue_destroy (queue_t **queue)
{
   queue_t *tmp;
   while (*queue != NULL)
	 {
		tmp = *queue;
		*queue = (*queue)->next;
		free (tmp);
	 }
}

