#ifndef MVECTOR_H__
#define MVECTOR_H__

#include <jmp.h>

/** This structure is used to build call graphs.
 *  A method has one of theese to hold all method it calls.
 *  This vector class grows as neccessary.
 */
struct mvector {
    size_t size;        /** Maximum size. */
    size_t load;        /** Current element count. */
    method** methods;   /** The elements. */
};

/** Create a new mvector with can hold at least size elements. */
mvector* mvector_new (size_t size);    

/** Delete the given mvector. */
void mvector_free (mvector* mv);

/** Get the number of methods in this vector. */
inline size_t mvector_load (mvector* mv);

/** Add a new method to this vector. 
 * @return the load of the new vector. returns -1 if add failed.
 */
size_t mvector_add_method (mvector* mv, method* m);

/** search for a method in the given vector.
 * @param mv the vector to search in.
 * @param method the method to search for.
 * @return the index of the method or -1 if not found.
 */
long mvector_search (mvector* mv, method* m);

/** Get the i:th method. */
inline method* mvector_get (mvector* mv, size_t i);

#endif /* MVECTOR_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
