#!/usr/local/bin/bltwish -f

set datafile [lindex $argv 0]

toplevel .legend
wm title .legend "Legend"
wm geometry .legend +10+10
wm iconname .legend  "Legend"
raise .legend

## now we create three "views" in three windows
toplevel .xy
wm title .xy "X-Y Plane"
wm geometry .xy +60+60
wm iconname .xy  "X-Y Plane"
raise .xy

toplevel .yz
wm title .yz "Y-Z Plane"
wm geometry .yz +110+110
wm iconname .yz  "Y-Z Plane"
raise .yz

toplevel .xz
wm title .xz "X-Z Plane"
wm geometry .xz +160+160
wm iconname .xz  "X-Z Plane"
raise .xz



lower .

graph .xy.xyview -title "Top view, North is right"
graph .xz.xzview -title "Standing at East looking West"
graph .yz.yzview -title "Standing at North looking South"
graph .legend.legend -title "Color Key" -width 800 -height 600
.legend.legend legend configure -position plotarea

frame .xy.controls
frame .xz.controls
frame .yz.controls
frame .legend.controls

pack .xy.xyview .xy.controls
pack .xz.xzview .xz.controls
pack .yz.yzview .yz.controls
pack .legend.legend .legend.controls

button .xy.controls.postscript -text "Save to Postscript File" -command {
    .xy.xyview  postscript output "xy.ps"
}
button .xy.controls.quit -text "Quit" -command {exit}
pack .xy.controls.postscript .xy.controls.quit  -in .xy.controls


button .xz.controls.postscript -text "Save to Postscript File" -command {
    .xz.xzview  postscript output "xz.ps"
}
button .xz.controls.quit -text "Quit" -command {exit}
pack .xz.controls.postscript .xz.controls.quit  -in .xz.controls


button .yz.controls.postscript -text "Save to Postscript File" -command {
    .yz.yzview postscript output "yz.ps"
}

button .yz.controls.quit -text "Quit" -command {exit}
pack .yz.controls.postscript .yz.controls.quit  -in .yz.controls

button .legend.controls.quit -text "Quit" -command {exit}
pack  .legend.controls.quit  -in .legend.controls


## a set of 17 colors
set colorlist {
    red yellow green  cyan  
    PeachPuff3  RosyBrown1 IndianRed1 PaleVioletRed1
    MediumOrchid1    khaki bisque2 tan1
    aquamarine2 SteelBlue1     yellow green
    cyan  
}

set colorindex 0
set wirecount 0

# we need the "maximum" absolute value of ordinate and
#  abcissa to scale the graph

set xmax -999
set ymax -999
set zmax -999

set f [open $datafile]
while { [gets $f line ] >= 0 } {
    if { $colorindex == 16 } {
	set colorindex 0
    }
    set color [lindex $colorlist $colorindex]
    set colorindex [expr $colorindex + 1]

    # if it is a GW card, work it out
    if { [regexp  {^GW[.]*}  $line ] } {
	# found a wire so ...
	set wirecount [expr $wirecount + 1]
	regsub -all "," $line " " commaline
	set line $commaline
	scan $line "%s %d %d %f %f %f %f %f %f %f" name tag segments  \
		x0 y0 z0 x1 y1 z1 radius
#	puts "wire tag:  $tag is $segments segments from ($x0,$y0,$z0) to ($x1, $y1, $z1) with radius $radius"

	set xvec {$x0 $x1}
	set yvec {$y0 $y1}
	set zvec {$z0 $z1}

	if {[expr abs($x0) ] > $xmax} {
	    set xmax [expr abs($x0)]
	}
	if {[expr abs($x1) ] > $xmax} {
	    set xmax [expr abs($x1)]
	}
	if {[expr abs($y0) ] > $ymax} {
	    set ymax [expr abs($y0)]
	}
	if {[expr abs($y1) ] > $ymax} {
	    set ymax [expr abs($y1)]
	}
	if {[expr abs($z0) ] > $zmax} {
	    set zmax [expr abs($z0)]
	}
	if {[expr abs($z1) ] > $zmax} {
	    set zmax [expr abs($z1)]
	}
	

    .xy.xyview element  create "e$wirecount" \
	    -label ""\
	    -xdata $xvec \
	    -symbol "scross"\
	    -color $color\
	    -ydata $yvec -linewidth 3
    	

    
    .xz.xzview element  create "e$wirecount" \
	    -label "" \
	    -symbol "scross"\
	    -color $color\
	    -xdata $xvec \
	    -ydata $zvec -linewidth 3

    .yz.yzview element  create "e$wirecount" \
	    -label "" \
	    -symbol "scross"\
	    -color $color\
	    -xdata $yvec \
	    -ydata $zvec -linewidth 3

    .legend.legend  element  create "e$wirecount" \
	    -label "wire $wirecount" \
	    -symbol ""\
	    -color $color\
	    -xdata 0 \
	    -ydata 0
    }    
   
}
close $f



## we need to put circles on each graph to scale them properly
#  each of the circles needs to be of a radius that represents the
#  maximum (abcissa, ordinate) so the axes are scales the same

# create a  unit circle  
vector yDB(361)
vector xDB(361)


for {set i 0} {$i <= 360} {incr i 1} {
    set radians [expr  $i * 3.14159/180.0 ]
    set xDB($i) cos($radians)
    set yDB($i) sin($radians)
}


vector xyviewx(361)
vector xyviewy(361)

set themax $xmax
if {$themax < $ymax} {
    set themax $ymax
}

if {$themax < $zmax} {
    set themax $zmax
}

xyviewx set [xDB * $themax]
xyviewy set [yDB * $themax]

.xy.xyview element  create "f" \
	-label "" \
	-xdata xyviewx \
	-ydata xyviewy  -symbol "none"
    	
.xz.xzview element  create "g" \
	-label "" \
	-xdata xyviewx \
	-ydata xyviewy  -symbol "none"

.yz.yzview element  create "f" \
	-label "" \
	-xdata xyviewx \
	-ydata xyviewy  -symbol "none"
    








