/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package net.sf.jftp.net;

import net.sf.jftp.system.logging.Log;

import java.io.*;

import java.net.*;

import java.util.*;


/**
 *
 */
public class FtpServer extends Thread
{
    private int port = 21;
    private int dataPort = 20;

    public FtpServer()
    {
    }

    public FtpServer(int port)
    {
        this.port = port;
    }

    public void run()
    {
        try
        {
            ServerSocket listener = new ServerSocket(port);

            while(true)
            {
                Socket s = listener.accept();
                new FtpServerSocket(s);
            }
        }
        catch(IOException ioe)
        {
            Log.debug("ServerSocket error: " + ioe);
        }
    }

    public static void main(String[] args)
    {
        FtpServer server = new FtpServer(2100);
        server.start();
    }
}
