/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Interval;
import JFlex.Macros;
import JFlex.RegExp1;
import JFlex.RegExp2;
import java.util.Vector;

public class RegExp {
    int type;

    public RegExp(int type) {
        this.type = type;
    }

    public String print(String tab) {
        return tab + this.toString();
    }

    public String toString() {
        return "type = " + this.type;
    }

    public boolean isCharClass(Macros macros) {
        switch (this.type) {
            case 40: 
            case 43: 
            case 44: 
            case 47: {
                return true;
            }
            case 35: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.isCharClass(macros) && binary.r2.isCharClass(macros);
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).isCharClass(macros);
            }
        }
        return false;
    }

    public int size(Macros macros) {
        switch (this.type) {
            case 35: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros) + 2;
            }
            case 45: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros);
            }
            case 33: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) + 2;
            }
            case 34: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) + 2;
            }
            case 36: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros);
            }
            case 38: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros);
            }
            case 39: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros) * 3;
            }
            case 41: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                return ((String)unary.content).length() + 1;
            }
            case 40: 
            case 47: {
                return 2;
            }
            case 43: 
            case 44: {
                return 2;
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).size(macros);
            }
        }
        throw new Error("unknown regexp type " + this.type);
    }

    public static final String revString(String s) {
        StringBuffer b = new StringBuffer(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    public final RegExp resolveTilde(Macros macros) {
        switch (this.type) {
            case 35: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(35, binary.r1.resolveTilde(macros), binary.r2.resolveTilde(macros));
            }
            case 45: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(45, binary.r1.resolveTilde(macros), binary.r2.resolveTilde(macros));
            }
            case 33: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(33, content.resolveTilde(macros));
            }
            case 34: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(34, content.resolveTilde(macros));
            }
            case 36: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(36, content.resolveTilde(macros));
            }
            case 38: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(38, content.resolveTilde(macros));
            }
            case 39: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = ((RegExp)unary.content).resolveTilde(macros);
                RegExp1 any_star = new RegExp1(33, this.anyChar());
                RegExp1 neg = new RegExp1(38, new RegExp2(45, any_star, new RegExp2(45, content, any_star)));
                return new RegExp2(45, neg, content);
            }
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).resolveTilde(macros);
            }
        }
        throw new Error("unknown regexp type " + this.type);
    }

    public RegExp anyChar() {
        Vector<Interval> list = new Vector<Interval>();
        list.addElement(new Interval('\u0000', '\uffff'));
        return new RegExp1(43, list);
    }

    public final RegExp rev(Macros macros) {
        switch (this.type) {
            case 35: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(35, binary.r1.rev(macros), binary.r2.rev(macros));
            }
            case 45: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(45, binary.r2.rev(macros), binary.r1.rev(macros));
            }
            case 33: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(33, content.rev(macros));
            }
            case 34: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(34, content.rev(macros));
            }
            case 36: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(36, content.rev(macros));
            }
            case 38: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(38, content.rev(macros));
            }
            case 39: {
                RegExp content = this.resolveTilde(macros);
                return content.rev(macros);
            }
            case 41: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, RegExp.revString((String)unary.content));
            }
            case 40: 
            case 43: 
            case 44: 
            case 47: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).rev(macros);
            }
        }
        throw new Error("unknown regexp type " + this.type);
    }
}

