/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import org.apache.xalan.stree.SaxEventDispatch;
import org.apache.xml.utils.AttList;
import org.apache.xml.utils.NodeConsumer;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.DOMHelper;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TreeWalker {
    private ContentHandler m_contentHandler = null;
    protected DOMHelper m_dh = new DOM2Helper();
    boolean nextIsRaw = false;

    public TreeWalker(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
    }

    private final void dispatachChars(Node node) throws SAXException {
        if (node.isSupported("http://xml.apache.org/xalan/features/feed-events", "1.0")) {
            ((SaxEventDispatch)((Object)node)).dispatchCharactersEvent(this.m_contentHandler);
        } else {
            String data = ((Text)node).getData();
            this.m_contentHandler.characters(data.toCharArray(), 0, data.length());
        }
    }

    protected void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                this.m_contentHandler.endDocument();
                break;
            }
            case 1: {
                String ns = this.m_dh.getNamespaceOfNode(node);
                if (ns == null) {
                    ns = "";
                }
                this.m_contentHandler.endElement(ns, this.m_dh.getLocalNameOfNode(node), node.getNodeName());
                NamedNodeMap atts = ((Element)node).getAttributes();
                int nAttrs = atts.getLength();
                int i = 0;
                while (i < nAttrs) {
                    Node attr = atts.item(i);
                    String attrName = attr.getNodeName();
                    if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                        int index = attrName.indexOf(":");
                        String prefix = index < 0 ? "" : attrName.substring(index + 1);
                        this.m_contentHandler.endPrefixMapping(prefix);
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lh = (LexicalHandler)((Object)this.m_contentHandler);
                lh.endEntity(eref.getNodeName());
                break;
            }
        }
    }

    public ContentHandler getcontentHandler() {
        return this.m_contentHandler;
    }

    protected void startNode(Node node) throws SAXException {
        if (this.m_contentHandler instanceof NodeConsumer) {
            ((NodeConsumer)((Object)this.m_contentHandler)).setOriginatingNode(node);
        }
        switch (node.getNodeType()) {
            case 8: {
                String data = ((Comment)node).getData();
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lh = (LexicalHandler)((Object)this.m_contentHandler);
                lh.comment(data.toCharArray(), 0, data.length());
                break;
            }
            case 9: {
                this.m_contentHandler.startDocument();
                break;
            }
            case 1: {
                NamedNodeMap atts = ((Element)node).getAttributes();
                int nAttrs = atts.getLength();
                int i = 0;
                while (i < nAttrs) {
                    Node attr = atts.item(i);
                    String attrName = attr.getNodeName();
                    if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                        int index = attrName.indexOf(":");
                        String prefix = index < 0 ? "" : attrName.substring(index + 1);
                        this.m_contentHandler.startPrefixMapping(prefix, attr.getNodeValue());
                    }
                    ++i;
                }
                String ns = this.m_dh.getNamespaceOfNode(node);
                if (ns == null) {
                    ns = "";
                }
                this.m_contentHandler.startElement(ns, this.m_dh.getLocalNameOfNode(node), node.getNodeName(), new AttList(atts, this.m_dh));
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                String name = pi.getNodeName();
                if (name.equals("xslt-next-is-raw")) {
                    this.nextIsRaw = true;
                    break;
                }
                this.m_contentHandler.processingInstruction(pi.getNodeName(), pi.getData());
                break;
            }
            case 4: {
                LexicalHandler lh;
                boolean isLexH = this.m_contentHandler instanceof LexicalHandler;
                LexicalHandler lexicalHandler = lh = isLexH ? (LexicalHandler)((Object)this.m_contentHandler) : null;
                if (isLexH) {
                    lh.startCDATA();
                }
                this.dispatachChars(node);
                if (!isLexH) break;
                lh.endCDATA();
                break;
            }
            case 3: {
                String data = ((Text)node).getData();
                if (this.nextIsRaw) {
                    this.nextIsRaw = false;
                    this.m_contentHandler.processingInstruction("javax.xml.transform.disable-output-escaping", "");
                    this.dispatachChars(node);
                    this.m_contentHandler.processingInstruction("javax.xml.transform.enable-output-escaping", "");
                    break;
                }
                this.dispatachChars(node);
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                ((LexicalHandler)((Object)this.m_contentHandler)).startEntity(eref.getNodeName());
                break;
            }
        }
    }

    public void traverse(Node pos) throws SAXException {
        Node top = pos;
        while (pos != null) {
            this.startNode(pos);
            Node nextNode = pos.getFirstChild();
            while (nextNode == null) {
                this.endNode(pos);
                if (top.equals(pos)) break;
                nextNode = pos.getNextSibling();
                if (nextNode != null || (pos = pos.getParentNode()) != null && !top.equals(pos)) continue;
                if (pos != null) {
                    this.endNode(pos);
                }
                nextNode = null;
                break;
            }
            pos = nextNode;
        }
    }

    public void traverse(Node pos, Node top) throws SAXException {
        while (pos != null) {
            this.startNode(pos);
            Node nextNode = pos.getFirstChild();
            while (nextNode == null) {
                this.endNode(pos);
                if (top != null && top.equals(pos)) break;
                nextNode = pos.getNextSibling();
                if (nextNode != null || (pos = pos.getParentNode()) != null && (top == null || !top.equals(pos))) continue;
                nextNode = null;
                break;
            }
            pos = nextNode;
        }
    }
}

