/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.XPathProcessorException;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionHandlerGeneral
extends ExtensionHandler {
    private String m_scriptSrc;
    private String m_scriptSrcURL;
    private Hashtable m_functions = new Hashtable();
    private Hashtable m_elements = new Hashtable();
    private Object m_mgr;
    private Object m_engine;
    private static final String BSF_MANAGER = "com.ibm.bsf.BSFManager";
    private static Class managerClass;
    private static Method mgrLoadScriptingEngine;
    private static final String BSF_ENGINE = "com.ibm.bsf.BSFEngine";
    private static Method engineExec;
    private static Method engineCall;
    private static final Integer NEG1INT;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    static {
        NEG1INT = new Integer(-1);
        try {
            managerClass = Class.forName(BSF_MANAGER);
            mgrLoadScriptingEngine = managerClass.getMethod("loadScriptingEngine", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExtensionHandlerGeneral.class$("java.lang.String")));
            Class<?> engineClass = Class.forName(BSF_ENGINE);
            engineExec = engineClass.getMethod("exec", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExtensionHandlerGeneral.class$("java.lang.String")), Integer.TYPE, Integer.TYPE, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ExtensionHandlerGeneral.class$("java.lang.Object")));
            engineCall = engineClass.getMethod("call", class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ExtensionHandlerGeneral.class$("java.lang.Object")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExtensionHandlerGeneral.class$("java.lang.String")), Class.forName("[Ljava.lang.Object;"));
        }
        catch (Exception e) {
            managerClass = null;
            mgrLoadScriptingEngine = null;
            engineExec = null;
            engineCall = null;
            e.printStackTrace();
        }
    }

    public ExtensionHandlerGeneral(String namespaceUri, StringVector elemNames, StringVector funcNames, String scriptLang, String scriptSrcURL, String scriptSrc) throws TransformerException {
        super(namespaceUri, scriptLang);
        String tok;
        int i;
        int n;
        Object junk;
        if (elemNames != null) {
            junk = new Object();
            n = elemNames.size();
            i = 0;
            while (i < n) {
                tok = elemNames.elementAt(i);
                this.m_elements.put(tok, junk);
                ++i;
            }
        }
        if (funcNames != null) {
            junk = new Object();
            n = funcNames.size();
            i = 0;
            while (i < n) {
                tok = funcNames.elementAt(i);
                this.m_functions.put(tok, junk);
                ++i;
            }
        }
        this.m_scriptSrcURL = scriptSrcURL;
        this.m_scriptSrc = scriptSrc;
        if (this.m_scriptSrcURL != null) {
            throw new TransformerException("src attribute not yet supported for " + scriptLang);
        }
        if (managerClass == null) {
            throw new TransformerException("Could not initialize BSF manager");
        }
        try {
            this.m_mgr = managerClass.newInstance();
            this.m_engine = mgrLoadScriptingEngine.invoke(this.m_mgr, scriptLang);
            engineExec.invoke(this.m_engine, "XalanScript", NEG1INT, NEG1INT, this.m_scriptSrc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException("Could not compile extension", e);
        }
    }

    public Object callFunction(String funcName, Vector args, Object methodKey, ExpressionContext exprContext) throws TransformerException {
        try {
            Object[] argArray = new Object[args.size()];
            int i = 0;
            while (i < argArray.length) {
                Object o = args.elementAt(i);
                argArray[i] = o instanceof XObject ? ((XObject)o).object() : o;
                ++i;
            }
            return engineCall.invoke(this.m_engine, null, funcName, argArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.startsWith("Stopping after fatal error:")) {
                    msg = msg.substring("Stopping after fatal error:".length());
                }
                throw new TransformerException(e);
            }
            throw new TransformerException("Could not create extension: " + funcName + " because of: " + e);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public boolean isElementAvailable(String element) {
        return this.m_elements.get(element) != null;
    }

    public boolean isFunctionAvailable(String function) {
        return this.m_functions.get(function) != null;
    }

    public void processElement(String localPart, Element element, TransformerImpl transformer, Stylesheet stylesheetTree, Node sourceTree, Node sourceNode, QName mode, Object methodKey) throws TransformerException, IOException {
        Object result = null;
        XSLProcessorContext xpc = new XSLProcessorContext(transformer, stylesheetTree, sourceTree, sourceNode, mode);
        try {
            Vector<Object> argv = new Vector<Object>(2);
            argv.addElement(xpc);
            argv.addElement(element);
            result = this.callFunction(localPart, argv, methodKey, transformer.getXPathContext());
        }
        catch (XPathProcessorException e) {
            throw new TransformerException(e.getMessage(), e);
        }
        if (result != null) {
            xpc.outputToResultTree(stylesheetTree, result);
        }
    }
}

