/* ------------------------------------------------------------------------
 * $Id: Store.cc,v 1.2 2001/06/29 15:00:43 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- Zorn Includes
#include "Store.hh"

// -- Code Segment

Zorn::Store::Store() 
{
    // empty
}

Zorn::Store::~Store() 
{
    // empty
}

void Zorn::Store::set(const std::string &id, const Value &value)
{
    _store[id] = value;
}

const Zorn::Value &Zorn::Store::get(const std::string &id)
{
    static Value emptyValue; 
    
    // First, lookup the identifier
    std::map<std::string, Value>::iterator i = _store.find(id);
    if (i == _store.end()) 
	return emptyValue;
    return i->second;
}

bool Zorn::Store::exists(const std::string &id) const 
{
    std::map<std::string, Value>::const_iterator i = _store.find(id);
    return (i != _store.end());
}

void Zorn::Store::remove(const std::string &id)
{
    // @@@ What happens here if the id is not present?
    _store.erase(id);
}

void Zorn::Store::dump(std::ostream &os) const
{
    std::map<Value::type_t, std::string> types;
    types[Value::type_int] 	= "integer";
    types[Value::type_string]	= "string";
    types[Value::type_bool]	= "boolean";
    types[Value::type_double]	= "real";
    
    // Dump the contents of the store to the output stream
    for (std::map<std::string, Value>::const_iterator i = _store.begin();
	 i != _store.end(); i++) {

	// Emit the variable name and type
	const Value &value = i->second;
	os << i->first << " (" << types[value.getType()] << ") = "
	   << value << std::endl;
    }
}
