/* ------------------------------------------------------------------------
 * $Id: ErrorHandler.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXErrorHandler_hh_
#define _SAXErrorHandler_hh_

// -- System Includes
#include <string>

// -- Local Includes
//#include "Celsius/SAX/SAXException.hh"

namespace SAX {

    // -- Forward Declarations
    class ParseException;

    // -- Class Declarations
    
    /**
     * Basic interface for SAX error handlers. 
     **/
    class ErrorHandler {
    public:
	
	/**
	 * Constructor.
	 **/
	ErrorHandler() { }
	
	/**
	 * Destructor.
	 **/
	virtual ~ErrorHandler() { }
	
	/**
	 * Receive notification of a warning. 
	 *
	 * @param e warning information encapsulated in a SAX parse
	 *          exception.
	 **/
	virtual void warning(const ParseException &e) = 0;

	/**
	 * Receive notification of a recoverable error. 
	 *
	 * @param e error information encapsulated in a SAX parse
	 *          exception.
	 **/
	virtual void error(const ParseException &e) = 0;

	/**
	 * Receive notification of a fatal error.
	 *
	 * @param e error information encapsulated in a SAX parse
	 *          exception.
	 **/
	virtual void fatalError(const ParseException &e) = 0;
    };

};

#endif /* ErrorHandler.hh */
