#include "guicast.h"
#include "keys.h"
#include "vframe.h"
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <unistd.h>


class TestWindow : public BC_Window
{
public:
	TestWindow() : BC_Window("test", 
				0,
				0,
				320, 
				240)
	{
		current_cursor = 0;
	};

	int close_event()
	{
		set_done(0);
		return 1;
	};

	int keypress_event()
	{
		switch(get_keypress())
		{
			case UP:
				current_cursor += 2;
				if(current_cursor >= XC_num_glyphs) current_cursor = 0;
				break;
			
			case DOWN:
				current_cursor -= 2;
				if(current_cursor <= 0) current_cursor = XC_num_glyphs - 2;
				break;
		}
		printf("%d\n", current_cursor);
		set_x_cursor(current_cursor);
	}
	
	int current_cursor;
};

int main(int argc, char *argv[])
{
	TestWindow window;
	int angles[] = { 180, 0 };
	float values[] = { 1, 0 };

	window.add_tool(new BC_Pan(10, 
		120, 
		100, 
		1, 
		2, 
		angles, 
		-1, 
		-1,
		values));
	window.add_tool(new BC_TextBox(10, 10, 200, 5, "Mary Egbert\nhad a little lamb."));
	window.run_window();
}
