/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

class ScrollImage
extends Panel
implements CbScrollbarCallback {
    Image img;
    int imgw;
    int imgh;
    int pw;
    int ph;
    CbScrollbar vsc;
    CbScrollbar hsc;
    boolean compute_scrollbars = true;

    ScrollImage(Image image) {
        this(image, Util.getWidth(image), Util.getHeight(image));
    }

    ScrollImage(Image image, int n, int n2) {
        this.pw = n;
        this.ph = n2;
        this.setLayout(new BorderLayout());
        this.vsc = new CbScrollbar(0, this);
        this.add("East", this.vsc);
        this.hsc = new CbScrollbar(1, this);
        this.add("South", this.hsc);
        this.setImage(image);
    }

    void setImage(Image image) {
        this.img = image;
        if (this.img != null) {
            this.imgw = Util.getWidth(this.img);
            this.imgh = Util.getHeight(this.img);
        }
        this.compute_scrollbars = true;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = this.size().width - this.vsc.size().width;
        int n2 = this.size().height - this.hsc.size().height;
        if (this.compute_scrollbars) {
            if (this.img == null) {
                this.hsc.setValues(0, 1, 1);
                this.vsc.setValues(0, 1, 1);
            } else {
                if (this.imgw < n) {
                    this.hsc.setValues(0, 1, 1);
                } else {
                    this.hsc.setValues(0, n, this.imgw);
                }
                if (this.imgh < n2) {
                    this.vsc.setValues(0, 1, 1);
                } else {
                    this.vsc.setValues(0, n2, this.imgh);
                }
            }
            this.compute_scrollbars = false;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n, n2);
        if (this.img != null) {
            if (this.imgw < n && this.imgh < n2) {
                graphics.drawImage(this.img, (n - this.imgw) / 2, (n2 - this.imgh) / 2, this);
                return;
            }
            graphics.drawImage(this.img, -this.hsc.getValue(), -this.vsc.getValue(), this);
            return;
        }
        graphics.setFont(Util.f);
        graphics.setColor(Color.black);
        String string = "<None>";
        graphics.drawString(string, (n - Util.fnm.stringWidth(string)) / 2, (n2 - Util.fnm.getHeight()) / 2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.compute_scrollbars = true;
        this.repaint();
    }

    public void moved(CbScrollbar cbScrollbar, int n) {
        this.repaint();
    }

    public void moving(CbScrollbar cbScrollbar, int n) {
    }

    public Dimension minimumSize() {
        return new Dimension(this.pw, this.ph);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }
}

