/*
Copyright (c) 1998, 1999, 2000 Wabasoft  All rights reserved.

This software is furnished under a license and may be used only in accordance
with the terms of that license. This software and documentation, and its
copyrights are owned by Wabasoft and are protected by copyright law.

THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT WARRANTY
AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY PARTICULAR PURPOSE,
OR AGAINST INFRINGEMENT. WABASOFT ASSUMES NO RESPONSIBILITY FOR THE USE OR
INABILITY TO USE THIS SOFTWARE. WABASOFT SHALL NOT BE LIABLE FOR INDIRECT,
SPECIAL OR CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT.

WABASOFT SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE ALTERED,
MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES RESULTING FROM
ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE TO THE MALFUNCTION OF
YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY WABASOFT.
*/

package waba.ui;

import waba.fx.*;
import waba.sys.Vm;

/**
 * ToolBar is a bar of controls.
 * <p>
 * Here is an example showing a tool bar being used:
 *
 * <pre>
 * public class MyProgram extends MainWindow
 * {
 * Button btnOne;
 * Button btnTwo;
 *
 * public void onStart()
 *  {
 *  ToolBar toolBar = new ToolBar();
 *  btnOne = new Button("One");
 *  toolBar.add(btnOne);
 *  btnTwo = new Button("Two");
 *  toolBar.add(btnTwo);
 *  add(toolBar);
 *  }
 *
 * public void onEvent(Event event)
 *  {
 *  if (event.type == ControlEvent.PRESSED &&
 *      event.target == btnOne)
 *   {
 *   ... handle tab one being pressed
 * </pre>
 */

public class ToolBar extends Container
{
    final int   TOOLBAR_ICON_SPACING = 4;

    ScrollPane  toolBarCntnr;

    Color       toolBarColor; //Not used for now

    int         toolBarWidth;
    int         toolBarHeight;

    int         cntrlX_Offset;
    int         toolBarVerticalOffset;



    /** Constructs a tool bar control. */
    public ToolBar()
    {
        MainWindow win  = MainWindow.getMainWindow();
        Rect rect       = win.getRect();

        toolBarWidth    = rect.width;
    	toolBarHeight   = 18; //default height

    	toolBarVerticalOffset   = 1;

        toolBarCntnr    = new ScrollPane(0, toolBarVerticalOffset, toolBarWidth, toolBarHeight, true, false);
        toolBarCntnr.setHorizontalScrolllIncrement(16);
        
    	this.setRect(0, toolBarVerticalOffset, toolBarWidth, toolBarHeight);
    	 	
    	super.add(toolBarCntnr);
    }



    /** Constructs a tool bar control. */
    public ToolBar(int passedToolBarHeight, int passedToolBarVerticalOffset)
    {
        MainWindow win  = MainWindow.getMainWindow();
        Rect rect       = win.getRect();

        toolBarWidth    = rect.width;
    	toolBarHeight   = passedToolBarHeight; //user specified height

    	toolBarVerticalOffset = passedToolBarVerticalOffset;

    	toolBarCntnr    = new ScrollPane(0, toolBarVerticalOffset, toolBarWidth, toolBarHeight, false, true);
    	    	
    	this.setRect(0, toolBarVerticalOffset, toolBarWidth, toolBarHeight);
    	
    	super.add(toolBarCntnr);
    }



    /** Adds a control to the tool bar.*/
    
    public void addControl(Control control)
    {
        Rect cntrlRect = control.getRect();

        control.setRect(cntrlX_Offset, toolBarVerticalOffset, cntrlRect.width, cntrlRect.height);
        
        cntrlX_Offset += (control.width + TOOLBAR_ICON_SPACING);
        
        toolBarCntnr.addControl(control);
    }
}


