#ifndef __NMPALM_C_H__
#define __NMPALM_C_H__

#define C_SECTION  __attribute__ ((section ("c")))

/*
Copyright (C) 1998, 1999, 2000 Wabasoft

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
*/

// NOTE: General rule for native functions.. don't hold a pointer across any
// call that could garbage collect. For example, this isn't good:
//
// ptr = WOBJ_arrayStart(array)
// ...
// string = createString(..)
// ptr[0]
//
// since the createString() could GC, the ptr inside of array could be invalid
// after the call since a GC would move memory around. Instead, use:
//
// ptr = WOBJ_arrayStart(array)
// ...
// string = createString(..)
// ...
// ptr = WOBJ_arrayStart(array)
// ptr[0]
//
// to recompute the pointer after the possible GC

// NOTE: If you subclass a class with an object destroy function, you must
// explicity call your superclasses object destroy function.

#include <SerialMgrOld.h>
#include <FileStream.h>
#include <Bitmap.h>

void GraphicsDestroy(WObject obj) C_SECTION;
void ImageDestroy(WObject obj) C_SECTION;
void CatalogDestroy(WObject obj) C_SECTION;
void SocketDestroy(WObject obj) C_SECTION;
void SerialPortDestroy(WObject obj) C_SECTION;

Var ImageCreate(Var stack[]) C_SECTION;

extern ClassHook classHooks[];

#define FUNC(f) extern Var f (Var stack[]) C_SECTION

/* some generic functions */
FUNC(Return0Func);
FUNC(ReturnNeg1Func);

/* all the native functions */

/*
FUNC(VmPrintLn);
FUNC(VmPrint);
*/

#define VmPrint Return0Func
#define VmPrintLn Return0Func

FUNC(VmExec);
FUNC(VmGetTimeStamp);
FUNC(copyArray);
FUNC(VmSleep);
FUNC(VmSetDeviceAutoOff);
FUNC(VmGetUserName);
FUNC(VmGetPlatform);
FUNC(VmIsColor);
/*
FUNC(FileGetLength);
FUNC(FileCreateDir);
FUNC(FileReadBytes);
FUNC(FileRename);
FUNC(FileCreate);
FUNC(FileWriteBytes);
FUNC(FileListDir);
FUNC(FileSeekWaba);
FUNC(FileIsDir);
FUNC(FileCloseWaba);
FUNC(FileIsOpen);
FUNC(FileDeleteWaba);
FUNC(FileExists);
*/

#define FileGetLength Return0Func
#define FileCreateDir Return0Func
#define FileReadBytes ReturnNeg1Func
#define FileCreate Return0Func
#define FileWriteBytes ReturnNeg1Func
#define FileListDir Return0Func
#define FileIsDir Return0Func
#define FileCloseWaba Return0Func
#define FileDeleteWaba Return0Func
#define FileExists Return0Func
#define FileIsOpen Return0Func
#define FileSeekWaba Return0Func
#define FileRename Return0Func

FUNC(ImageCreate);
FUNC(ImageFree);
FUNC(ImageSetPixels);
FUNC(ImageUseImagePalette);
FUNC(ImageLoad);
FUNC(SoundBeep);
FUNC(SoundTone);
FUNC(TimeCreate);
FUNC(SocketCreate);
FUNC(SocketRead);
FUNC(SocketWrite);
FUNC(SocketSetReadTimeout);
FUNC(SocketClose);
FUNC(SocketIsOpen);
FUNC(WindowCreate);
FUNC(CatalogListCatalogs);
FUNC(CatalogAddRecord);
FUNC(CatalogSkipBytes);
FUNC(CatalogCreate);
FUNC(CatalogRead);
FUNC(CatalogDeleteRecord);
FUNC(CatalogSetRecordPos);
FUNC(CatalogGetRecordSize);
FUNC(CatalogResizeRecord);
FUNC(CatalogWrite);
FUNC(CatalogGetRecordCount);
FUNC(CatalogClose);
FUNC(CatalogIsOpen);
FUNC(CatalogDelete);
FUNC(GraphicsCopyRect);
FUNC(GraphicsClearClip);
FUNC(GraphicsSetFont);
FUNC(GraphicsSetDrawOp);
FUNC(GraphicsSetClip);
FUNC(GraphicsSetBackColor);
FUNC(GraphicsSetColor);
FUNC(GraphicsGetClip);
FUNC(GraphicsFillRect);
FUNC(GraphicsDrawLine);
FUNC(GraphicsTranslate);
FUNC(GraphicsDrawDots);
FUNC(GraphicsDrawChars);
FUNC(GraphicsCreate);
FUNC(GraphicsDrawCursor);
FUNC(GraphicsSetClip);

/*
FUNC(GraphicsFree);
*/

#define GraphicsFree Return0Func

FUNC(GraphicsSetForeColor);
FUNC(GraphicsSetTextColor);
FUNC(GraphicsFillPolygon);
FUNC(GraphicsDrawString);
FUNC(ConvertStringToInt);
FUNC(ConvertFloatToIntBitwise);
FUNC(ConvertCharToString);
FUNC(ConvertIntToFloatBitwise);
FUNC(ConvertFloatToString);
FUNC(ConvertIntToString);
FUNC(ConvertBooleanToString);

/*
FUNC(SoundClipPlay);
*/

#define SoundClipPlay Return0Func

#define VmPrint Return0Func

FUNC(PalmOsPrefSetPalmOsPref);
FUNC(PalmOsPrefGetPalmOsPref);
FUNC(MainWinCreate);
FUNC(MainWinExit);
FUNC(MainWinSetTimerInterval);
FUNC(SerialPortReadCheck);
FUNC(SerialPortRead);
FUNC(SerialPortWrite);
FUNC(SerialPortSetReadTimeout);
FUNC(SerialPortClose);
FUNC(SerialPortSetFlowControl);
FUNC(SerialPortIsOpen);
FUNC(SerialPortCreate);
FUNC(FontMetricsGetStringWidth);
FUNC(FontMetricsGetCharWidth);
FUNC(FontMetricsCreate);
FUNC(FontMetricsGetCharArrayWidth);

#endif /* __NMPALM_C_H__ */

/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
