/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

class Invoker
implements XmlRpcHandler {
    private Object invokeTarget;
    private Class targetClass;

    public Invoker(Object object) {
        this.invokeTarget = object;
        Class<?> clazz = this.targetClass = this.invokeTarget instanceof Class ? (Class<?>)this.invokeTarget : this.invokeTarget.getClass();
        if (XmlRpc.debug) {
            System.err.println("Target object is " + this.targetClass);
        }
    }

    public Object execute(String string, Vector vector) throws Exception {
        Class[] classArray = null;
        Object[] objectArray = null;
        if (vector != null) {
            classArray = new Class[vector.size()];
            objectArray = new Object[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                objectArray[n] = vector.elementAt(n);
                classArray[n] = objectArray[n] instanceof Integer ? Integer.TYPE : (objectArray[n] instanceof Double ? Double.TYPE : (objectArray[n] instanceof Boolean ? Boolean.TYPE : objectArray[n].getClass()));
                ++n;
            }
        }
        Method method = null;
        if (XmlRpc.debug) {
            System.err.println("Searching for method: " + string);
            int n = 0;
            while (n < classArray.length) {
                System.err.println("Parameter " + n + ": " + classArray[n] + " = " + objectArray[n]);
                ++n;
            }
        }
        try {
            method = this.targetClass.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw noSuchMethodException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        Object object = null;
        try {
            object = method.invoke(this.invokeTarget, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (XmlRpc.debug) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            throw new Exception(invocationTargetException.getTargetException().toString());
        }
        return object;
    }
}

