/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.File;
import org.apache.log4j.helpers.LogLog;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected String filename;
    protected long delay = 60000L;
    File file;
    long lastModif = 0L;
    boolean warnedAlready = false;

    public void setDelay(long l) {
        this.delay = l;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        if (this.file.exists()) {
            long l = this.file.lastModified();
            if (l > this.lastModif) {
                this.lastModif = l;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LogLog.debug("[" + this.filename + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    public void run() {
        while (!Thread.interrupted()) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }

    protected FileWatchdog(String string) {
        this.filename = string;
        this.file = new File(string);
        this.setDaemon(true);
        this.checkAndConfigure();
    }
}

