/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Dispatcher;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.BoundedFIFO;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    static final int BUFFER_SIZE = 128;
    BoundedFIFO bf = new BoundedFIFO(128);
    AppenderAttachableImpl aai = new AppenderAttachableImpl();
    Dispatcher dispatcher = new Dispatcher(this.bf, this.aai);
    boolean locationInfo = false;

    public synchronized void addAppender(Appender appender) {
        this.aai.addAppender(appender);
    }

    public void append(LoggingEvent loggingEvent) {
        loggingEvent.getNDC();
        loggingEvent.getThreadName();
        if (this.locationInfo) {
            loggingEvent.setLocationInformation();
        }
        BoundedFIFO boundedFIFO = this.bf;
        synchronized (boundedFIFO) {
            if (this.bf.isFull()) {
                try {
                    this.bf.wait();
                }
                catch (InterruptedException interruptedException) {
                    LogLog.error("AsyncAppender cannot be interrupted.", interruptedException);
                }
            }
            this.bf.put(loggingEvent);
            if (this.bf.wasEmpty()) {
                this.bf.notify();
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.dispatcher.interrupt();
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException interruptedException) {
            LogLog.error("Got an InterruptedException while waiting for the dispatcher to finish.", interruptedException);
        }
        this.dispatcher = null;
        this.bf = null;
    }

    public Enumeration getAllAppenders() {
        return this.aai.getAllAppenders();
    }

    public Appender getAppender(String string) {
        return this.aai.getAppender(string);
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{LOCATION_INFO_OPTION});
    }

    public boolean requiresLayout() {
        return false;
    }

    public synchronized void removeAllAppenders() {
        this.aai.removeAllAppenders();
    }

    public synchronized void removeAppender(Appender appender) {
        this.aai.removeAppender(appender);
    }

    public synchronized void removeAppender(String string) {
        this.aai.removeAppender(string);
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        super.setOption(string, string2);
        if (string.equals(LOCATION_INFO_OPTION)) {
            this.locationInfo = OptionConverter.toBoolean(string2, this.locationInfo);
        }
    }

    public AsyncAppender() {
        this.dispatcher.start();
    }
}

