/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.util.Accessor;
import org.webmacro.util.ArrayIterator;
import org.webmacro.util.BinaryMethodAccessor;
import org.webmacro.util.DirectAccessor;
import org.webmacro.util.EnumIterator;
import org.webmacro.util.FieldAccessor;
import org.webmacro.util.Log;
import org.webmacro.util.MethodAccessor;
import org.webmacro.util.PropertyException;
import org.webmacro.util.PropertyMethod;
import org.webmacro.util.RefMap;
import org.webmacro.util.UnaryMethodAccessor;

public final class PropertyOperator {
    static final boolean _debug = false;
    static final Log _log = new Log("prop", "Property Introspection");
    private static RefMap _operators = new RefMap();
    private final HashMap _unaryAccessors = new HashMap();
    private final HashMap _binaryAccessors = new HashMap();
    private final HashMap _directAccessors = new HashMap();
    private BinaryMethodAccessor _hashAccessor;
    private Method iteratorMethod = null;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Enumeration;

    public static final Object getProperty(Context context, Object object, Object[] objectArray, int n) throws PropertyException, SecurityException, ContextException {
        try {
            if (object == null) {
                return null;
            }
            return PropertyOperator.getOperator(object.getClass()).getProperty(context, object, objectArray, n, objectArray.length - 1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _log.exception(noSuchMethodException);
            throw new PropertyException("No method to access property: " + noSuchMethodException, noSuchMethodException);
        }
    }

    public static final Object getProperty(Context context, Object object, Object[] objectArray) throws PropertyException, SecurityException, ContextException {
        return PropertyOperator.getProperty(context, object, objectArray, 0);
    }

    public static final boolean setProperty(Context context, Object object, Object[] objectArray, int n, Object object2) throws PropertyException, SecurityException, ContextException {
        try {
            if (object == null) {
                return false;
            }
            return PropertyOperator.getOperator(object.getClass()).setProperty(context, object, objectArray, object2, n);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PropertyException("No method to access property: " + noSuchMethodException, noSuchMethodException);
        }
    }

    public static final boolean setProperty(Context context, Object object, Object[] objectArray, Object object2) throws PropertyException, SecurityException, ContextException {
        return PropertyOperator.setProperty(context, object, objectArray, 0, object2);
    }

    public static final Iterator getIterator(Object object) throws PropertyException {
        if (object instanceof Object[]) {
            return new ArrayIterator((Object[])object);
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Enumeration) {
            return new EnumIterator((Enumeration)object);
        }
        return PropertyOperator.getOperator(object.getClass()).findIterator(object);
    }

    private static PropertyOperator getOperator(Class clazz) throws PropertyException {
        PropertyOperator propertyOperator = (PropertyOperator)_operators.get(clazz);
        if (propertyOperator == null) {
            RefMap refMap = _operators;
            synchronized (refMap) {
                try {
                    propertyOperator = new PropertyOperator(clazz);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                _operators.put(clazz, propertyOperator);
            }
        }
        return propertyOperator;
    }

    private void getAllMethods(HashMap hashMap, Class clazz) throws SecurityException {
        int n;
        GenericDeclaration[] genericDeclarationArray;
        if (Modifier.isPublic(clazz.getModifiers())) {
            genericDeclarationArray = clazz.getDeclaredMethods();
            n = 0;
            while (n < genericDeclarationArray.length) {
                if (Modifier.isPublic(((Method)genericDeclarationArray[n]).getModifiers())) {
                    this.addMethod(hashMap, (Method)genericDeclarationArray[n]);
                }
                ++n;
            }
        }
        genericDeclarationArray = clazz.getInterfaces();
        n = 0;
        while (n < genericDeclarationArray.length) {
            this.getAllMethods(hashMap, (Class)genericDeclarationArray[n]);
            ++n;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.getAllMethods(hashMap, clazz2);
        }
    }

    private int precedes(Class[] classArray, Class[] classArray2) {
        if (classArray.length == classArray2.length) {
            int n = 0;
            while (n < classArray.length) {
                if (!classArray2[n].equals(classArray[n])) {
                    if (classArray[n].isAssignableFrom(classArray2[n])) {
                        return 1;
                    }
                    if (classArray2[n].isAssignableFrom(classArray[n])) {
                        return -1;
                    }
                    return 1;
                }
                ++n;
            }
            return 0;
        }
        return classArray.length < classArray2.length ? -1 : 1;
    }

    private void addMethod(HashMap hashMap, Method method) {
        Vector<Object> vector;
        String string = method.getName();
        Object v = hashMap.get(string);
        if (v == null) {
            hashMap.put(string, method);
            return;
        }
        if (v instanceof Method) {
            vector = new Vector<Object>();
            vector.addElement(v);
            hashMap.put(string, vector);
        } else {
            vector = (Vector<Object>)v;
        }
        Class[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < vector.size()) {
            Class[] classArray2 = ((Method)vector.elementAt(n)).getParameterTypes();
            int n2 = this.precedes(classArray, classArray2);
            if (n2 < 0) {
                vector.insertElementAt(method, n);
                return;
            }
            if (n2 == 0) {
                return;
            }
            ++n;
        }
        vector.addElement(method);
    }

    private Vector getMethods(Class clazz) {
        Vector<Object> vector = new Vector<Object>();
        HashMap hashMap = new HashMap();
        this.getAllMethods(hashMap, clazz);
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof Method) {
                vector.addElement(v);
                continue;
            }
            Vector vector2 = (Vector)v;
            int n = 0;
            while (n < vector2.size()) {
                vector.addElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector;
    }

    private PropertyOperator(Class clazz) throws SecurityException, PropertyException {
        Accessor accessor;
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n].getModifiers())) {
                accessor = new FieldAccessor(fieldArray[n]);
                this._unaryAccessors.put(accessor.getName(), accessor);
            }
            ++n;
        }
        Vector vector = this.getMethods(clazz);
        int n2 = 0;
        while (n2 < vector.size()) {
            Class<?> clazz2;
            Class clazz3;
            boolean bl;
            Method method = (Method)vector.elementAt(n2);
            String string = method.getName();
            Class[] classArray = method.getParameterTypes();
            int n3 = classArray.length;
            accessor = (Accessor)this._directAccessors.get(string);
            if (accessor != null) {
                ((DirectAccessor)accessor).addMethod(method, classArray);
            } else {
                accessor = new DirectAccessor(string, method, classArray);
                this._directAccessors.put(string, accessor);
            }
            if (string.startsWith("get") || string.startsWith("set") || string.equals("put")) {
                String string2 = string.substring(3);
                if (n3 == 0 && string.startsWith("get") || n3 == 1 && string.startsWith("set")) {
                    accessor = (Accessor)this._unaryAccessors.get(string2);
                    if (accessor != null) {
                        if (accessor instanceof MethodAccessor) {
                            ((MethodAccessor)accessor).addMethod(method, classArray);
                        }
                    } else {
                        accessor = new UnaryMethodAccessor(string2, method, classArray);
                        this._unaryAccessors.put(string2, accessor);
                    }
                } else if (n3 > 0 && (classArray[0].isInstance("string") && n3 == 2 && string.equals("put") || n3 == 1 && string.equals("get"))) {
                    if (this._hashAccessor != null) {
                        this._hashAccessor.addMethod(method, classArray);
                    } else {
                        this._hashAccessor = new BinaryMethodAccessor(string2, method, classArray);
                    }
                } else if (n3 > 0 && classArray[0].isInstance("string") && (n3 == 1 && string.startsWith("get") || n3 == 2 && string.startsWith("set"))) {
                    accessor = (Accessor)this._binaryAccessors.get(string2);
                    if (accessor != null) {
                        ((MethodAccessor)accessor).addMethod(method, classArray);
                    } else {
                        accessor = new BinaryMethodAccessor(string2, method, classArray);
                        this._binaryAccessors.put(string2, accessor);
                    }
                }
            } else if ((string.equals("elements") || string.equals("enumeration") || string.equals("iterator") || string.equals("toArray")) && classArray.length == 0 && ((bl = (clazz3 = class$java$util$Iterator == null ? PropertyOperator.class$("java.util.Iterator") : class$java$util$Iterator).isAssignableFrom(clazz2 = method.getReturnType())) || (this.iteratorMethod == null || this.iteratorMethod.getName().equals("toArray")) && (array$Ljava$lang$Object == null ? PropertyOperator.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).isAssignableFrom(clazz2) || (class$java$util$Enumeration == null ? PropertyOperator.class$("java.util.Enumeration") : class$java$util$Enumeration).isAssignableFrom(clazz2))) {
                this.iteratorMethod = method;
            }
            ++n2;
        }
    }

    private Object getProperty(Context context, Object object, Object[] objectArray, int n, int n2) throws PropertyException, NoSuchMethodException, ContextException {
        String string;
        Object object2 = null;
        Accessor accessor = null;
        if (objectArray[n] instanceof String) {
            string = (String)objectArray[n];
        } else if (objectArray[n] instanceof PropertyMethod) {
            PropertyMethod propertyMethod = (PropertyMethod)objectArray[n];
            string = propertyMethod.getName();
            accessor = (Accessor)this._directAccessors.get(string);
            Object[] objectArray2 = propertyMethod.getArguments(context);
            try {
                object2 = accessor.get(object, objectArray2);
                ++n;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodException("No method " + propertyMethod + " on object " + object);
            }
        } else {
            string = objectArray[n].toString();
        }
        if (accessor == null && (accessor = (Accessor)this._unaryAccessors.get(string)) != null) {
            try {
                object2 = accessor.get(object);
                ++n;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                accessor = null;
            }
        }
        if (accessor == null) {
            accessor = (Accessor)this._binaryAccessors.get(string);
            if (accessor != null && n + 1 <= n2) {
                try {
                    object2 = accessor.get(object, (String)objectArray[n + 1]);
                    n += 2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    accessor = null;
                }
                catch (ClassCastException classCastException) {
                    accessor = null;
                }
            } else {
                accessor = null;
            }
        }
        if (accessor == null) {
            accessor = this._hashAccessor;
            try {
                if (accessor != null) {
                    object2 = accessor.get(object, string);
                    ++n;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                accessor = null;
            }
        }
        if (accessor == null) {
            throw new NoSuchMethodException("No public method on object " + object + " of " + object.getClass() + " for property " + objectArray[n] + "--is this the right class?");
        }
        if (n <= n2) {
            try {
                return PropertyOperator.getOperator(object2.getClass()).getProperty(context, object2, objectArray, n, n2);
            }
            catch (NullPointerException nullPointerException) {
                throw new PropertyException("No way to access property " + objectArray[n] + " on object " + object + " of " + object.getClass() + "--possibly null?", nullPointerException);
            }
        }
        return object2;
    }

    private boolean setProperty(Context context, Object object, Object[] objectArray, Object object2, int n) throws PropertyException, NoSuchMethodException, ContextException {
        int n2 = objectArray.length - 1;
        int n3 = n2 - 1;
        if (n < n3) {
            Object object3 = this.getProperty(context, object, objectArray, n, n3 - 1);
            PropertyOperator propertyOperator = PropertyOperator.getOperator(object3.getClass());
            return propertyOperator.setProperty(context, object3, objectArray, object2, n3);
        }
        if (n == n3) {
            Object object4;
            Object object5 = null;
            try {
                object5 = this.getProperty(context, object, objectArray, n, n);
                if (object5 != null && super.setProperty(context, object5, objectArray, object2, n + 1)) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            object4 = (Accessor)this._binaryAccessors.get(objectArray[n]);
            if (object4 != null) {
                try {
                    return ((Accessor)object4).set(object, (String)objectArray[n + 1], object2);
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return false;
                }
            }
            return false;
        }
        Accessor accessor = (Accessor)this._unaryAccessors.get(objectArray[n]);
        try {
            if (accessor != null && accessor.set(object, object2)) {
                return true;
            }
            if (this._hashAccessor != null) {
                return this._hashAccessor.set(object, (String)objectArray[n], object2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private Iterator findIterator(Object object) throws PropertyException {
        if (this.iteratorMethod != null) {
            try {
                Object object2 = PropertyOperator.invoke(this.iteratorMethod, object, null);
                if (object2 instanceof Iterator) {
                    return (Iterator)object2;
                }
                if (object2 instanceof Enumeration) {
                    return new EnumIterator((Enumeration)object2);
                }
                if (object2 instanceof Object[]) {
                    return new ArrayIterator((Object[])object2);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new PropertyException("Error in PropertyOperator!", noSuchMethodException);
            }
        }
        throw new PropertyException(object + " is not a list", null);
    }

    static Object invoke(Method method, Object object, Object[] objectArray) throws PropertyException, NoSuchMethodException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyException("You don't have permission to access the requested method (" + method + " in class " + object.getClass() + " on object " + object + "). Private/protected/package access " + " values cannot be accessed via property introspection.", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PropertyException("Some kind of error occurred processing your request: this indicates a failure in PropertyOperator.java that should be reported: attempt to access method " + method + " on object " + object + " with " + objectArray.length + " parameters " + " threw an exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyException("Attempt to invoke method " + method + " on object " + object + " of " + object.getClass() + " raised an exception: " + invocationTargetException.getTargetException(), invocationTargetException.getTargetException());
        }
        catch (NullPointerException nullPointerException) {
            if (method == null) {
                throw new NoSuchMethodException("Null method");
            }
            throw new PropertyException("NullPointerException thrown from method " + method + " on object " + object + " -- most likely you have attempted " + "to use an undefined value, or a failure in that method.", nullPointerException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

