/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.engine.Engine;

public final class Block
implements Macro {
    private final Macro[] _content;

    public Block(Macro[] macroArray) {
        this._content = macroArray;
    }

    public void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
        int n = this._content.length;
        int n2 = 0;
        while (n2 < n) {
            this._content[n2].write(fastWriter, context);
            ++n2;
        }
    }

    public Object evaluate(Context context) throws ContextException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this._content.length * 16 + 256);
            FastWriter fastWriter = new FastWriter(byteArrayOutputStream, "UTF8");
            this.write(fastWriter, context);
            fastWriter.flush();
            return byteArrayOutputStream.toString("UTF8");
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            Engine.log.error("StringWriter through an IOException!");
            return null;
        }
    }
}

