/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceMap;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.util.ThreadScheduler;

public final class ResourceManager
implements ResourceMap {
    private boolean _shutdown = false;
    private String _type;
    private int _expireTime = 0;
    int _threadPool = 0;
    private Thread _reaper;
    private ResourceBroker _broker;
    private Vector _providers = new Vector();
    private Hashtable _resources = new Hashtable();
    private Hashtable _workers = new Hashtable();
    private static int _REVOKED_WORKER;
    private static int _BACKGROUND_WORKER;
    private static int _NORMAL_WORKER;
    private static int _CRITICAL_WORKER;
    private static final long _REAPER_LONG_SLEEP = 1800000L;

    ResourceManager(ResourceBroker resourceBroker, final String string) {
        this._broker = resourceBroker;
        this._type = string.intern();
        this._reaper = new Thread(){

            public void run() {
                block9: while (true) {
                    try {
                        while (!this.isInterrupted()) {
                            Hashtable hashtable;
                            int n = ResourceManager.this._expireTime;
                            if (n > 0) {
                                Thread.sleep(n);
                                if (ResourceManager.this.reap()) continue;
                                hashtable = ResourceManager.this._resources;
                                synchronized (hashtable) {
                                    ResourceManager.this._resources.wait(1800000L);
                                    continue block9;
                                }
                            }
                            hashtable = ResourceManager.this._resources;
                            synchronized (hashtable) {
                                if (ResourceManager.this._expireTime <= 0) {
                                    ResourceManager.this._resources.wait(1800000L);
                                }
                                continue block9;
                            }
                        }
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    catch (Exception exception) {
                        ResourceBroker._log.exception(exception);
                        ResourceBroker._log.warning("Reaper caught exception (continuing anyway)");
                        break;
                    }
                }
            }
        };
        this._reaper.setName("reaper:" + string);
        this._reaper.setDaemon(true);
        this._reaper.setPriority(_NORMAL_WORKER);
        this._reaper.start();
    }

    public final String toString() {
        return "ResourceManager(" + this._type + "," + this._expireTime + ")";
    }

    final void addListener(ResourceProvider resourceProvider) {
        if (resourceProvider instanceof ResourceProvider) {
            ResourceProvider resourceProvider2 = resourceProvider;
            this.addListener(this._providers, resourceProvider2);
            if (this._expireTime < resourceProvider2.resourceExpireTime()) {
                this.setExpireTime(resourceProvider2.resourceExpireTime());
            }
        }
    }

    public long getExpireTime() {
        return this._expireTime;
    }

    public void setExpireTime(int n) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            this._expireTime = n;
            this._resources.notify();
        }
    }

    final void removeListener(ResourceProvider resourceProvider) {
        this.removeListener(this._providers, resourceProvider);
    }

    public final ResourceEvent get(String string) throws InvalidTypeException, NotFoundException {
        return this.locate(string, null, 0, true);
    }

    public final void remove(String string) throws InvalidTypeException, NotFoundException {
        this.locate(string, null, 2, true);
    }

    public final ResourceEvent put(String string, Object object) throws InvalidTypeException, NotFoundException {
        return this.locate(string, object, 1, true);
    }

    final boolean isProvider() {
        return !this._providers.isEmpty();
    }

    ResourceEvent locate(String string, Object object, int n, boolean bl) throws InvalidTypeException, NotFoundException {
        ResourceEvent resourceEvent;
        Object object2;
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            if (this._shutdown) {
                throw new InvalidTypeException("Request follows shutdown");
            }
            object2 = (ResourceEvent)this._resources.get(string);
            if (object2 == null) {
                switch (n) {
                    case 0: {
                        resourceEvent = new RequestResourceEvent(this._broker, this._type, string);
                        break;
                    }
                    case 1: {
                        resourceEvent = new CreateResourceEvent(this._broker, this._type, string, object);
                        break;
                    }
                    case 2: {
                        resourceEvent = new RequestResourceEvent(this._broker, this._type, string);
                        resourceEvent.deleted = true;
                        break;
                    }
                    default: {
                        throw new InvalidTypeException("Unsupported method!");
                    }
                }
                if (this._expireTime != 0) {
                    this._resources.put(string, resourceEvent);
                    this._resources.notify();
                }
            } else {
                resourceEvent = object2;
                switch (n) {
                    case 0: {
                        ResourceEvent resourceEvent2 = resourceEvent;
                        return resourceEvent2;
                    }
                    case 1: {
                        throw new NotFoundException("Resource exists.");
                    }
                    case 2: {
                        resourceEvent.deleted = true;
                        break;
                    }
                    default: {
                        throw new InvalidTypeException("Unsupported method!");
                    }
                }
            }
        }
        if (bl && this._threadPool > 0) {
            object2 = new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            ResourceManager.this._workers.put(resourceEvent, this);
                            this.setName("worker:" + resourceEvent);
                            this.setPriority(_BACKGROUND_WORKER);
                            Thread.yield();
                            ResourceManager.this.resolve(resourceEvent, true);
                        }
                        catch (Exception exception) {
                            ResourceBroker._log.exception(exception);
                            Object var3_2 = null;
                            ResourceManager.this._workers.remove(resourceEvent);
                            return;
                        }
                        Object var3_1 = null;
                        ResourceManager.this._workers.remove(resourceEvent);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        ResourceManager.this._workers.remove(resourceEvent);
                        throw throwable;
                    }
                }
            };
            ((Thread)object2).start();
        } else {
            this.resolve(resourceEvent, false);
        }
        return resourceEvent;
    }

    private final void resolve(ResourceEvent resourceEvent, boolean bl) {
        int n = this._providers.size();
        try {
            int n2 = 0;
            while (n2 < n && resourceEvent.isSettable()) {
                resourceEvent.providerSet((ResourceProvider)this._providers.elementAt(n2));
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NotFoundException notFoundException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        catch (Exception exception) {
            ResourceBroker._log.exception(exception);
            ResourceBroker._log.warning("Provider " + this._type + " threw an exception");
        }
        if (!resourceEvent.deleted && resourceEvent.isAvailable()) {
            if (bl) {
                Thread.currentThread().setPriority(_NORMAL_WORKER);
                Thread.yield();
            }
        } else if (resourceEvent.deleted || resourceEvent.isSettable()) {
            this.revoke(resourceEvent, "Unable to resolve requested resource");
        } else if (!resourceEvent.isRevoked()) {
            ResourceBroker._log.warning(this + " reached an unexpected state resolving " + resourceEvent);
        }
    }

    void revoke(ResourceEvent resourceEvent, String string) {
        Object object;
        ResourceEvent resourceEvent2 = resourceEvent;
        synchronized (resourceEvent2) {
            if (resourceEvent.isRevoked()) {
                return;
            }
            this.commit(resourceEvent);
            resourceEvent.revoke(string);
            object = (Thread)this._workers.remove(resourceEvent);
            if (object != null && object != Thread.currentThread()) {
                ((Thread)object).setPriority(_REVOKED_WORKER);
                ((Thread)object).interrupt();
            }
        }
        object = this._resources;
        synchronized (object) {
            ResourceEvent resourceEvent3 = (ResourceEvent)this._resources.remove(resourceEvent.getName());
            if (resourceEvent3 != null && !resourceEvent3.isRevoked()) {
                this._resources.put(resourceEvent3.getName(), resourceEvent3);
                this._resources.notify();
            }
        }
    }

    void blocked(ResourceEvent resourceEvent) throws NotFoundException {
        Thread thread;
        Thread thread2 = (Thread)this._workers.get(resourceEvent);
        if (thread2 == (thread = Thread.currentThread())) {
            ResourceBroker._log.warning("Attempt to block self for: " + resourceEvent);
            throw new NotFoundException("Attempt to block self!");
        }
        if (thread2 != null) {
            int n = thread.getPriority();
            if (thread2.getPriority() < n) {
                thread2.setPriority(n);
            }
        }
    }

    private void commit(ResourceEvent resourceEvent) {
        int n = this._providers.size();
        boolean bl = false;
        if (resourceEvent.isAvailable() || resourceEvent.deleted) {
            try {
                int n2 = 0;
                while (n2 < n && !bl) {
                    ResourceProvider resourceProvider = (ResourceProvider)this._providers.elementAt(n2);
                    bl = resourceEvent.deleted ? resourceProvider.resourceDelete(resourceEvent) : resourceProvider.resourceSave(resourceEvent);
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (!bl) {
                ResourceBroker._log.warning("Resource unsaved: " + resourceEvent);
            }
        }
    }

    void shutdownResources() {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            this._shutdown = true;
        }
        this._reaper.interrupt();
        Enumeration enumeration = this._resources.elements();
        while (enumeration.hasMoreElements()) {
            ResourceEvent resourceEvent = (ResourceEvent)enumeration.nextElement();
            this.revoke(resourceEvent, "shutting down");
        }
    }

    void shutdownListeners(Hashtable hashtable) {
        this.destroy(this._providers, hashtable);
    }

    private void destroy(Vector vector, Hashtable hashtable) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResourceProvider resourceProvider = (ResourceProvider)enumeration.nextElement();
            if (hashtable.get(resourceProvider) != null) continue;
            hashtable.put(resourceProvider, resourceProvider);
            resourceProvider.destroy();
        }
    }

    private boolean reap() throws InterruptedException {
        boolean bl = false;
        try {
            Enumeration enumeration = this._resources.elements();
            while (enumeration.hasMoreElements()) {
                ResourceEvent resourceEvent = (ResourceEvent)enumeration.nextElement();
                if (!resourceEvent.isSettable()) {
                    if (resourceEvent.accessed) {
                        resourceEvent.accessed = false;
                    } else {
                        Object var5_5;
                        try {
                            this._reaper.setPriority(_CRITICAL_WORKER);
                            this.revoke(resourceEvent, "Expired from cache");
                            var5_5 = null;
                            this._reaper.setPriority(_NORMAL_WORKER);
                        }
                        catch (Throwable throwable) {
                            var5_5 = null;
                            this._reaper.setPriority(_NORMAL_WORKER);
                            throw throwable;
                        }
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            ResourceBroker._log.exception(exception);
            ResourceBroker._log.warning("Reaper caught exception in " + this + " (continuing anyway)");
        }
        return bl;
    }

    private void addListener(Vector vector, ResourceProvider resourceProvider) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            if (this._shutdown) {
                return;
            }
            if (!vector.contains(resourceProvider)) {
                vector.addElement(resourceProvider);
            }
        }
    }

    private void removeListener(Vector vector, ResourceProvider resourceProvider) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            while (vector.removeElement(resourceProvider)) {
            }
        }
    }

    static {
        int n = Thread.currentThread().getPriority();
        _REVOKED_WORKER = n - 2;
        _BACKGROUND_WORKER = n - 1;
        _NORMAL_WORKER = n;
        _CRITICAL_WORKER = n + 1;
        ThreadScheduler.start(1000L);
    }
}

