#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <glib.h>
#include <math.h>
#include "stack.h"

opcode *compile(const char *command)
{
	opcode *newcode;
	gchar *work, *w;
	int i, j, k, o = 0;
	int items = 0;
	short *ptr;
	int l, last = 0;
	int nb;
	opcode *subops[100];
	int numsubops = 0;
	int numsubopsused = 0;


	work = g_strdup(command);

	l = strlen(command);

	ptr = g_new(short, l);

	/* Look for { } s */

	for(i = 0; i < l; i++) if(work[i] == '{')
	{
		nb = 1;
		for(j = i+1; j < l; j++)
		{
			if(work[j] == '{') nb++;
			if(work[j] == '}') nb--;
			if(nb == 0) break;
		}
		work[j] = 0;
		subops[numsubops++] = compile(work + i + 1);
		for(k = i; k < j; k++) work[k] = ' ';
	}

	for(i = 0; i < l; i++)
	{
		if(work[i] <= ' ')
		{
			work[i] = 0;
			last = 0;
		}
		else if(last != 1)
		{
			last = 1;
			ptr[items++] = i;
		}
	}

	newcode = g_new(opcode, items + 1);

	for(i= 0; i < items; i++)
	{
		w = work + ptr[i];
		if(strcmp(w, "pi") == 0)
		{
			newcode[o].arg.f = 3.14159265359;
			newcode[o++].op = 'P';
		}
		else if(w[1] || isdigit(w[0]))
		{
			newcode[o].arg.f = atof(w);
			newcode[o++].op = 'P';
		}
		else 
		{
			newcode[o].op = w[0];
			if(newcode[o].op == 'i' || newcode[o].op == 'R' ||
			   newcode[o].op == 'f')
				newcode[o].arg.sub[0] = subops[numsubopsused++];
			if(newcode[o].op == 'I')
			{
				newcode[o].arg.sub[0] = subops[numsubopsused++];
				newcode[o].arg.sub[1] = subops[numsubopsused++];
			}
			o++;
		}
	}

	newcode[o++].op = 'E';
	
	g_free(ptr);
	g_free(work);
	return newcode;
}

int execute(opcode *code, const char *data, float *stk, int *length)
{
	int i, top;
	int j, k, start, stop;
	char temp[100];
	float t, a, b, c;

	top = *length - 1;

	for(i = 0; ; i++)
	{
		switch(code[i].op)
		{
			case '+' :
				top--;
				stk[top] += stk[top+1];
				break;
			case '-' :
				top--;
				stk[top] -= stk[top+1];
				break;
			case '*' :
				top--;
				stk[top] *= stk[top+1];
				break;
			case '/' :
				top--;
				stk[top] /= stk[top+1];
				break;
			case '^' :
				top--;
				stk[top] = pow(stk[top], stk[top+1]);
				break;
			case '<' : /* _ _ < {1, 0} */
				top--;
				if(stk[top] < stk[top+1]) stk[top] = 1;
				else stk[top] = 0;
				break;
			case '>' : /* _ _ > {1, 0} */
				top--;
				if(stk[top] > stk[top+1]) stk[top] = 1;
				else stk[top] = 0;
				break;
			case '=' : /* _ _ == {1, 0} */
				top--;
				if(stk[top] == stk[top+1]) stk[top] = 1;
				else stk[top] = 0;
				break;
			case '%' : /* _ _ mod _ */
				top--;
				stk[top] = (int)rint(stk[top]) % 
						(int)rint(stk[top+1]);
				break;
			case 'P' : /* push _ */
				top++;
				stk[top] = code[i].arg.f;
				break;
			case 'p' : /* _ pop */
				top--;
				break;
			case 'z' : /* zero stack */
				top = -1;
				break;
			case 'u' : /* up _ */
				top++;
				break;
			case 'e' : /* _ exp _ */
				stk[top] = exp(stk[top]);
				break;
			case 's' : /* _ sqrt _ */
				stk[top] = sqrt(stk[top]);
				break;
			case 'S' : /* _ sin _ */
				stk[top] = sin(stk[top]);
				break;
			case 'C' : /* _ cos _ */
				stk[top] = cos(stk[top]);
				break;
			case 'T' : /* _ tan _ */
				stk[top] = tan(stk[top]);
				break;
			case 'N' : /* round to nearest int */
				stk[top] = rint(stk[top]);
				break;
			case 'n' : /* _ neg _ */
				stk[top] = -stk[top];
				break;
			case 'd' : /* _ dup _ _ */
				stk[top+1] = stk[top];
				top++;
				break;
			case 'x' : /* _ _ exch _ _ */
				t = stk[top];
				stk[top] = stk[top-1];
				stk[top-1] = t;
				break;
			case 'c' : /* _ copy _ ... _ */
				k = rint(stk[top]);
				for(j = k - 1; j >= 0; j--)
					stk[top+j] = stk[top+j-k];
				top += (k-1);
				break;
			case 'r' : /* _ _ read _ */
				stop = rint(stk[top--]);
				start = rint(stk[top]);
				k = 0;
				for(j = start; j <= stop; j++)
					temp[k++] = data[j];
				temp[k] = 0;
				stk[top] = atof(temp);
				break;
			case 'I' : /* {} {} _ elseif */
				k = rint(stk[top--]);
				*length = top + 1;
				if(k == 1)
					execute(code[i].arg.sub[0], 
						data, stk, length);
				else
					execute(code[i].arg.sub[1],
						data, stk, length);
				top = *length - 1;
				break;
			case 'i' : /* {} _ if or _ {} if */
				if(rint(stk[top--]) == 1)
				{
					*length = top + 1;
					execute(code[i].arg.sub[0], 
						data, stk, length);
					top = *length - 1;
				}
				break;
			case 'R' : /* {} _ rep or _ {} rep */
				k = stk[top--];
				*length = top + 1;
				for(j = 0; j < k; j++) 
					execute(code[i].arg.sub[0],
						data, stk, length);
				top = *length - 1;
				break;
			case 'f' :
				c = stk[top--];
				b = stk[top--];
				a = stk[top--];
				for(t = a; t <= b; t += c)
				{
					stk[++top] = t;
					*length = top + 1;
					execute(code[i].arg.sub[0],
						data, stk, length);
					top = *length - 1;
				}
				break;
			case 'E' : /* Exit */
				*length = top + 1;
				return 1;
			default :
				printf("Unknown opcode %x hex\n", code[i].op);
				return -1;
		}
	}

	return -1;
}

int executed(opcode *code, const char *data, double *stk, int *length)
{
	int i, top;
	int j, k, start, stop;
	char temp[100];
	double t, a, b, c;

	top = *length - 1;

	for(i = 0; ; i++)
	{
		switch(code[i].op)
		{
			case '+' :
				top--;
				stk[top] += stk[top+1];
				break;
			case '-' :
				top--;
				stk[top] -= stk[top+1];
				break;
			case '*' :
				top--;
				stk[top] *= stk[top+1];
				break;
			case '/' :
				top--;
				stk[top] /= stk[top+1];
				break;
			case '^' :
				top--;
				stk[top] = pow(stk[top], stk[top+1]);
				break;
			case '<' : /* _ _ < {1, 0} */
				top--;
				if(stk[top] < stk[top+1]) stk[top] = 1;
				else stk[top] = 0;
				break;
			case '>' : /* _ _ > {1, 0} */
				top--;
				if(stk[top] > stk[top+1]) stk[top] = 1;
				else stk[top] = 0;
				break;
			case '=' : /* _ _ == {1, 0} */
				top--;
				if(stk[top] == stk[top+1]) stk[top] = 1;
				else stk[top] = 0;
				break;
			case '%' : /* _ _ mod _ */
				top--;
				stk[top] = (int)rint(stk[top]) % 
						(int)rint(stk[top+1]);
				break;
			case 'P' : /* push _ */
				top++;
				stk[top] = code[i].arg.f;
				break;
			case 'p' : /* _ pop */
				top--;
				break;
			case 'z' : /* zero stack */
				top = -1;
				break;
			case 'u' : /* up _ */
				top++;
				break;
			case 'e' : /* _ exp _ */
				stk[top] = exp(stk[top]);
				break;
			case 's' : /* _ sqrt _ */
				stk[top] = sqrt(stk[top]);
				break;
			case 'S' : /* _ sin _ */
				stk[top] = sin(stk[top]);
				break;
			case 'C' : /* _ cos _ */
				stk[top] = cos(stk[top]);
				break;
			case 'T' : /* _ tan _ */
				stk[top] = tan(stk[top]);
				break;
			case 'N' : /* round to nearest int */
				stk[top] = rint(stk[top]);
				break;
			case 'n' : /* _ neg _ */
				stk[top] = -stk[top];
				break;
			case 'd' : /* _ dup _ _ */
				stk[top+1] = stk[top];
				top++;
				break;
			case 'x' : /* _ _ exch _ _ */
				t = stk[top];
				stk[top] = stk[top-1];
				stk[top-1] = t;
				break;
			case 'c' : /* _ copy _ ... _ */
				k = rint(stk[top]);
				for(j = k - 1; j >= 0; j--)
					stk[top+j] = stk[top+j-k];
				top += (k-1);
				break;
			case 'r' : /* _ _ read _ */
				stop = rint(stk[top--]);
				start = rint(stk[top]);
				k = 0;
				for(j = start; j <= stop; j++)
					temp[k++] = data[j];
				temp[k] = 0;
				stk[top] = atof(temp);
				break;
			case 'I' : /* {} {} _ elseif */
				k = rint(stk[top--]);
				*length = top + 1;
				if(k == 1)
					executed(code[i].arg.sub[0], 
						data, stk, length);
				else
					executed(code[i].arg.sub[1],
						data, stk, length);
				top = *length - 1;
				break;
			case 'i' : /* {} _ if or _ {} if */
				if(rint(stk[top--]) == 1)
				{
					*length = top + 1;
					executed(code[i].arg.sub[0], 
						data, stk, length);
					top = *length - 1;
				}
				break;
			case 'R' : /* {} _ rep or _ {} rep */
				k = stk[top--];
				*length = top + 1;
				for(j = 0; j < k; j++) 
					executed(code[i].arg.sub[0],
						data, stk, length);
				top = *length - 1;
				break;
			case 'f' :
				c = stk[top--];
				b = stk[top--];
				a = stk[top--];
				for(t = a; t <= b; t += c)
				{
					stk[++top] = t;
					*length = top + 1;
					executed(code[i].arg.sub[0],
						data, stk, length);
					top = *length - 1;
				}
				break;
			case 'E' : /* Exit */
				*length = top + 1;
				return 1;
			default :
				printf("Unknown opcode %x hex\n", code[i].op);
				return -1;
		}
	}

	return -1;
}

void destroycode(opcode *code)
{
	g_free(code);
}
