#include <stdio.h>
#include <unistd.h>
#include <string.h>

struct object
{
        long x, y, z;
        unsigned char type, icon, mask, extra;
};

int main()
{
	struct object yale[9110];
	FILE *in, *out;
	char line[1000];
	int num=0;
	int index, icon, e;	

	in = fopen("yale.cat", "r");
	if(in == 0)
	{
		printf("Can't open file yale.cat\n");
		exit(0);
	}
	fread(yale, 9110, sizeof(struct object), in);
	fclose(in);

	in = fopen("../raw/const.dat", "r");
	out = fopen("const.cat", "w");
	for(;;)
	{
		fgets(line, 999, in);
		if(feof(in)) break;
		if(line[0] == '#') continue;
		if(strlen(line) < 5) continue;
		if(sscanf(line, "%d %d %d", &index, &icon, &e) != 3) continue;
		if(index<0 || index>9109) continue;
		yale[index].mask=0x0F;
		yale[index].icon=icon;
		yale[index].extra=e;
		yale[index].type=192;
		fwrite(&yale[index], 1, sizeof(struct object), out);
		
		num++;
	}
	fclose(in);
	fclose(out);
	printf("%d total points\n", num);

	return 0;
}
