#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "../src/picture.h"

GdkPixbuf	      *im;
GtkWidget *window, *da;

static gint expev(GtkWidget *widget, GdkEventExpose *event,
        int *i)
{
	gdk_pixbuf_render_to_drawable(im,
		widget->window,
		widget->style->fg_gc[GTK_STATE_NORMAL],
		event->area.x, event->area.y,
		event->area.x, event->area.y,
		gdk_pixbuf_get_width(im), gdk_pixbuf_get_height(im),
		GDK_RGB_DITHER_NORMAL, 0, 0);
	return FALSE;
}


int main(int argc, char **argv)
{
	int i, j;
	char outn[1000];
	guchar *pixels;
	gint w,h;
	int l, dot;
	int type=0;
	int rs;
	char op = 0;

	struct picture pic;

	if (argc<2)
	{
		printf("Usage:\n %s image_file\n",argv[0]);
		exit(1);
	}
	gtk_init(&argc,&argv);
	gdk_rgb_init();

	l = strlen(argv[1]);
	if(strcmp(argv[1]+l-4, ".pic") == 0) type = 1;

	if(type == 1) 
	{
		loadpicture(&pic, argv[1]);
		im = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE, 8, pic.w, pic.h);
		rs = gdk_pixbuf_get_rowstride(im);
		printf("w = %d h = %d rs = %d\n", pic.w, pic.h, rs);
		pixels = gdk_pixbuf_get_pixels(im);
		for(j = 0; j < pic.h; j++) for(i = 0; i < 3*pic.w; i++)
			pixels[i+j*rs] = pic.data[i+3*j*pic.w];
	}
	else
	{
		im=gdk_pixbuf_new_from_file(argv[1]);
		if(im == 0)
		{
			fprintf(stderr, "Can't find file %s\n", argv[1]);
			return 0;
		}
		pic.w = gdk_pixbuf_get_width(im);
		pic.h = gdk_pixbuf_get_height(im);
		pic.hotx = (pic.w+1)/2;
		pic.hoty = (pic.h+1)/2;
		pic.data = gdk_pixbuf_get_pixels(im);
	}

	if(argc > 2) op = argv[2][0];
	printf("op = %c\n", op);


	if(op == 's' && type == 0)
	{
		if(argc >= 5)
		{
			pic.hotx = atoi(argv[3]);
			pic.hoty = atoi(argv[4]);
			printf("hot = (%d %d)\n", pic.hotx, pic.hoty);
		}
		strcpy(outn, argv[1]);
		dot = l;
		for(i = 0; i < l; i++) if(argv[1][i] == '.') dot = i;
		strcpy(outn+dot, ".pic");
		printf("outname = %s\n", outn);
		savepicture(&pic, outn);
	}

	if(op == 'v')
	{
		w = gdk_pixbuf_get_width(im);
		h = gdk_pixbuf_get_height(im);
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		da = gtk_drawing_area_new();
		gtk_drawing_area_size(GTK_DRAWING_AREA(da), w, h);
		gtk_container_add(GTK_CONTAINER(window), da);
		gtk_widget_show(da);
		gtk_signal_connect(GTK_OBJECT(da),
                	"expose_event", (GtkSignalFunc)expev, 0);
		gtk_widget_show(window);
		gtk_main();
	}

	if(op == 'e' && type == 1)
	{
		if(argc < 5)
		{
			printf("need two args for e\n");
			return 0;
		}
		printf("old hot = (%d %d)\n", pic.hotx, pic.hoty);
		pic.hotx = atoi(argv[3]);
		pic.hoty = atoi(argv[4]);
		printf("new hot = (%d %d)\n", pic.hotx, pic.hoty);
		savepicture(&pic, argv[1]);
	}

	return 0;
}
