#ifndef S9X_INTERFACE_H
#define S9X_INTERFACE_H

class s9x_Interface;

#include "defines.h"
#include "frend.h"
#include "rom.h"
#include "sound.h"
#include "video.h"
#include "joystick.h"
#include "cpu.h"
#include "netplay.h"
#include "extra.h"
#include "profiler.h"
#include "prefs.h"
#include "misc.h"

class s9x_Interface :	public fr_MainProgram, private fr_Listener {
   friend		s9x_Prefs;
 private:
   fr_Label		Nordlund;
   fr_Box		BannerBox, Panel;
   fr_Button      	Power, Reset, Eject;
   fr_Notebook    	NoteBook;
   fr_ArgList		*LastRun;
   fr_Element		Quit, Tip;
   fr_Image		ImgTex, ImgRom, ImgSnap, ImgPref, ImgQuit, ImgHelp,
     			ImgPower, ImgReset;
   fr_Style		SNESstyle;
   fr_ArgList		*LastArgs;
   s9x_FileOps		LastFile;
   void			CreateMenu();
   void			CreateNotebook();
   void			CreatePanel();
   void			EventOccurred(fr_Event*e);
   void			Run();
 public:
   s9x_Prefs		Prefs;
   s9x_ROM		ROM;
   s9x_Sound		Sound;
   s9x_Video		Video;
   s9x_CPU		CPU;
   s9x_Joystick		Joystick;
   s9x_NetPlay		NetPlay;
   s9x_Snapshot         Snapshot;
   s9x_Extra		Extra;
   s9x_Profiler		Profiler;
   fr_About             About;
                	s9x_Interface();
                        ~s9x_Interface();
   void			SetToDefaults();
   void			Set9xVersion(double version);
   void 	       	SiftArgs(fr_ArgList& L);
   void			CompileArgs(fr_ArgList& L);
   void			ApplyStyle(fr_Style*S);
   void			ViewExpanded(bool b);
};

#endif
