#ifndef __DEFINES_H__
#define __DEFINES_H__
#include "config.h"

/*	*	*	*	defines.h	*	*	*	*
 *	This is an include file for snes9express.			*
 *	Alter it to suit your needs.					*
 *					-David Nordlund			*
 *	*	*	*	*	*	*	*	*	*/

/*
 *	SNES9X_VERSION
 *
 *	this determines what version to target the interface for, so that
 *	the appropraite options are used.
 *
 */
#define SNES9X_VERSION 1.26


/*
 *	S9X_ROMENV
 *
 *	the environment variable name that might exist,
 *	and if it does, contains the default ROM directory.
 *
 *	S9X_ROMDIR
 *
 *	If S9X_ROMDIRENV doesn't exist, default to looking for
 *	roms in S9X_ROMDIR
 *
 */
//#define S9X_ROMENV "SNES96_ROM_DIR" //old way, but still works
#define S9X_ROMENV "SNES9X_ROM_DIR" //new way, but not found in the docs
//#define S9X_ROMDIR ".roms/"
#define S9X_ROMDIR ""
 
/*
 *	S9X_SNAPSHOTENV
 *	
 *	the environment variable name that might exist,
 *	and if it does, contains the default Snapshot directory.
 *
 *	S9X_SNAPSHOTDIR
 *
 *	if S9X_SNAPSHOTENV doesn't exist, default to looking for
 *	snapshots in $HOME/S9X_SNAPSHOTDIR
 *
 */
//#define S9X_SNAPSHOTENV "SNES96_SNAPSHOT_DIR"
#define S9X_SNAPSHOTENV "SNES9X_SNAPSHOT_DIR"
#define S9X_SNAPSHOTDIR ".snes96_snapshots/"

/*
 *	S9X_SUBDIR
 *
 *	The sub-directory under the HOME directory where snes9express
 *	puts it's configuration files
 */
#define S9X_SUBDIR ".s9x"

/*
 *	SNES9EXPRESS_WEBSITE, SNES9EXPRESS_EMAIL
 *
 *	The url for the snes9express website and e-mail address
 */
#define SNES9EXPRESS_WEBSITE "http://www.linuxgames.com/snes9express/"
#define SNES9EXPRESS_EMAIL "nordlund@cs.dal.ca"

#define SNES9X_WEBSITE "http://www.snes9x.com/"

#endif
