/*
	This file keeps all the functions relevant to the rpgent structure
*/

#include "rpggame.h"

rpgchar *rpgent::getchar()
{
	if(etype != ENT_CHAR)
		return NULL;
	return (rpgchar *) subtype;
}

rpgitem *rpgent::getitem()
{
	if(etype != ENT_ITEM)
		return NULL;
	return (rpgitem *) subtype;
}

rpgspell *rpgent::getspell()
{
	if(etype != ENT_SPELL)
		return NULL;
	return (rpgspell *) subtype;
}

rpgobject *rpgent::getobject()
{
	if(etype != ENT_OBJECT)
		return NULL;
	return (rpgobject *) subtype;
}

void addexp(int amount, int skill)
{
	conoutf("Not implemented yet");
#if 0
	switch(level)
	{
		case LEVEL_BLADE:
		case LEVEL_MARKSMAN:
		LEVEL_UNARMED:
		LEVEL_GUN:
		LEVEL_REPAIR:
		LEVEL_THROW:
		LEVEL_HEAL:
		LEVEL_MAGIC:
		LEVEL_BARTER:
		LEVEL_SNEAK:
			/*
			some stuff here to modify the amount of gained exp
			*/
			break;
		default:
			return;
	}
	character->base.levels[level] += amount;
	character->base.levels[LEVEL_OVERALL] += amount;
#endif
}

void rpgent::cleansubtypes()
{
	switch(etype)
	{
		case ENT_CHAR:
			getchar()->inventory.deletecontentsp();
			getchar()->spellbook.deletecontentsp();
			delete getchar();
			break;
		case ENT_SPELL:
			delete getspell();
			break;
		case ENT_ITEM:
			delete getitem();
			break;
		case ENT_OBJECT:
			delete getobject();
			break;
	}
	subtype = NULL;
}

bool rpgent::dequip(rpgent *item)
{
	rpgchar *d = getchar();
	if(!d)
		return false;
	loopi(EQUIP_MAX)
	{
		if(d->selected[i] == item)
		{
			d->selected[i] = NULL;
			return true;
		}
	}
	return false;
}

void rpgent::die()
{
	rpgchar *d = getchar();
	if(!d || state != CS_ALIVE) return;

	state = CS_DEAD;
	d->lastpain = d->lastaction = lastmillis;
	d->health = d->mana = 0;
	effects.deletecontentsp();

	if(death)
	{
		//TODO set aliases
		execute(death);
	}
}

bool rpgent::drop(rpgent *item)
{
	rpgchar *d = getchar();
	if(!d)
		return false;

	bool removed;
	loopv(d->inventory)
	{
		if(item == d->inventory[i])
		{
			dequip(d->inventory[i]);
			d->inventory.remove(i);
			removed = true;
			break;
		}
	}
	if(!removed)
	{
		loopv(d->spellbook)
		{
			if(item == d->spellbook[i])
			{
				d->spellbook.remove(i);
				removed = true;
				break;
			}
		}
	}
	loopi(EQUIP_MAX)
	{
		if(d->selected[i] == item)
		{
			d->selected[i] = NULL;
		}
	}
	if(removed)
	{
		game::rpgobjs.add(item);
		vec pos; vecfromyawpitch(yaw, 0, 1, 0, pos); pos.mul(10);
		item->o = o; item->o.add(pos); item->newpos = item->o;
		item->yaw = yaw;
		if(item->etype == ENT_CHAR) {item->respawn();}
		return true;
	}
	return false;
}

bool rpgent::equip(rpgent *item, int slot)
{
	rpgchar *d = getchar();
	if(item->etype == ENT_ITEM)
	{
		rpgitem *i = item->getitem();

		slot = clamp(EQUIP_MAX-1, 0, slot);
		if(d->attributes < i->requirements) return false;
		if(i->slots&(1<<slot))
		{
			dequip(item); //just in case the item is in other slots
			d->selected[slot] = item;
			d->updatestats = true;
			return true;
		}
		return false;
	}
	else //if(item->etype==ENT_SPELL)
	{
		if(d->attributes < item->getspell()->requirements) return false;
		d->selectedspell = item;
		return true;
	}
}

float rpgent::geteffectmul(rpgent &wep)
{
	switch(wep.etype)
	{
		case ENT_ITEM:
			return 1.0f;
		case ENT_SPELL:
		{
			rpgchar *d = getchar();
			return logf(
				d->attributes.intelligence / 2.0f +
				d->attributes.charisma / 4.0f +
				d->attributes.levels[LEVEL_MAGIC].level
			) / 4;
		}
		default:
			return 1.0f;
	}
}

int rpgent::gettotalweight()
{
	rpgchar *d = getchar();
	if(!d)
		return 0;

	//TODO update me when stackable items are implemented
	int weight = 0;
	loopv(d->inventory)
	{
		rpgitem *it = d->inventory[i]->getitem();
		if(!it)
			continue;

		weight += it->weight;
	}
	return weight;
}

void rpgent::newmodel(bool init)
{
	if(!init) o.z -= eyeheight;
	setbbfrommodel(this, model);
	if(!init) o.z += eyeheight;
}

void rpgent::pickup(rpgent *item)
{
	rpgchar *d = getchar();
	if(item->etype==ENT_ITEM)
	{
		d->inventory.add(item);
		d->updatestats = true;
	}
	else if (item->etype == ENT_SPELL)
		d->spellbook.add(item);
	else
		return;

	loopv(game::rpgobjs)
	{
		if(game::rpgobjs[i] == item)
		{
			game::rpgobjs.remove(i);
			return;
		}
	}
}

void rpgent::reset() //only used for the player
{
	cleansubtypes();
	subtype = new rpgchar();
	effects.deletecontentsp();
}

void rpgent::respawn(bool death)
{
	dynent::reset();
	switch(etype)
	{
		case ENT_CHAR:
		{
			rpgchar *d = getchar();
			if(death)
			{
				d->health = 1;
				d->mana = 10;
				effects.add(new status(STATUS_DEATH, 0, 20000));
			}
			else
			{
				d->health = d->attributes.maxhealth;
				d->mana = d->attributes.maxmana;
			}
			d->lastpain = d->lastaction = 0;
			d->lastdeath = d->lasthealth = d->lastmana = lastmillis;
			state = CS_ALIVE;
			break;
		}
		case ENT_SPELL:
		case ENT_ITEM:
		case ENT_OBJECT:
		default:
			break;
	}
}

void rpgent::takedamage(float amount, int type)
{
	rpgchar *d = getchar();
	if(!d) return;
	#define resist(n, r) if((type & n) == n) \
	{\
		amount *= (100 - d->attributes.resistance[r]) / 100.0f; \
		type -= n; \
	}

	resist(ATTACK_MAGIC, RESIST_MAGIC)
	else resist(ATTACK_PIERCE, RESIST_PIERCE)
	else resist(ATTACK_BLUNT, RESIST_BLUNT)
	else resist(ATTACK_SLASHING, RESIST_SLASH) //this will succeed always

	if(type)
	{
		amount *= 1.25;
		resist(ATTACK_EARTH, RESIST_EARTH)
		else resist(ATTACK_AIR, RESIST_AIR)
		else resist(ATTACK_WATER, RESIST_WATER)
		else resist(ATTACK_FIRE, RESIST_FIRE)
		else
		{
			conoutf("invalid resistance");
			amount *= .8;
		}
	}
	d->health -= amount;

	#undef resist
}

///wary readers: this transfer means the transfer between maps/worlds
int rpgent::transfer()
{
	//this should basically re number the entities inside the hero's spellbook and inventory, and return that number
	//hero = 0;
	rpgchar *d = getchar();
	if(d)
	{
		loopv(d->inventory)
		{
			d->inventory[i]->temp.id = i + 1;
		}
		loopv(d->spellbook)
		{
			d->spellbook[i]->temp.id = i + d->inventory.length();
		}

		return d->spellbook.length() + d->inventory.length();
	}
	return 0;
}

//used by items, and objects inside the world
void rpgent::itemeffects(vector<status *> &efx)
{
	loopvrev(efx)
	{
		status &s = *efx[i];

		switch(s.type)
		{
			case STATUS_LIGHT:
				rpgobj::lights.add( dynlightcache(abovehead(), s.strength * 2, vec(.6, .5, .3), 1));
				break;

			case STATUS_INVIS:
				temp.fade -= s.strength / 100;
				break;
		}
	}
}

void rpgent::updateeffects(stats &stat,  vector<status *> &efx)
{
	loopvrev(efx)
	{
		status &s = *efx[i];

		float potency = 1.0f;

		//spells/effects/enchantments fade linearly over the last 20% of their lifespan
		//if duration is <=0 the effect is constant
		if(s.duration > 0)
		{
			if ((s.duration + s.startmillis + 200 < lastmillis ) ||
				(s.applied == s.strength && (s.duration + s.startmillis) < lastmillis))
			{
				delete efx[i];
				efx.remove(i);
				continue;
			}
			if((lastmillis - s.startmillis) > (s.duration * .8f))
				potency = (s.duration + s.startmillis - lastmillis) / (s.duration * .2f);
		}

		rpgchar *d = (rpgchar *)subtype;

		stats &attr = d->attributes;

		switch(s.type)
		{
			case STATUS_HEALTH:
			{
				float delta = 0;
				if(s.duration <= 0)
				{
					delta = s.strength * curtime / 1000.0f;
				}
				else
				{
					if((lastmillis - s.startmillis) * s.strength / s.duration == s.applied) continue;

					if(s.strength < 0)
						delta = max(s.strength - s.applied, ((lastmillis - s.startmillis) * s.strength / s.duration) - s.applied);
					else
						delta = min(s.strength - s.applied, ((lastmillis - s.startmillis) * s.strength / s.duration) - s.applied);

					s.applied += delta;
				}

				if(delta < 0) takedamage(-delta, s.resists);
				else d->health += delta;

				break;
			}
			case STATUS_MOVE:
				s.applied = s.strength;
				stat.movespeed += s.strength * potency;
				stat.jumpvel += s.strength * potency;
				break;
			case STATUS_STRENGTH:
				s.applied = s.strength;
				attr.strength += s.strength * potency;
				break;
			case STATUS_INTELLIGENCE:
				s.applied = s.strength;
				attr.intelligence += s.strength * potency;
				break;
			case STATUS_CHARISMA:
				s.applied = s.strength;
				attr.charisma += s.strength * potency;
				break;
			case STATUS_ENDURANCE:
				s.applied = s.strength;
				attr.endurance += s.strength * potency;
				break;
			case STATUS_AGILITY:
				s.applied = s.strength;
				attr.agility += s.strength * potency;
				break;
			case STATUS_LUCK:
				s.applied = s.strength;
				attr.luck += s.strength * potency;
				break;
			case STATUS_CRIT:
				s.applied = s.strength;
				conoutf("unimplemented");
				break;
			case STATUS_HREGEN:
				s.applied = s.strength;
				stat.healthregen += s.strength * potency;
				break;
			case STATUS_MREGEN:
				s.applied = s.strength;
				stat.manaregen += s.strength * potency;
				break;
			case STATUS_FIRE:
			case STATUS_WATER:
			case STATUS_AIR:
			case STATUS_EARTH:
			case STATUS_MAGIC:
			case STATUS_SLASH:
			case STATUS_BLUNT:
			case STATUS_PIERCE:
				s.applied = s.strength;
				stat.resistance[s.type - STATUS_FIRE] += s.strength * potency;
				break;
			case STATUS_DISPELL:
			case STATUS_DOOM:
			case STATUS_REFLECT:
				conoutf("unimplemented");
			case STATUS_INVIS:
				s.applied = s.strength;
				temp.fade -= (s.strength * potency) / 100.0f;
				break;
			case STATUS_LIGHT:
				s.applied = s.strength;
				rpgobj::lights.add(dynlightcache(abovehead(), s.strength * 2 * potency, vec(.6, .5, .3), 1));
				/*
					TODO make light colours configurable;

					perhaps work on a heat scale?
					ie weak intensity is red,
					stronger is yellow and,
					stronger still is white?
					http://en.wikipedia.org/wiki/File:EM_Spectrum_Properties_edit.svg
				*/
				break;
			case STATUS_DEATH:
			{
				stats st = d->base;
				st.mul(.8f * potency);
				d->attributes.sub(st);
				break;
			}
		}
	}
}

void rpgent::updateinv(stats &s)
{
	rpgchar *d = getchar();
	loopv(d->inventory)
	{
		rpgent *r = d->inventory[i];
		rpgitem *it = r->getitem();

		if(r->etype == ENT_CHAR || r->etype == ENT_OBJECT)
		{
			drop(r);
			continue;
		}
		else if(r->etype==ENT_SPELL)
		{
			d->inventory.remove(i--);
			loopvj(d->spellbook)
			{
				if (r == d->spellbook[j])
					continue;
			}
			d->spellbook.add(r);
			continue;
		}
		d->attributes.add(it->invbonus);
		s.addall(it->invbonus).sub(it->invbonus); //only add relevant bits
	}

	//just to make sure no non-spells end in the spellbook
	loopv(d->spellbook)
	{
		rpgent *r = d->spellbook[i];

		if(r->etype == ENT_CHAR || r->etype == ENT_OBJECT)
			drop(r);
		else if(r->etype==ENT_ITEM)
		{
			d->spellbook.remove(i--);
			loopvj(d->inventory)
			{
				if (r == d->inventory[j])
					continue;
			}
			d->inventory.add(r);
		}
	}

	loopi(EQUIP_MAX)
	{
		rpgent *r = d->selected[i];
		if(!r) continue;

		rpgitem *it = r->getitem();

		d->attributes.add(it->equipbonus);
		s.addall(it->invbonus).sub(it->invbonus);
		updateeffects(s, it->owneffects);
	}
}
