/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Vector;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private String PortName;
    private boolean Available = true;
    private String Owner;
    private CommPort commport;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int PortType;
    private static boolean debug;
    static Object Sync;
    Vector ownershipListener;
    private boolean HideOwnerEvents;

    static {
        debug = false;
        if (debug) {
            System.out.println("CommPortIdentifier:static initialization()");
        }
        Sync = new Object();
        try {
            CommDriver RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            RXTXDriver.initialize();
        }
        catch (Throwable e) {
            System.err.println(String.valueOf(String.valueOf(e)) + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        String OS = System.getProperty("os.name");
        if (OS.toLowerCase().indexOf("linux") == -1 && debug) {
            System.out.println("Have not implemented native_psmisc_report_owner(PortName)); in CommPortIdentifier");
        }
        System.loadLibrary("Serial");
    }

    CommPortIdentifier(String pn, CommPort cp, int pt, CommDriver driver) {
        this.PortName = pn;
        this.commport = cp;
        this.PortType = pt;
        this.next = null;
        this.RXTXDriver = driver;
    }

    public static void addPortName(String s, int type, CommDriver c) {
        if (debug) {
            System.out.println("CommPortIdentifier:addPortName(" + s + ")");
        }
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(s, null, type, c));
    }

    private static void AddIdentifierToList(CommPortIdentifier cpi) {
        if (debug) {
            System.out.println("CommPortIdentifier:AddIdentifierToList()");
        }
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = cpi;
                if (debug) {
                    System.out.println("CommPortIdentifier:AddIdentifierToList() null");
                }
            } else {
                CommPortIdentifier index = CommPortIndex;
                while (index.next != null) {
                    index = index.next;
                    if (!debug) continue;
                    System.out.println("CommPortIdentifier:AddIdentifierToList() index.next");
                }
                index.next = cpi;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener c) {
        if (debug) {
            System.out.println("CommPortIdentifier:addPortOwnershipListener()");
        }
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(c)) {
            this.ownershipListener.addElement(c);
        }
    }

    public String getCurrentOwner() {
        if (debug) {
            System.out.println("CommPortIdentifier:getCurrentOwner()");
        }
        return this.Owner;
    }

    public String getName() {
        if (debug) {
            System.out.println("CommPortIdentifier:getName()");
        }
        return this.PortName;
    }

    public static CommPortIdentifier getPortIdentifier(String s) throws NoSuchPortException {
        if (debug) {
            System.out.println("CommPortIdentifier:getPortIdentifier(" + s + ")");
        }
        CommPortIdentifier index = CommPortIndex;
        Object object = Sync;
        synchronized (object) {
            while (index != null) {
                if (index.PortName.equals(s)) break;
                index = index.next;
            }
        }
        if (index != null) {
            return index;
        }
        if (debug) {
            System.out.println("not found!" + s);
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(CommPort p) throws NoSuchPortException {
        if (debug) {
            System.out.println("CommPortIdentifier:getPortIdentifier(CommPort)");
        }
        CommPortIdentifier c = CommPortIndex;
        Object object = Sync;
        synchronized (object) {
            while (c != null && c.commport != p) {
                c = c.next;
            }
        }
        if (c != null) {
            return c;
        }
        if (debug) {
            System.out.println("not found!" + p.getName());
        }
        throw new NoSuchPortException();
    }

    public static Enumeration getPortIdentifiers() {
        if (debug) {
            System.out.println("static CommPortIdentifier:getPortIdentifiers()");
        }
        return new CommPortEnumerator();
    }

    public int getPortType() {
        if (debug) {
            System.out.println("CommPortIdentifier:getPortType()");
        }
        return this.PortType;
    }

    public synchronized boolean isCurrentlyOwned() {
        if (debug) {
            System.out.println("CommPortIdentifier:isCurrentlyOwned()");
        }
        return this.Available ^ true;
    }

    public synchronized CommPort open(FileDescriptor f) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("CommPortIdentifier:open(FileDescriptor)");
        }
        throw new UnsupportedCommOperationException();
    }

    private native String native_psmisc_report_owner(String var1);

    public synchronized CommPort open(String TheOwner, int i) throws PortInUseException {
        if (debug) {
            System.out.println("CommPortIdentifier:open(" + TheOwner + ", " + i + ")");
        }
        if (!this.Available) {
            Object object = Sync;
            synchronized (object) {
                this.fireOwnershipEvent(3);
                try {
                    this.wait(i);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.Available) {
            throw new PortInUseException(this.getCurrentOwner());
        }
        if (this.commport == null) {
            this.commport = this.RXTXDriver.getCommPort(this.PortName, this.PortType);
        }
        if (this.commport != null) {
            this.Owner = TheOwner;
            this.Available = false;
            this.fireOwnershipEvent(1);
            return this.commport;
        }
        throw new PortInUseException(this.native_psmisc_report_owner(this.PortName));
    }

    public void removePortOwnershipListener(CommPortOwnershipListener c) {
        if (debug) {
            System.out.println("CommPortIdentifier:removePortOwnershipListener()");
        }
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(c);
        }
    }

    synchronized void internalClosePort() {
        if (debug) {
            System.out.println("CommPortIdentifier:internalClosePort()");
        }
        this.Owner = null;
        this.Available = true;
        this.commport = null;
        this.notifyAll();
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int eventType) {
        if (debug) {
            System.out.println("CommPortIdentifier:fireOwnershipEvent( " + eventType + " )");
        }
        if (this.ownershipListener != null) {
            Enumeration e = this.ownershipListener.elements();
            while (e.hasMoreElements()) {
                CommPortOwnershipListener c = (CommPortOwnershipListener)e.nextElement();
                c.ownershipChange(eventType);
            }
        }
    }
}

