/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.LPRPort;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class RXTXCommDriver
implements CommDriver {
    private static boolean debug = false;
    private String deviceDirectory;
    private String osName;

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    private final String[] getValidPortPrefixes(String[] stringArray) {
        String[] stringArray2 = new String[256];
        if (debug) {
            System.out.println("\nRXTXCommDriver:getValidPortPrefixes()");
        }
        if (stringArray == null && debug) {
            System.out.println("\nRXTXCommDriver:getValidPortPrefixes() No ports prefixes known for this System.\nPlease check the port prefixes listed for " + this.osName + " in RXTXCommDriver:registerScannedPorts()\n");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.isPortPrefixValid(stringArray[n2])) {
                stringArray2[n++] = new String(stringArray[n2]);
            }
            ++n2;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        if (stringArray2[0] == null) {
            if (debug) {
                System.out.println("\nRXTXCommDriver:getValidPortPrefixes() No ports matched the list assumed for this\nSystem in the directory " + this.deviceDirectory + ".  Please check the ports listed for \"" + this.osName + "\" in\nRXTXCommDriver:registerScannedPorts()\nTried:");
                int n3 = 0;
                while (n3 < stringArray.length) {
                    System.out.println("\t" + stringArray[n]);
                    ++n3;
                }
            }
        } else if (debug) {
            System.out.println("\nRXTXCommDriver:getValidPortPrefixes()\nThe following port prefixes have been identified as valid on " + this.osName + ":\n");
        }
        return stringArray3;
    }

    private void checkSolaris(String string, int n) {
        char[] cArray = new char[]{'['};
        cArray[0] = 91;
        while (cArray[0] < '{') {
            if (this.testRead(string.concat(new String(cArray)), n)) {
                CommPortIdentifier.addPortName(string.concat(new String(cArray)), n, this);
            }
            cArray[0] = (char)(cArray[0] + '\u0001');
        }
    }

    private void registerValidPorts(String[] stringArray, String[] stringArray2, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (debug) {
            System.out.println("Entering registerValidPorts()");
            System.out.println(" Candidate devices:");
            int n5 = 0;
            while (n5 < stringArray.length) {
                System.out.println("  " + stringArray[n5]);
                ++n5;
            }
            System.out.println(" valid port prefixes:");
            n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.println("  " + stringArray2[n2]);
                ++n2;
            }
        }
        if (stringArray != null && stringArray2 != null) {
            n4 = 0;
            while (n4 < stringArray.length) {
                n3 = 0;
                while (n3 < stringArray2.length) {
                    String string = stringArray2[n3];
                    n2 = string.length();
                    String string2 = stringArray[n4];
                    if (string2.length() >= n2) {
                        String string3 = string2.substring(n2).toUpperCase();
                        String string4 = string2.substring(n2).toLowerCase();
                        if (string2.regionMatches(0, string, 0, n2) && string3.equals(string4)) {
                            String string5 = new String(this.deviceDirectory + string2);
                            if (debug) {
                                System.out.println(string2 + " " + string);
                                System.out.println(string3 + " " + string4);
                            }
                            if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                                this.checkSolaris(string5, n);
                            } else if (this.testRead(string5, n)) {
                                CommPortIdentifier.addPortName(string5, n, this);
                            }
                        }
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        if (debug) {
            System.out.println("Leaving registerValidPorts()");
        }
    }

    public void initialize() {
        if (debug) {
            System.out.println("RXTXCommDriver:initialize()");
        }
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        int n = 1;
        while (n <= 2) {
            if (!this.registerSpecifiedPorts(n) && !this.registerKnownPorts(n)) {
                this.registerScannedPorts(n);
            }
            ++n;
        }
    }

    private void addSpecifiedPorts(String string, int n) {
        String string2 = System.getProperty("path.separator", ":");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (debug) {
            System.out.println("\nRXTXCommDriver:addSpecifiedPorts()");
        }
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!this.testRead(string3, n)) continue;
            CommPortIdentifier.addPortName(string3, n, this);
        }
    }

    private boolean registerSpecifiedPorts(int n) {
        String string;
        block9: {
            string = null;
            try {
                String string2 = System.getProperty("java.ext.dirs") + System.getProperty("file.separator");
                FileInputStream fileInputStream = new FileInputStream(string2 + "gnu.io.rxtx.properties");
                Properties properties = new Properties(System.getProperties());
                properties.load(fileInputStream);
                System.setProperties(properties);
            }
            catch (Exception exception) {
                if (!debug) break block9;
                System.out.println("The file: gnu.io.rxtx.properties doesn't exists.");
                System.out.println(exception.toString());
            }
        }
        if (debug) {
            System.out.println("checking for system-known ports of type " + n);
        }
        if (debug) {
            System.out.println("checking registry for ports of type " + n);
        }
        switch (n) {
            case 1: {
                string = System.getProperty("gnu.io.rxtx.SerialPorts");
                if (string != null) break;
                string = System.getProperty("gnu.io.SerialPorts");
                break;
            }
            case 2: {
                string = System.getProperty("gnu.io.rxtx.ParallelPorts");
                if (string != null) break;
                string = System.getProperty("gnu.io.ParallelPorts");
                break;
            }
            default: {
                if (!debug) break;
                System.out.println("unknown port type " + n + " passed to RXTXCommDriver.registerSpecifiedPorts()");
            }
        }
        if (string != null) {
            this.addSpecifiedPorts(string, n);
            return true;
        }
        return false;
    }

    private void registerScannedPorts(int n) {
        String[] stringArray;
        Object object;
        if (debug) {
            System.out.println("scanning device directory " + this.deviceDirectory + " for ports of type " + n);
        }
        if (this.osName.toLowerCase().indexOf("windows") != -1) {
            object = new String[]{"COM1", "COM2", "COM3", "COM4"};
            stringArray = object;
        } else if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
            object = new String[2];
            int n2 = 0;
            File file = null;
            file = new File("/dev/term");
            if (file.list().length > 0) {
                // empty if block
            }
            object[n2++] = new String("term/");
            file = new File("/dev/cua0");
            if (file.list().length > 0) {
                // empty if block
            }
            object[n2++] = new String("cua/");
            String[] stringArray2 = new String[n2];
            --n2;
            while (n2 >= 0) {
                stringArray2[n2] = object[n2];
                --n2;
            }
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            object = new File(this.deviceDirectory);
            stringArray = stringArray3 = ((File)object).list();
        }
        if (stringArray == null) {
            if (debug) {
                System.out.println("RXTXCommDriver:registerScannedPorts() no Device files to check ");
            }
            return;
        }
        object = new String[]{};
        switch (n) {
            case 1: {
                if (debug) {
                    System.out.println("scanning for serial ports for os " + this.osName);
                }
                if (this.osName.equals("Linux")) {
                    String[] stringArray4 = new String[]{"ttyS"};
                    object = stringArray4;
                    break;
                }
                if (this.osName.equals("Linux-all-ports")) {
                    String[] stringArray5 = new String[]{"comx", "holter", "modem", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    object = stringArray5;
                    break;
                }
                if (this.osName.equals("Irix")) {
                    String[] stringArray6 = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    object = stringArray6;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] stringArray7 = new String[]{"cuaa"};
                    object = stringArray7;
                    break;
                }
                if (this.osName.equals("NetBSD")) {
                    String[] stringArray8 = new String[]{"tty0"};
                    object = stringArray8;
                    break;
                }
                if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                    String[] stringArray9 = new String[]{"term/", "cua/"};
                    object = stringArray9;
                    break;
                }
                if (this.osName.equals("HP-UX")) {
                    String[] stringArray10 = new String[]{"tty0p", "tty1p"};
                    object = stringArray10;
                    break;
                }
                if (this.osName.equals("UnixWare") || this.osName.equals("OpenUNIX")) {
                    String[] stringArray11 = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    object = stringArray11;
                    break;
                }
                if (this.osName.equals("OpenServer")) {
                    String[] stringArray12 = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    object = stringArray12;
                    break;
                }
                if (this.osName.equals("Compaq's Digital UNIX")) {
                    String[] stringArray13 = new String[]{"tty0"};
                    object = stringArray13;
                    break;
                }
                if (this.osName.equals("BeOS")) {
                    String[] stringArray14 = new String[]{"serial"};
                    object = stringArray14;
                    break;
                }
                if (this.osName.equals("Mac OS X")) {
                    String[] stringArray15 = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    object = stringArray15;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") != -1) {
                    String[] stringArray16 = new String[]{"COM"};
                    object = stringArray16;
                    break;
                }
                if (!debug) break;
                System.out.println("No valid prefixes for serial ports have been entered for " + this.osName + " in RXTXCommDriver.java.  This may just be a typo in the method registerScanPorts().");
                break;
            }
            case 2: {
                if (debug) {
                    System.out.println("scanning for parallel ports for os " + this.osName);
                }
                if (this.osName.equals("Linux")) {
                    String[] stringArray17 = new String[]{"lp"};
                    object = stringArray17;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] stringArray18 = new String[]{"lpt"};
                    object = stringArray18;
                    break;
                }
                String[] stringArray19 = new String[]{};
                object = stringArray19;
                break;
            }
            default: {
                if (!debug) break;
                System.out.println("Unknown PortType " + n + " passed to RXTXCommDriver.registerScannedPorts()");
            }
        }
        this.registerValidPorts(stringArray, (String[])object, n);
    }

    public CommPort getCommPort(String string, int n) {
        block8: {
            if (debug) {
                System.out.println("RXTXCommDriver:getCommPort(" + string + "," + n + ")");
            }
            try {
                switch (n) {
                    case 1: {
                        return new RXTXPort(string);
                    }
                    case 2: {
                        return new LPRPort(string);
                    }
                }
                if (debug) {
                    System.out.println("unknown PortType  " + n + " passed to RXTXCommDriver.getCommPort()");
                }
            }
            catch (PortInUseException portInUseException) {
                if (!debug) break block8;
                System.out.println("Port " + string + " in use by another application");
            }
        }
        return null;
    }

    public void Report(String string) {
        System.out.println(string);
    }

    static {
        if (debug) {
            System.out.println("RXTXCommDriver {}");
        }
        System.loadLibrary("Serial");
    }
}

