#include "RSGGobi.h"

#include <gtk/gtk.h>

#include "vars.h"

USER_OBJECT_
RS_GGOBI(createEmptyData)(USER_OBJECT_ snrow, USER_OBJECT_ name, USER_OBJECT_ description, USER_OBJECT_ gobiId)
{
  ggobid *gg = GetGGobi(gobiId);
  datad *d;

  if((gg = ValidateGGobiRef(gg, false)) == NULL) {
    return(R_NilValue);
  }

  d = datad_create(INTEGER_DATA(snrow)[0], 0, gg);
  if(!d) {
     PROBLEM "Can't create GGobi dataste"
     ERROR;
  }

  GGobi_setDataName(CHAR_DEREF(STRING_ELT(name, 0)), d);

  if(!d->input) 
     d->input = g_malloc(sizeof(InputDescription));

  d->input->fileName = g_strdup(CHAR_DEREF(STRING_ELT(description, 0)));

  pipeline_init(d, gg);
  rows_in_plot_set (d, gg);

  return(RS_datasetInstance(d, gg));
}


/*
  Set the names of rows/observations identified
  by the elements of the indices array which should
  be between 0 and nrows - 1.
 */

USER_OBJECT_
RS_GGOBI(setRowNames)(USER_OBJECT_ names, USER_OBJECT_ indices, USER_OBJECT_ datasetId, USER_OBJECT_ gobiId)
{
  datad *d;
  gchar *tmp, *lbl;
  gint i;
  USER_OBJECT_ ans = NULL_USER_OBJECT;

  d = resolveDatad(datasetId, gobiId, NULL);

  if(d) {
    gboolean getOldValues;
    int num = GET_LENGTH(names);
    int which;

    if(!d->rowlab->data) {
     rowlabels_alloc(d);
     getOldValues = false;
    }

    if(getOldValues)
	PROTECT(ans = NEW_CHARACTER(num));

     for(i = 0; i < num; i++) {
       which = INTEGER_DATA(indices)[i];
       if(getOldValues) {
	   tmp = (gchar *) g_array_index (d->rowlab, gchar *, which);

          /* Copy and free the old value! 
             Currently not freeing this. Bad things happen. Need
             to find out what the g_array_index and insert_val 
             are doing with memory management!
           */    
           if(tmp && tmp[0]) {
  	      SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(tmp));
	      /*  	  g_free(tmp); */
              tmp = NULL;
            }
       }

       lbl = g_strdup(CHAR_DEREF(STRING_ELT(names, i)));
       g_array_insert_val (d->rowlab, which, lbl);
     }

     if(getOldValues)
	 UNPROTECT(1);
  }

  return(ans);
}


#if 1
USER_OBJECT_
RS_GGOBI(setData)(USER_OBJECT_ values, 
		  USER_OBJECT_ rowNames, USER_OBJECT_ colNames,
		  USER_OBJECT_ dims,
		  USER_OBJECT_ description,  
		  USER_OBJECT_ name, 
		  USER_OBJECT_ add, 
		  USER_OBJECT_ ids,
		  USER_OBJECT_ data,
		  USER_OBJECT_ gobiID)
{
  InputDescription *desc;

  ggobid *gg = GetGGobi(gobiID); 
  datad *d = NULL;
  gchar **indices = NULL;
  char **colnames = NULL, **rownames = NULL;
  int i, n;

  USER_OBJECT_ num;

  if((gg = ValidateGGobiRef(gg, false)) == NULL) {
    return(R_NilValue);
  }

/* Resolve the data argument given. */
  if(LOGICAL_DATA(add)[0] || g_slist_length (gg->d) < 1)
    d = datad_new(d, gg);
  else {
    d = (datad *) g_slist_nth_data (gg->d, 0);
  }

  desc = (InputDescription *) g_malloc(sizeof(InputDescription));
  memset(desc, '\0', sizeof(InputDescription));
  desc->fileName = g_strdup(CHAR_DEREF(STRING_ELT(description, 0)));
  desc->mode = Sprocess_data;
  d->name = g_strdup(CHAR_DEREF(STRING_ELT(name, 0)));


/* Do we need to take care of the case that the values are empty (i.e. NULL
 or numeric(0). */

  if((n = GET_LENGTH(rowNames)) > 0) {
	 rownames = (char **) S_alloc(n , sizeof(char*));
	 for(i = 0; i < n ; i++)
	   rownames[i] = CHAR_DEREF(STRING_ELT(rowNames, i));
  }

  if((n = GET_LENGTH(colNames)) > 0) {
	 colnames = (char **) S_alloc(n , sizeof(char*));
	 for(i = 0; i < n ; i++)
	   colnames[i] = CHAR_DEREF(STRING_ELT(colNames, i));
  }


  if((n = GET_LENGTH(ids)) > 0) {
	 indices = (gchar **) S_alloc(n , sizeof(gchar*));
	 for(i = 0; i < n ; i++)
  	    indices[i] = CHAR_DEREF(STRING_ELT(ids, i));
    }


  if(GET_LENGTH(values))
   GGOBI(setData)(NUMERIC_DATA(values),
		   rownames, colnames,
	  	   INTEGER_DATA(dims)[0], INTEGER_DATA(dims)[1], 
   	  	   d, !LOGICAL_DATA(add)[0], gg,
		   indices, indices != NULL, desc);
   else {
    if(!gg->input) {
       gg->input = desc;
    }
    d->ncols =0;
   }

/*  datad_init(d, gg, false); */


/*  
  start_ggobi() call replaces  display_menu_build(gg).
  This should work at least in the case we are initializing ggobi.
  If we are adding a dataset, we may need to think more.

  start_ggobi(gg, true, *num == 1);
*/

  num = NEW_INTEGER(1);
  INTEGER_DATA(num)[0] = g_slist_length(gg->d);

  gdk_flush();
  return(num);
}
#else
/*
 This is special as it allows the ggobi object to be passed as the 
 pointer to the ggobid object. This is why it is a double and special
 care is needed in the calling S function.
 */

void 
RS_GGOBI(setData)(double *values, char **rownames, char **colnames,
		  long *dims, char **description,  char **name, long *add, long *ids,
		  long *num, double *gobiID)
{
  InputDescription *desc;

  ggobid *gg = GetGGobi(gobiID); 
  datad *d = NULL;
 
  if((gg = ValidateGGobiRef(gg, false)) == NULL) {
    return;
  }

  if(*add || g_slist_length (gg->d) < 1)
    d = datad_new(d, gg);
  else {
    d = (datad *) g_slist_nth_data (gg->d, 0);
  }

  desc = (InputDescription *) g_malloc(sizeof(InputDescription));
  memset(desc, '\0', sizeof(InputDescription));
  desc->fileName = g_strdup(description[0]);
  desc->mode = Sprocess_data;
  d->name = g_strdup(name[0]);

  GGOBI(setData)(values, rownames, colnames,
    dims[0], dims[1], d, !(*add), gg,
    ids, true, desc);

/*  
  start_ggobi() call replaces  display_menu_build(gg).
  This should work at least in the case we are initializing ggobi.
  If we are adding a dataset, we may need to think more.
*/
  *num = g_slist_length(gg->d);

/*
  start_ggobi(gg, true, *num == 1);
*/
  gdk_flush();
}
#endif


USER_OBJECT_
RS_GGOBI(setDataName)(USER_OBJECT_ name, USER_OBJECT_ datasetId)
{
   datad *d;
   d = resolveDatad(datasetId, NULL, NULL);
   GGobi_setDataName(CHAR_DEREF(STRING_ELT(name, 0)), d);

   return(NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(setDataValues)(USER_OBJECT_ values)
{

    return(NULL_USER_OBJECT);
}


#ifdef OBSOLETE_EDGE_CODE
/*

Currently never called.

  Must call this with ids being of length num[0] * 2
  and the points of interest being contiguous
  i.e to check if 1 is connected to 2 and 4 connected to 6
  ids should be  {1, 2, 4, 6}
  ans should be of length num[0].
 */
USER_OBJECT_
RS_GGOBI(isConnected)(USER_OBJECT_ ids, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 int ctr = 0, i;
 ggobid *gg;
 datad *d;
 int num;
 USER_OBJECT_ ans;
  d = resolveDatad(datasetId, ggobiId, &gg);
  num = GET_LENGTH(ids)/2;
  ans = NEW_LOGICAL(num/2);

  for(i = 0; i < num; i++, ctr+=2) {
    LOGICAL_DATA(ans)[i] = GGOBI(isConnectedEdge)(INTEGER_DATA(ids)[ctr], INTEGER_DATA(ids)[ctr+1], d, gg);
  }
 return(ans);
}
#endif

USER_OBJECT_
RS_GGOBI(createEdgeDataset)(USER_OBJECT_ numPoints, USER_OBJECT_ sname, USER_OBJECT_ ggobiId)
{
   ggobid *gg = GetGGobi(ggobiId);
   datad *d;

   if(!gg) {
      PROBLEM "Invalid reference to GGobi instance"
      ERROR;
   }

   d = datad_create(INTEGER_DATA(numPoints)[0], 0, gg);
   if(!d) {
      PROBLEM "Invalid reference to GGobi instance"
      ERROR;
   }

   GGobi_setDataName(CHAR_DEREF(STRING_ELT(sname, 0)), d);
   pipeline_init(d, gg);

   return(RS_datasetInstance(d, gg));
}

USER_OBJECT_
RS_GGOBI(setEdges)(USER_OBJECT_ x, USER_OBJECT_ y, USER_OBJECT_ append, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  ggobid *gg;
  datad *e;
  int num = GET_LENGTH(x);
  gint i;
  e = resolveDatad(datasetId, ggobiId, &gg);

  if(!e) 
    return(ans);

  if(LOGICAL_DATA(append)[0] == FALSE) {
     g_free(e->edge.sym_endpoints);
     e->edge.n = 0;
  }

  if(num > 0) {
    
   edges_alloc (e->edge.n + num, e);

   for(i = 0; i < num; i++) {
     e->edge.sym_endpoints[i].a = g_strdup(CHAR_DEREF(STRING_ELT(x, i)));
     e->edge.sym_endpoints[i].b = g_strdup(CHAR_DEREF(STRING_ELT(y, i)));
     e->edge.sym_endpoints[i].jpartner = -1;
   }
  }

  unresolveAllEdgePoints(e);
  if(gg->current_display) {
    edgeset_add(gg->current_display);
    displays_plot(NULL, FULL, gg);
  }
  gdk_flush();

  ans = RS_datasetInstance(e, gg);

  return(ans);
}


/**
  Newer, but old,  version for the edges interface using multiple (at least 2) datasets for 
  the point set and the edge set.

  This sets the connections between nodes.
  We can either replace the existing edges or append to that collection.
  The source and destination variables identify the nodes in pairs.

 */
USER_OBJECT_
RS_GGOBI(setEdgeIndices)(USER_OBJECT_ x, USER_OBJECT_ y, USER_OBJECT_ append,
                          USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  ggobid *gg;
  datad *e;
  int num = GET_LENGTH(x);
  gint i;
  e = resolveDatad(datasetId, ggobiId, &gg);

  if(!e) 
    return(ans);

  if(LOGICAL_DATA(append)[0] == FALSE) {
     edges_free (e, gg);
     e->edge.n = 0;
#ifdef OLD_STYLE_IDS
     e->edge.old_endpoints = NULL;
#endif
  }

  edges_alloc (e->edge.n + num, e);

  for(i = 0; i < num; i++) {
#ifdef OBSOLETE_EDGE_CODE
     /* Without the update argument, this would be a very slow way of doing this.
   	We would end up re-allocating the edges_endpoint
   	each time. However, pre-allocating it to *num
   	means we have to tell setObservationEdge something
   	to avoid it reallocating space itself.
      */
     GGOBI(setObservationEdge)(INTEGER_DATA(x)[i], INTEGER_DATA(y)[i], e, gg, false);
#endif
#ifdef OLD_STYLE_IDS
     e->edge.old_endpoints[i].a = INTEGER_DATA(x)[i];
     e->edge.old_endpoints[i].b = INTEGER_DATA(y)[i];
     e->edge.old_endpoints[i].jpartner = -1;
#endif
  }

#ifdef OLD_STYLE_IDS
  setOldEdgePartners(e->edge.old_endpoints, e->edge.n);
#endif

  edgeset_add(gg->current_display);

  displays_plot(NULL, FULL, gg);
  gdk_flush();

  ans = RS_datasetInstance(e, gg);

  return(ans);
}


USER_OBJECT_
RS_GGOBI(setDisplayEdges)(USER_OBJECT_ dpys, USER_OBJECT_ edgeData, USER_OBJECT_ directed, USER_OBJECT_ On, USER_OBJECT_ ggobiId)
{
    int i, n;
    USER_OBJECT_ ans;
    displayd *gdpy;
    datad *edge;
    ggobid *gg = GetGGobi(ggobiId);

    edge = GetDatad(edgeData);
    if(!edge && LOGICAL_DATA(On)[0] == TRUE)
	return(NULL_USER_OBJECT);

    n = GET_LENGTH(dpys);
    PROTECT(ans = NEW_LIST(n));
    for(i = 0; i < n ; i++) {
	gdpy = GetDisplay(VECTOR_ELT(dpys, i), ggobiId, NULL);
        if(gdpy) {
            datad *old;
            gdpy->options.edges_undirected_show_p = LOGICAL_DATA(On)[0];
	    if(GET_LENGTH(directed))
               gdpy->options.edges_arrowheads_show_p = LOGICAL_DATA(directed)[0];
	    if(edge) {
 	        old = setDisplayEdge(gdpy, edge);
                if(old) {
		  SET_VECTOR_ELT(ans, i, RS_datasetInstance(old, old->gg));
	        }
	    }
	}
    }

    UNPROTECT(1);
    displays_plot(NULL, FULL, gg);
    gdk_flush();
    return(ans);
}



/*-------------------------------------------------------------------------*/
/*                              glyphs                                     */
/*-------------------------------------------------------------------------*/

USER_OBJECT_
RS_GGOBI(setCaseGlyphs)(USER_OBJECT_ vals, USER_OBJECT_ sizes, USER_OBJECT_ which, 
                     USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  ggobid *gg;
  datad *d;
  d = resolveDatad(datasetId, ggobiId, &gg);
 
  if(d) {
    gint i, id;
    int num = GET_LENGTH(which);
    for(i = 0; i < num; i++) {
      id = INTEGER_DATA(which)[i];
      GGOBI(setCaseGlyph)(id, INTEGER_DATA(vals)[i], INTEGER_DATA(sizes)[i], d, gg);
    } 

#if 0
    clusters_set (d, gg);
#endif
    displays_plot(NULL, FULL, gg);
    gdk_flush();
  }

 return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_GGOBI(getCaseGlyphs)(USER_OBJECT_ ids, USER_OBJECT_ datasetID, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans, types, sizes, names;
  gint i, id, n;
  gboolean all = true;
  ggobid *gg;
  datad *d;

  d = resolveDatad(datasetID, ggobiId, NULL);
  if(!d)
    return(NULL_USER_OBJECT);

  if(GET_LENGTH(ids) > 0) { 
    n = GET_LENGTH(ids);
    all = false;
  } else
    n = d->nrows;

  PROTECT(types = NEW_INTEGER(n));
  PROTECT(sizes = NEW_INTEGER(n));
  PROTECT(names = NEW_CHARACTER(n));
  for(i = 0; i < n; i++) {
    gchar const *typeName;
    int type;
    if(all) {
      id = i;
    } else {
      id = INTEGER_DATA(ids)[i];
    }
      /* Don't convert to names. */
    INTEGER_DATA(types)[i] = type = GGOBI(getCaseGlyphType)(id, d, gg);
    typeName = GGOBI(getGlyphTypeName)(type);
    SET_STRING_ELT(names, i, COPY_TO_USER_STRING(typeName));
    INTEGER_DATA(sizes)[i] = GGOBI(getCaseGlyphSize)(id, d, gg);
  }

  SET_NAMES(types, names);

  PROTECT(ans = NEW_LIST(2));
  SET_VECTOR_ELT(ans, 0, types);
  SET_VECTOR_ELT(ans, 1, sizes);

  PROTECT(names = NEW_CHARACTER(2));
  SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("type"));
  SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("size"));
  SET_NAMES(ans, names);

  UNPROTECT(5);

  return(ans);
}

#if 0
USER_OBJECT_
RS_GGOBI(setCaseColors)(USER_OBJECT_ which, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint num = GET_LENGTH(which);
  ggobid *gg;
  datad *d;
  d = resolveDatad(datasetId, ggobiId, &gg);
  gint i;

  for(i = 0; i < n; i++) {
    if(IS_LOGICAL(which))
       d->missing.vals[i][j] = LOGICAL_DATA(which)[i];
    else {
       d->missing.vals[i][j] = LOGICAL_DATA(which)[i];
    }
  }

  return(NULL_USER_OBJECT);
}
#endif

/*-------------------------------------------------------------------------*/
/*                         point colors                                    */
/*-------------------------------------------------------------------------*/

USER_OBJECT_
RS_GGOBI(setCaseColors)(USER_OBJECT_ vals, USER_OBJECT_ which, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint i, id;
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  gint num = GET_LENGTH(which);
  ggobid *gg;
  datad *d;
  d = resolveDatad(datasetId, ggobiId, &gg);
  
  if(d) {
       for(i = 0; i < num; i++) {
      	 id = INTEGER_DATA(which)[i];
      	 GGOBI(setCaseColor)(id, INTEGER_DATA(vals)[i] - 1, d, gg);
       }
      
       clusters_set (d, gg);
       displays_plot(NULL, FULL, gg);
       gdk_flush();
  }

  return(ans);
}


USER_OBJECT_
RS_GGOBI(getCaseColors)(USER_OBJECT_ ids, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ colors, names;
  gint i, id, n, color;
  gboolean all = true;
  const gchar *colorName;

  ggobid *gg;
  datad *d;
  d = resolveDatad(datasetId, ggobiId, &gg);

  if(d == NULL)
    return(NULL_USER_OBJECT);

  if(GET_LENGTH(ids) > 0) { 
    n = GET_LENGTH(ids);
    all = false;
  } else
    n = d->nrows;

  PROTECT(colors = NEW_INTEGER(n));
  PROTECT(names = NEW_CHARACTER(n));
  
  for(i = 0; i < n; i++) {
    if(all) {
      id = i;
    } else {
      id = INTEGER_DATA(ids)[i];
    }
      /* Don't convert to names. */
    INTEGER_DATA(colors)[i] = color = GGOBI(getCaseColor)(id, d, gg);
    colorName = GGOBI(getColorName)(color, gg, true);
    if(colorName && colorName[0])
      SET_STRING_ELT(names, i, COPY_TO_USER_STRING(colorName));
  }

  SET_NAMES(colors, names);

  UNPROTECT(2);

  return(colors);
}


USER_OBJECT_
RS_GGOBI(setPlotRange)(USER_OBJECT_ x, USER_OBJECT_ y, USER_OBJECT_ plot,
                         USER_OBJECT_ rdisplay, USER_OBJECT_ ggobiId)
{
  ggobid *gg;
  displayd *display;
  USER_OBJECT_ ans;

  display = GetDisplay(rdisplay, ggobiId, &gg);
  if(!display)
    return(NULL_USER_OBJECT);

  GGOBI(setPlotRange)(NUMERIC_DATA(x), NUMERIC_DATA(y), INTEGER_DATA(plot)[0]-1, display, false, gg);

  gdk_flush();

  ans = NEW_LOGICAL(1);
  LOGICAL_DATA(ans)[0] = TRUE;
  return(ans);
}
