getRowNames.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi()) 
{
  if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 .GGobiCall("getRowNames", .data, .gobi = .gobi)
}


setRowNames.ggobi <-
function(names, ids = 1:length(names), .data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 ids <- as.integer(ids -1)

 .GGobiCall("setRowNames", as.character(names), ids, .data, .gobi = .gobi)
}


getSampledRecords.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 .GGobiCall("getSampledIndices", .data = .data, .gobi = .gobi)
}

setSampledRecords.ggobi <-
function(which, .data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 if(is.numeric(which)) {
  # Get the number of records (nrow) and compute 
  #   x <- logical(nrow)
  #   x[which] <- TRUE
  #   which <- x
 }

 .GGobiCall("setSampledIndices", as.logical(which), .data = .data, .gobi = .gobi)
}

getExcludedRecords.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 .GGobiCall("getExcludedIndices", .data = .data, .gobi = .gobi)
}

setExcludedRecords.ggobi <-
function(which, .data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 .GGobiCall("setExcludedIndices", as.logical(which), .data = .data, .gobi = .gobi)
}

getRecordsInPlot.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data-1)

 .GGobiCall("getRowsInPlot", .data = .data, .gobi = .gobi) + as.integer(1)
}



