/* pgp4pine declares.h
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

/* ******************************************************* */

#include "structs.h"
#include "defines.h"

#ifndef DECLARES_H
#define DECLARES_H

/* pgp4pine common.c */

void clearScreen();
int runProcessFG(const char *commandToRun);
int askInteger(const char prompt[1024],int defaultVal);
int askAlphaRange(const char prompt[1024],char defaultVal,char maxVal);
void waitForReturn();
void printUsage();
void printVersion();
void pipeSTDINToFile(const char *fileName);
void *myMalloc(size_t size);
void myFree(void *oldPtr);
void stillAlive();
void killFirstChar(char *inString);
void cpString(FILE *inFile, char *buf, int maxLen);

/* pgp4pine debug.c */

void openDebugFile();
void documentStatus(const char *status);
void closeDebugFile();

/* pgp4pine keyrings.c */

void deallocAllKeys(struct pkiKey *killKey);
void gettheKeys();
void regetPublicKeyring();
struct pkiKey *getKeyring(int getSecretOnly);
char *extractDisplayName(const char *stringIn);
char *extractEmailAddress(const char *stringIn);

/* pgp4pine main.c */

int main(int argc,char **argv);

/* pgp4pine menus.c */

void fileVerifyDecryptMenu(const char *inFile,const char *outFile);
// void fileVerifyMenu(const char *inFile,const char *outFile);
int  fileSignEncryptMenu(const char *inFile, char *outFile, char *recipients);

/* pgp4pine pki.c */

int pipe_pgp(const char *cmd, FILE **in, FILE **out);
void fileDecrypt(const char *inFile,const char *outFile);
void fileVerify(const char *inFile,const char *outFile);
void fileSignEncrypt(const char *inFileName,
		     const char *outFileName,
		     const int sign, const int encrypt,
		     char *recipient, 
		     const int asciiArmor, const int universalText,
		     int encryptToSelf,int detachSigs);
void parseList(char *recipients,char *nokeyrecipients);
int checkRecipient(char *thisRecip);
void printKeyInfo(char c, struct pkiKey *thisKey);
void fileAskKey(char *nokeyrecipients);

/* pgp4pine prefs.c */

char *readPrefs(const char *searchKey, char *defaultVal);
void readRCFile();

/* pgp4pine profiles.c */

void clearProfiles(struct myProfile *firstProfile);
void selectProfile();

#endif
