// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/os/nt/nt_platform_utils.cpp,v 1.4 2001/12/10 09:42:54 gwu2 Exp $
//


#include <direct.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>

#ifdef OBJECT_LOCK_V2
#include "platform_utils_olv2.h"
#else
#include "platform_utils.h"
#endif

int generic_get_num_dir_entries(const char *dir_path)
{
	// First save the current directory, and chdir to dir_path

	char pwd_buffer[_MAX_PATH];   
	if (_getcwd(pwd_buffer, _MAX_PATH ) == NULL) {
		perror( "_getcwd error" );
		return -1;
	} 
	
	// Now, _chdir.
	if(_chdir(dir_path)) { 
		printf("Unable to locate the directory: %s\n", dir_path); 
		return -1;
	}

	struct _finddatai64_t file_info;
	long handle;

	// We need to read names of all files. 
	if ((handle = _findfirsti64("*", &file_info)) == -1) {
		// Call failed.
		perror("Call to _findfirsti64 fails in generic_first_dir_ent()..."); 
	}

	int num_entries = -1;
	if (handle != -1) { 
		// We have valid value for handle, so loop until last entry is reached
		// We already have one, so num_entries starts with value of 1.
		num_entries = 1;
		while(1) {
			__int64 ret = _findnexti64(handle, &file_info );
			if (ret != 0) 
				break;
			num_entries++;
		}
	}		
	_findclose((long)handle);

	// Now, _chdir back, and return.
	if(_chdir(pwd_buffer)) { 
		printf("Unable to locate the directory: %s\n", pwd_buffer); 
		return -1;
	}
	return num_entries;
}



__int64 generic_first_dir_ent(const char *dir_path, char **name) 
{

	// First save the current directory, and chdir to dir_path

	char pwd_buffer[_MAX_PATH];   
	if (_getcwd(pwd_buffer, _MAX_PATH ) == NULL) {
		perror( "_getcwd error" );
		return -1;
	} 
	
	// Now, _chdir.
	if(_chdir(dir_path)) { 
		printf("Unable to locate the directory: %s\n", dir_path); 
		return -1;
	}

	struct _finddatai64_t file_info;
	__int64 handle;

	// We need to read names of all files.
	if ((handle = _findfirsti64("*", &file_info)) == -1) {
		// Call failed.
		perror("Call to _findfirsti64 fails in generic_first_dir_ent()..."); 
	}

	// Now, _chdir back, and return.
	if(_chdir(pwd_buffer)) { 
		printf("Unable to locate the directory: %s\n", pwd_buffer); 
		return -1;
	}
	char *new_name = (char *) malloc(strlen(file_info.name) + 1);
	strcpy(new_name, file_info.name);
	*name = new_name;
	return handle;
}


const char * generic_get_next_dir_entry(__int64 handle, const char *dir_path)
{
	// First save the current directory, and chdir to dir_path
	char pwd_buffer[_MAX_PATH];   
	if (_getcwd(pwd_buffer, _MAX_PATH ) == NULL) {
		perror( "_getcwd error" );
		return NULL;
	} 
	
	// Now, _chdir.
	if(_chdir(dir_path)) { 
		printf("Unable to locate the directory: %s\n", dir_path); 
		return NULL;
	}

	// The handle refers to a group of files.
	struct _finddatai64_t file_info;
	__int64 ret = _findnexti64((long)handle, &file_info );

	// Now, _chdir back, and return.
	if(_chdir(pwd_buffer)) { 
		printf("Unable to locate the directory: %s\n", pwd_buffer); 
		return NULL;
	}

	if (ret != 0) {
		// End of entries??
		_findclose((long)handle);
		return NULL;
	}
	// A valid file_info structure upon return from system call.
	// So, we now return the name of the file.

	char *new_name = (char *) malloc(strlen(file_info.name) + 1);
	strcpy(new_name, file_info.name);
	return new_name; 
}

#include "platform.h"
BOOL ctrl_handler(DWORD ctrlType) 
{ 
    switch (ctrlType) 
    { 
	case CTRL_C_EVENT: 
	case CTRL_BREAK_EVENT: 
	case CTRL_CLOSE_EVENT:
	case CTRL_LOGOFF_EVENT:
	case CTRL_SHUTDOWN_EVENT:
		extern void interrupt_handler(int);
	    interrupt_handler(0);
        return TRUE; 
 	default:
		assert(0);
    } 
        return FALSE; 
} 

void initialize_signals(){
	BOOL ok = SetConsoleCtrlHandler( (PHANDLER_ROUTINE) ctrl_handler, TRUE); 
	assert(ok);
}

//The following is for socket error handling
const char *sock_errstr[] = { 
NULL, /* 10000 WSABASEERR */
NULL,
NULL,
NULL,
/*10004 WSAEINTR*/          "(10004) Interrupted by socket close",     
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
/*10013 WSAEACCES*/         "(10013) Permission denied",       
/*10014 WSAEFAULT*/         "(10014) Bad address",       
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
/*10022 WSAEINVAL*/         "(10022) Invalid argument",       
NULL,
/*10024 WSAEMFILE*/         "(10024) Too many open files",     
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
/*10035 WSAEWOULDBLOCK*/    "(10035) Resource temporarily unavailable",      
/*10036 WSAEINPROGRESS*/    "(10036) Operation now in progress",     
/*10037 WSAEALREADY*/       "(10037) Operation already in progress",     
/*10038 WSAENOTSOCK*/       "(10038) Socket operation on non-socket",     
/*10039 WSAEDESTADDRREQ*/   "(10039) Destination address required",      
/*10040 WSAEMSGSIZE*/       "(10040) Message too long",      
/*10041 WSAEPROTOTYPE*/     "(10041) Protocol wrong type for socket",    
/*10042 WSAENOPROTOOPT*/    "(10042) Bad protocol option",      
/*10043 WSAEPROTONOSUPPORT*/"(10043) Protocol not supported",      
/*10044 WSAESOCKTNOSUPPORT*/"(10044) Socket type not supported",     
/*10045 WSAEOPNOTSUPP*/     "(10045) Operation not supported",      
/*10046 WSAEPFNOSUPPORT*/   "(10046) Protocol family not supported",     
/*10047 WSAEAFNOSUPPORT*/   "(10047) Address family not supported by protocol family",  
/*10048 WSAEADDRINUSE*/     "(10048) Address already in use",     
/*10049 WSAEADDRNOTAVAIL*/  "(10049) Cannot assign requested address",     
/*10050 WSAENETDOWN*/       "(10050) Network is down",      
/*10051 WSAENETUNREACH*/    "(10051) Network is unreachable",      
/*10052 WSAENETRESET*/      "(10052) Network dropped connection on reset",    
/*10053 WSAECONNABORTED*/   "(10053) Software caused connection abort",     
/*10054 WSAECONNRESET*/     "(10054) Connection reset by peer",     
/*10055 WSAENOBUFS*/        "(10055) No buffer space available",     
/*10056 WSAEISCONN*/        "(10056) Socket is already connected",     
/*10057 WSAENOTCONN*/       "(10057) Socket is not connected",     
/*10058 WSAESHUTDOWN*/      "(10058) Cannot send after socket shutdown",    
/*10060 WSAETIMEDOUT*/      "(10060) Connection timed out",      
/*10061 WSAECONNREFUSED*/   "(10061) Connection refused",       
NULL,
NULL,
NULL,
/*10064 WSAEHOSTDOWN*/      "(10064) Host is down",      
/*10065 WSAEHOSTUNREACH*/   "(10065) No route to host",     
NULL,
/*10067 WSAEPROCLIM*/       "(10067) Too many processes",      
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
/*10091 WSASYSNOTREADY*/    "(10091) Network subsystem is unavailable",     
/*10092 WSAVERNOTSUPPORTED*/"(10092) WINSOCK.DLL version out of range",    
/*10093 WSANOTINITIALISED*/ "(10093) Successful WSAStartup not yet performed",    
/*10094 WSAEDISCON*/        "(10094) Graceful shutdown in progress",     
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
/*10109 WSATYPE_NOT_FOUND*/ "(10109) Class type not found",
};

const char *sock_errstr1[] = { 
/*11001 WSAHOST_NOT_FOUND*/ "(11001) Host not found",      
/*11002 WSATRY_AGAIN*/      "(11002) Non-authoritative host not found",     
/*11003 WSANO_RECOVERY*/    "(11003) This is a non-recoverable error",    
/*11004 WSANO_DATA*/        "(11004) Valid name, no data record of requested type", 
};

const char *socket_strerror(int errcode){
    if(errcode < 10000)
        return NULL;
    if(errcode < 10110)
        return sock_errstr[errcode - 10000];
    if(errcode > 11000 && errcode < 11005)
        return sock_errstr1[errcode - 11001];
    return NULL;
}
