// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/mains/orp/properties.cpp,v 1.4 2001/08/29 07:38:35 xli18 Exp $
//

#include "platform.h"
#include "properties.h"
#ifdef ORP_NT
#include <direct.h>
#endif

#ifdef ORP_POSIX
#include <unistd.h>
#endif


#define PROP_ENV_NAME  "ORP_PROPERTIES"
#define PROP_FILE_NAME "orp.properties"

#define MAX_PROP_LINE 512

/***
void test()
{
	Properties *prop = new Properties();
	prop->add("  123=");
	prop->add("  3=   \t");
	prop->add("=");
	prop->add("\t=123");
	prop->add("\"\"=123");
	prop->add("  123=456\t");
	prop->add(" ' 123'=\"456 ddf\" \t");
	prop->add("1dvdfd=dfdfdf\t");
	prop->add("  1234    =\"456\t\"");
	prop->add("\t23=456ewew");
	prop->add("123ee=456\t");
	prop->print();
}
***/

void read_properties(char *fname, Properties &prop)
{
	FILE *f = fopen(fname, "r");
	if(!f)return;
	char buf[MAX_PROP_LINE];
	while(!feof(f)){
		fgets(buf, MAX_PROP_LINE, f);
		prop.add(buf);
	}
	fclose(f);
}

int get_self_full_path(char *path, int len)
{
#ifdef ORP_POSIX
	char procname[64];
	sprintf(procname, "/proc/%05ld/exe", (long)getpid());
	int n =  readlink(procname, path, len);
	if(n == -1)return -1;
	path[n] = '\0';
#else
#ifdef ORP_NT
	int n = GetModuleFileName(0, path, len);
	if(n == 0)return -1;
#endif
#endif
	return 0;
}

void initialize_properties(Properties& prop)
{
	char buf[_MAX_PATH];
/* 
 * 1. ORP looks for an environment variable, say, 
 *    ORP_PROPERTIES=d:\xyz\eee\orp.Properties, read the Properties;
 */
	char *pf = getenv(PROP_ENV_NAME);
	if(pf)
		read_properties(pf, prop);
/*
 * 2. Looks for orp.Properties in the directory where orp executable resides 
 *    (it's also a global file), read the Properties, if key is duplicated, 
 *    override the value;
 */
	if(get_self_full_path(buf, _MAX_PATH) == 0){
		char *p = strrchr(buf, DIR_SEPARATOR);
		if(p){
			*(p+1) = '\0';
			strcat(buf, PROP_FILE_NAME);
			read_properties(buf, prop);
		}
	}
	
/*
 * 3. Looks for it in current directory(it's a app-specific file), read the 
 *    Properties, if key is duplicated, override the value;
 */
	getcwd(buf, _MAX_PATH);
	sprintf(buf, "%s%c%s", buf, DIR_SEPARATOR, PROP_FILE_NAME);
	read_properties(buf, prop);
/*
 * 4. Check whether there're a comand line option, say, 
 *    -Properties-file "d:\xyz\eee\orp.Properties" or -Properties key=value, 
 *    read the Properties, if key is duplicated, override the value. 
 */
}

void add_to_properties(Properties& prop, const char* line)
{
	prop.add(line);
}

