// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/jar_zip_utils/archive_util.h,v 1.2 2001/09/18 08:26:33 xli18 Exp $
//

#ifndef _ARCHIVE_UTIL_H
#define _ARCHIVE_UTIL_H

#include <stdio.h>

/***************************************************************************/

/*some useful infomation of a file in the zip or jar file.
Infomation of files are contained in both the central directory and the local file header.
We can check the coherency of files through comparing respective fields.
The infomation concerned here includes the followings:
*/
typedef struct
{
	uLong index_file;			/*The index of the current file in the zip or jar file*/

	uLong pos_in_central_dir;	/*The postion of the current file in the central dir*/

	bool is_file_ok;			/*Set if this file is the usabile*/

	uLong flags;				/*Flages of this file*/

	uLong compression_method;	/*0 or Z_DEFLATED(8) is supported*/

	uLong crc;					/*The CRC of this file*/

	uLong length_compressed;	/*The length of the compressed file*/

	uLong length_uncompressed;	/*The length of the original file*/

	uLong length_filename;		/*The length of the file's name*/

	char* file_name;			/*The file name contained in the zip or jar file*/

	uLong offset;				/*The offset of the file in the zip or jar file*/

	uLong length_restdata;		/*The length of the rest:file extra,file comment*/

} file_in_jar_info;


/*When we read from a zip or jar file,we also need some variables to recorde
the information of the procedure.
The virables needed include the followings:
*/
typedef struct
{
	z_stream stream;			/*used by zlib for inflate*/

	int is_stream_initialized;	/*Set if stream structure is initialized*/

	char* read_buffer;			/*A buffer for compressed data*/

	uLong pos_in_jarfile;		/*The position of the current reading pointer 
								in the jar or zip file*/

	uLong length_rest_compressed;	/*The length of the data to be decompressed*/

	uLong length_rest_uncompressed;	/*The length of the date decompressed*/

	uLong compression_method;	/*0 or Z_DEFLATED(8) is supported*/

	uLong crc;					/*CRC computed from the stream*/

} file_in_reading_info;


/*
The following structure contains general infomation of a zip or jar file.
We can get these infomation from the central directory.
And also,it contains infomation of the current red file and 
some environment infomation during reading.
*/
typedef struct
{
	FILE* file_handle;			/*The FILE* type handle of the zip or jar file*/

	char* filename;				/*Name of the zip or jar file*/

	uLong byte_before_file;		/*Bytes before the zip or jar file, (>0 for sfx)*/

	uLong pos_central_dir;		/*The position of the central dir in the zip or jar file*/

	uLong size_central_dir;		/*The size of the central directory*/

	uLong offset_central_dir;   /* offset of start of central directory with
								   respect to the starting disk number */

	uLong number_entry;			/*The total number of entryies in this zip or jar file*/

} general_info;


/***************************************************************************/
/*define some constant:OK,EOF,ERROR etc.*/
/*zero means OK,NO ERROR*/
#define UNJAR_OK	(0)
#define UNJAR_EOF	(0)

/*negative number means errors*/
/*Format of the error is
	+--~~---------------+
	|          4 3 2 1 0|<-----General error
	+--~~---------------+
               ^ ^ ^ ^
               | | | |_________Parameter error
               | | |___________Bad zip file
               | |_____________CRC error
               |_______________End of the list of entries 

*/

#define UNJAR_ERROR			(-1)		/*General error*/
#define UNJAR_PARAMETER		(-2)		/*Parameters when calling are error*/
#define UNJAR_BADJARFILE	(-4)		/*This zip or jar file is bad*/
#define UNJAR_CRC			(-8)		/*Error of Mathing the CRCs*/
#define UNJAR_END_OF_LIST	(-16)
/*positive number means the number of bytes that have been red.*/


/************************************************************************************/
/*Just as the head in zutil.h*/
#ifdef STDC
#  include <stddef.h>
#  include <string.h>
#  include <stdlib.h>
#endif
#ifdef NO_ERRNO_H
    extern int errno;
#else
#   include <errno.h>
#endif

#ifndef local
#  define local static
#endif
/* compile with -Dlocal if your debugger can't find static symbols */
/************************************************************************************/

#define UNJAR_BUF_SIZE (16384)
#define UNJAR_MAX_FILENAME_IN_JAR (256)


#define SIZE_CENTRAL_DIR_ITEM (0x2e)
#define SIZE_JAR_LOCAL_HEADER (0x1e)


/***************************************************************************************/
/*The followsings are basic functions about reading a byte,short or long from a stream.*/
/***************************************************************************************/
/*Read a byte from a stream.
  The stream has been sucessfully opened for reading.
  When meet the end of the stream,return UNJAR_EOF.
*/

local int unjar_get_byte(FILE* fl,int* b)
{
	unsigned char c;
	if(fread(&c,1,1,fl)==1)
	{
		*b=(int)c;
		return UNJAR_OK;
	}
	else
	{
		if(ferror(fl))
			return UNJAR_ERROR;
		else
			return UNJAR_EOF;
	}
}

/************************************************************************************/
/*Reads a short integer(2 bytes) in LSB order from the given stream. 
   15           7           0
  +------------+------------+
  |2nd red byte|1st red byte|
  +------------+------------+

*/

local int unjar_get_short(FILE* fl,uLong* sh)
{
	int b;
	uLong temp;						/*temporary for sh*/
	int err;
	*sh=0;							/*initiate*/
	err=unjar_get_byte(fl,&b);
	if(err!=UNJAR_OK)
		return err;

	temp=(uLong)b;

	err=unjar_get_byte(fl,&b);
	if(err!=UNJAR_OK)
		return err;

	*sh=temp+(((uLong)b)<<8);
	return UNJAR_OK;
}

/************************************************************************************/
/*   Reads a long integer(4 bytes) in LSB order from the given stream.
   15            7            0
  +-------------+-------------+
  |2nd red short|1st red short|
  +-------------+-------------+

*/

local int unjar_get_long(FILE* fl,uLong* ul)
{
	uLong sh;
	uLong temp;
	int err;
	*ul=0;

	err=unjar_get_short(fl,&sh);
	if(err!=UNJAR_OK)
		return err;

	temp=sh;

	err=unjar_get_short(fl,&sh);
	if(err!=UNJAR_OK)
		return err;

	*ul=temp+(sh<<16);

	return UNJAR_OK;
}

#endif	/*_ARCHIVE_UTIL_H*/

