// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/jar_zip_utils/Manifest.h,v 1.6 2001/10/29 01:41:37 xli18 Exp $
//

#ifndef _MANIFEST_H
#define _MANIFEST_H
/////////////////////////////////////////////////////////////////////////////////////////
//Parse the MANIFEST.MF, store the infomation into two hash tables:
//m_MainProperties: main properties for the manifest;
//m_Map: properties for all enties. The element of this hash table is also a hash table, 
//       contains the properties for a specific entry.



#include "properties.h"			/*Hash Table*/

/*The standard's version number*/
#define VERSIONINFO "Manifest-Version: 1.0"

class Manifest
{
/////////////////////////////////////////////////////////////////////////////////////////
//Constructors
public:
	Manifest();
	Manifest(char*);
	Manifest(Properties*,Properties*);

	~Manifest();

/////////////////////////////////////////////////////////////////////////////////////////
//Public interfaces
public:
	/*clear the content of this manifest*/
	void clear();

	Manifest* clone();

	/*start to parse the MANIFEST.MF*/
	bool parse();

	/*get the given entry's properties*/
	Properties* getProperties(const char*);

	/*get all entries*/
	Properties* getEntries();

	/*get the main properties for the manifest*/
	Properties* getMainProperties();

/////////////////////////////////////////////////////////////////////////////////////////
//private varibles
private:
	Properties* m_MainProperties;

	Properties* m_Map;

	char* p_now;
/////////////////////////////////////////////////////////////////////////////////////////
//private funcions about parsing the manifest
private:
	bool match(char);
	bool main_section();
	bool section(Properties*);
	char* get_name();
	bool header(Properties*);
	bool newline();
	char* valid_key();
	char* valid_value();
};

#endif	/*_MANIFEST_H*/

