// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/jar_zip_utils/Manifest.cpp,v 1.4 2001/12/18 05:33:53 gwu2 Exp $
//

#include "Manifest.h"

/////////////////////////////////////////////////////////////////////////////////////////
//Constructors
Manifest::Manifest()
{
	m_MainProperties = NULL;
	m_Map = NULL;
	p_now = NULL;
}

Manifest::Manifest(char* buf)
{
	m_MainProperties = NULL;
	m_Map = NULL;
	p_now = buf;
}

Manifest::Manifest(Properties* main,Properties* map)
{
	m_MainProperties = main;
	m_Map = map;
	p_now = NULL;
}

Manifest::~Manifest()
{
	if(m_MainProperties)
		delete m_MainProperties;
	if(m_Map)
		delete m_Map;
}

/////////////////////////////////////////////////////////////////////////////////////////
void Manifest::clear()
{
	if(m_MainProperties)
	{
		m_MainProperties->clear();
		m_MainProperties = NULL;
	}
	if(m_Map)
	{
		m_Map->clear();
		m_Map = NULL;
	}
}

Manifest* Manifest::clone()
{
	if(NULL == m_MainProperties)
	{
		if(NULL == m_Map)
			return (new Manifest());
		return (new Manifest(NULL,m_Map->clone()));
	}
	if(NULL == m_Map)
		return (new Manifest(m_MainProperties->clone(),NULL));

	return (new Manifest(m_MainProperties->clone(),m_Map->clone()));
}

Properties* Manifest::getMainProperties()
{
	return m_MainProperties;
}

Properties* Manifest::getProperties(const char* entryname)
{
	Prop_Properties* propp = (Prop_Properties*)m_Map->get(entryname);
	if(NULL == propp)
		return NULL;
	return propp->value;
}

Properties* Manifest::getEntries()
{
	return m_Map;
}

/////////////////////////////////////////////////////////////////////////////////////////
bool Manifest::parse()
{
	clear();
	m_MainProperties = new Properties();
	m_Map = new Properties();

	bool b=main_section();				//Parse the main section into m_MainProperties

	while(b && (*p_now!='\0'))			//Not error and EOF
	{
		char* name = get_name();		//Get the entry's name
		if(NULL == name)
			return false;

		Properties* cp = new Properties();
		b = section(cp);				//Parse the section of entry
		if(b)
		{
			Prop_Properties* pp = new Prop_Properties(cp);
			m_Map->add(name,pp);		//Add this entry
			delete[] name;
			delete pp;					//add() have cloned name and pp
		}
		else
			delete cp;
			
	    if(!newline())
			break;

	}

	return b;							//b is true if no error
}


bool Manifest::match(char c)
{
	if(c == *(p_now))					//if *p_now match c,forward the p_now and return true
	{
		p_now++;
		return true;
	}
	return false;
}

bool Manifest::main_section()
{
	char* p = strstr(p_now,"\r\n");		//Get the first line
	if(NULL == p){
        p = strstr(p_now,"\n"); //wgs: for linux style
        if(NULL == p)
		    return false;
    }

    /* version info isn't mandatory at the beginning in jar spec.
	char temp = *p;
	*p = '\0';
	if(strcmp(p_now,VERSIONINFO) != 0)	//The first line is the version info
		return false;
	*p = temp;
    */
    
	while(header(m_MainProperties));	//Parse the headers

    /*
	if(!newline())						//The serparator of sections
		return false;
    */
    
	while(newline());
	return true;
}
  
/*
section: *header +newline
*/  
bool Manifest::section(Properties* cp)
{
	while(header(cp));					//similar with main_section

	if(!newline())
		return false;

	while(newline());
	return true;
}

char* Manifest::get_name()				//get the name of a entry
{
	char* p = strchr(p_now,':');
	if( (NULL == p) || (p_now == p))
		return NULL;

	char temp = *p;
	*p = '\0';
	if(strcmp(p_now,"Name")!=0)
		return NULL;
	*p = temp;

	p_now = p+1;
	if(!match(' '))
		return NULL;

	return valid_value();
}

/*parse the header*/
/*
  header: alphanum *headerchar ":" SPACE *otherchar newline *continuation
  continuation: SPACE *otherchar newline
*/
bool Manifest::header(Properties* cp)
{
	char* key = valid_key();
	if(NULL == key)
		return false;

	if(! match(':'))
		return false;
	if(! match(' '))
		return false;

	char* value = valid_value();
	if(NULL == value)
		return false;

	if(! newline())
		return false;

	while(match(' '))					//The continue line is part of value
	{
		char* cont = valid_value();
		if(cont != NULL)
		{
			char* temp = new char[strlen(value)+strlen(cont)+1];
			strcpy(temp,value);
			strcat(temp,cont);
			delete[] value;
			delete[] cont;
			value = temp;
		}
	}
	Prop_String* ps = new Prop_String(value);
	cp->add(key,ps);
	delete[] key;
	delete ps;

	return true;
}

/*
  newline: CR LF
         | LF
         | CR (not followed by LF)

*/
bool Manifest::newline()
{
	if(*p_now =='\r')					//is a CR
	{
		p_now++;
		if(*p_now == '\n')				//is a CR LF
			p_now++;
		return true;
	}

	if(*p_now == '\n')					//is a LF
	{
		p_now++;
		return true;
	}

	return false;						//if others 
}

/*Get the key and judge if valid*/
char* Manifest::valid_key()
{
	char* p = p_now;
	if(   ((*p_now <= 'z')&&(*p_now >= 'a'))	//'a'-'z'
		||((*p_now <= 'Z')&&(*p_now >= 'A'))	//'A'-'Z'
		||((*p_now <= '9')&&(*p_now >= '0')) )	//'0'-'9'
		p_now++;
	else
		return NULL;

	while(((*p_now <= 'z')&&(*p_now >= 'a'))	//'a'-'z'
		||((*p_now <= 'Z')&&(*p_now >= 'A'))	//'A'-'Z'
		||((*p_now <= '9')&&(*p_now >= '0'))	//'0'-'9'
		||(*p_now == '-')						//'-'
		||(*p_now == '_') )						//'_'
		p_now++;

	char temp = *p_now;
	*p_now = '\0';
	char* key = new char[strlen(p)+1];
	strcpy(key,p);
	*p_now = temp;

	return key;
}

/*Get the value and judge if valid*/
char* Manifest::valid_value()
{
	char* p = p_now;
	while( (*p_now !='\0') && (*p_now != '\r') && (*p_now != '\n') )
		p_now++;					//any Unicode character except NUL, CR and LF
	if(p == p_now)
		return NULL;

	char temp = *p_now;
	*p_now = '\0';
	char* value = new char[strlen(p)+1];
	strcpy(value,p);
	*p_now = temp;

	return value;
}
