// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/jar_zip_utils/JarFile.h,v 1.4 2001/11/10 05:35:01 gwu2 Exp $
//

#ifndef _JARFILE_H
#define _JARFILE_H


/***************************************************************************/
/* Include zlib.h. You can change this to the folder which includes zilib.h*/
#ifndef _ZLIB_H
#include "zlib.h"
#endif


/***************************************************************************/

#include "archive_util.h"
#include "Manifest.h"

class JarFile
{
/***************************************************************************/
public:
	JarFile();
	JarFile(const char*);
	JarFile(general_info,Properties*,Manifest*,bool);

	~JarFile();

/***************************************************************************/
public:
	Manifest* Get_Manifest();

	bool Is_Open_Jar_OK();

	general_info* Get_JarFile_Info(); 

	uLong Get_Entry_Pos_CD(const char*);

	JarFile* clone();

/***************************************************************************/
private:
	bool m_Is_JarFile_Info_OK;
	general_info m_JarFile_Info;		//The general infomation of the file
	Properties* m_Entry_Info;

	bool 	m_Have_Parse_Manifest;
	Manifest* m_Manifest;				//The Manifest of a jar file

/***************************************************************************/
private:
	uLong Search_Central_Dir(FILE*);
	int Get_Info_After_Central_Dir(FILE*);
	int Get_Entry_Info();

/*
Open a zip or jar file.Get the general infomation of the zip or jar file.

jarflname:full file name of the zip or jar file;
*/
	int Open(const char*);
/*
Cloase a zip or jar file opened by unjarOpen.

file:the genral_info of the file wanted to be closed.

return:UNJAR_OK if successful.
*/
	int Close();
/***************************************************************************/
};


class Prop_JarFile: public Prop_Value
{
public:
	Prop_JarFile()
	{
		value=NULL;
	}
	Prop_JarFile(JarFile* v)
	{
		value = v;
	}
	~Prop_JarFile()
	{
		if(value)
			delete value;
	}
	Prop_Value* clone()
	{
		return (new Prop_JarFile(value->clone()));
	}
	void print()
	{
		printf("This is a Jar file");
	}
public:
	JarFile* value;
};

#endif /*_JARFILE_H*/
