// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/jit_utils/jit_common.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#include "platform.h"
#include <assert.h>
#include "jit_intf.h"
#include "Mem_Manager.h"

unsigned num_words_of_type(Java_Type type) {

	switch (type) {
  	case JAVA_TYPE_BYTE: // signed
	case JAVA_TYPE_CHAR: // character
	case JAVA_TYPE_INT: // integer
	case JAVA_TYPE_SHORT: // 16-bit signed short
	case JAVA_TYPE_BOOLEAN: // boolean
	case JAVA_TYPE_FLOAT: // single FP
	case JAVA_TYPE_CLASS: // object
	case JAVA_TYPE_ARRAY: // array
	case JAVA_TYPE_STRING:	// ref
		return 1; // 32-bit return type
	case JAVA_TYPE_DOUBLE: // double FP
	case JAVA_TYPE_LONG: // long
		return 2; // 64-bit return type
	case JAVA_TYPE_VOID:
		return 0;
	default:
		assert(0);
		break;
	}
	return 0;
}

// Given an argument list handle, return the type of the argument.
// This function also does an implicit get next arg handle on the
// Arg_List_Iterator. At the end of the list, it returns JAVA_TYPE_UNDEF.
Java_Type getArgumentType(Arg_List_Iterator  &argList) {
    Java_Type curr = curr_arg(argList);
    argList = advance_arg_iterator(argList);
    return curr;
}

unsigned n_words_of_method_arg_type(Method_Handle handle) {
	Arg_List_Iterator args = method_get_argument_list(handle);
	Java_Type type;
	unsigned size = 0;
	while ((type = getArgumentType(args)) != JAVA_TYPE_END) {
		size += num_words_of_type(type);
	}
	return size;
}

// Compute the length of a bytecode instruction.  Note: some
// instructions are variable-length; in particular, the length of the
// switch instructions depends on their actual index into the bytecode
// array, due to the padding.

#define OFFSET2(array,idx) ((((char*)array)[idx] << 8) | (array)[(idx)+1])
#define OFFSET4(array,idx) (((array)[idx] << 24) | ((array)[(idx)+1] << 16) | ((array)[(idx)+2] << 8) | (array)[(idx)+3])

static unsigned lengths[256] =
{
//0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 00-0f
  2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,  // 10-1f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 20-2f
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,  // 30-3f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 40-4f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 50-5f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 60-6f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 70-7f
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 80-8f
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3,  // 90-9f
  3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1,  // a0-af
  1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 0, 3, 2, 3, 1, 1,  // b0-bf
  3, 3, 1, 1, 0, 4, 3, 3, 5, 5, 0, 0, 0, 0, 0, 0,  // c0-cf
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // d0-df
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // e0-ef
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // f0-ff
};

// Returns the length, in bytes, of the instruction at bc[idx].  bc
// must point to the first bytecode of the method.
unsigned instruction_length(const unsigned char *bc, const unsigned idx)
{
  unsigned result = lengths[bc[idx]];

  if (result == 0)
    {
      switch (bc[idx])
        {
        case 0xaa: // tableswitch, p.335
          {
            unsigned new_idx = ((idx + 4) & (~3)); // first non-padding byte
            int low = OFFSET4(bc,new_idx+4);
            int high = OFFSET4(bc,new_idx+8);
            int n_entries = high - low + 1;
            new_idx += (4 * n_entries + 12);
            result = new_idx - idx;
          }
        break;
        case 0xab: // lookupswitch, p.300
          {
            unsigned new_idx = ((idx + 4) & (~3));
            int npairs = OFFSET4(bc,new_idx+4);
            new_idx += (8 * npairs + 8);
            result = new_idx - idx;
          }
        break;
        case 0xc4: // wide, p.337
          switch (bc[idx+1])
            {
            case 0x84: // iinc, p.251
              result = 6;
              break;
            case 0x15: // iload, p.252
            case 0x16: // lload, p.296
            case 0x17: // fload, p.215
            case 0x18: // dload, p.187
            case 0x19: // aload, p.160
            case 0x36: // istore, p.275
            case 0x37: // lstore, p.307
            case 0x38: // fstore, p.223
            case 0x39: // dstore, p.195
            case 0x3a: // astore, p.165
            case 0xa9: // ret, p.329
              result = 4;
              break;
            default:
              // illegal wide instruction
              result = 4;
              break;
            }
          break;
        default:
          // illegal instruction
          result = 1;
          break;
        }
    }

  return result;
}

