// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Package.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef _PACKAGE_H_
#define _PACKAGE_H_

#include "String_Pool.h"
typedef struct Class Class;

class Package {
public:
	Package(const String *n,Package *s) : 
	  _name(n), _superpackage(s) {
		// add to superpackage's child list
		  if (_superpackage != NULL) {
			_next_subpackage = _superpackage->_subpackages;
			_superpackage->_subpackages = this;
		  } else {
			  _next_subpackage = NULL;
		  }
		_classes = NULL; _subpackages = NULL; table_next = NULL;
	}
	const String  *get_name()	{return _name;}
	Package	*get_superpackage()	{return _superpackage;}
	Package *lookup_subpackage(String *name);
	Class *lookup_class(String *name);
	void	add_class(Class *clss);
	Package *table_next;		// next package in package table
private:
	const String *_name;		// fully qualified name of this package
	Class *_classes;			// classes in this package
	Package	*_superpackage;		// package to which this package belongs
	Package *_subpackages;		// list of subpackages in this package
	Package *_next_subpackage;	// next subpackage in this package's super package
};

///////////////////////////////////////////////////////////////////////////////
// Table of packages' loaded by the class loader.
///////////////////////////////////////////////////////////////////////////////
class Package_Table {
public:
	Package_Table();
	Package *lookup(const String *name);
	void insert(Package *p);
private:
#define PACKAGE_TABLE_SIZE 1024
	Package *_table[PACKAGE_TABLE_SIZE];
};

#endif // _PACKAGE_H_
