// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Mem_Manager.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef _MEM_MANAGER_H_
#define _MEM_MANAGER_H_

#include "Arena.h"

class ORPExport Mem_Manager {
public:
	Mem_Manager(unsigned initial_estimate);
	~Mem_Manager();
	void *alloc(unsigned size);
    unsigned bytes_allocated() { return _bytes_allocated; }
private:
	//
	// allocate a new arena of size
	//
	void _alloc_arena(unsigned size);
	//
	// free all the allocated arenas starting from arena a
	//
	void _free_arenas(Arena *a);
	//
	// arena where memory is allocate from
	//
	Arena	*_arena;
    unsigned _bytes_allocated;
    void *_initial_memory;
};

#endif	// _MEM_MANAGER_H_
