// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/generation.h,v 1.7 2002/01/09 14:50:13 weldon Exp $
//


#ifndef _generation_H_
#define _generation_H_


//
// The MRL GC may have a variable number of generations, from zero
// up to a maximum limit. In the current implementation (Mrl_Gc_V1)
// there are three types of generations, related by inheritance as
// follows.
//
//                Generation
//                    |
//                    |
//       ---------------------------
//       |                         |
//       |                         |
//    Step_Generation              |
//       |                         |
//       |                  Train_Generation
//       |
//  Step_Plus_Nursery_Generation
//


#include "platform.h"
#include "gc_space.h"
#include "block_store.h"
#include "remembered_set.h"
#include "scan_set.h"
#include "gc_component.h"
#include "gc_globals.h"

#define MAXIMUM_STEPS 64

class Card_Table;
class Nursery;
class Gc_Interface;
class Step;
class Gc_Fast_Hooks;
class Gc_Plan;
class Generation : public Gc_Component {

    

	//
	// Some generations have the ability to supply nurseries.
	//
block_info *p_cycle_nursery(block_info *p_nursery, bool returnNullOnFail);

public:
	Generation(unsigned long generation_number,
               Gc_Fast_Hooks *p_gc_hooks,
               Gc_Plan       *p_gc_plan,
		       Gc_Interface  *p_container,
			   Generation    *p_superior,
               Card_Table    *p_card_table,
		       Block_Store   *p_block_store);
	
	virtual ~Generation() {
		delete _p_young_to_old_rs;
	}
    //
    // Add an entry to the remembered set recording mature to young
    // references.
    //
    void add_young_to_old_ref(Java_java_lang_Object **pp_ref) {
        assert (*pp_ref != NULL);
        _p_young_to_old_rs->add_entry(pp_ref);
    }

  
	//
	// The GC interface gives each generation an opportunity to
	// clean up after a collection of that generation.
	//
	virtual void cleanup() {
		cout << "Error - this generation does not need cleanup." << endl;
		orp_exit(1);
	}

	// 
	// A contained space encountered a request for allocation
	// of a large object. 
	//
	virtual Java_java_lang_Object *gc_pinned_malloc(unsigned size, VTable *p_vt,
		                           bool return_null_on_fail,
                                   bool double_align
                                   ) {
		cerr << "Error - this generation doesn't support pinning" << endl;
		assert(0);
		orp_exit(1);
		return NULL;
	}

	virtual Car *p_nominate_focus_car() {
		cout << "Error: illegal for this generation." << endl;
		return NULL;
	}

	virtual Train *p_nominate_focus_train() {
		cout << "Error: illegal for this generation." << endl;
		return NULL;
	}
    //
    // Get the id of this generation
    //
    unsigned long get_gen_num() {
        return _generation_number;
    }

    //
    // When shutting down the ORP, all generations need to
    // be prepared to run all finalizers.
    //
    virtual void run_all_finalizers() = 0;

    //
    // Confirm that I'm indeed a generation.
    //
    virtual bool is_generation() {
        return true;
    }



	//
	// Routines for introspection.
	//

    //
    //
    // make sure this write barrier is consistent.
    //
    virtual void 
        verify_old_to_young_write_barrier () {
    }
    //
	// An entry was found to be stale. Purge it. Needs to be specialized by
    // generations which need it.
	//
	virtual void
		purge_write_barrier_remembered_set(Java_java_lang_Object **pp_obj_ref) {
		cout << "Error: purge illegal for this generation" << endl;
		orp_exit(1);
	}

#ifndef GC_REWORK
	virtual void enqueue_soft_ref (java_lang_ref_Reference *soft_reference) = 0;
	virtual void enqueue_weak_ref (java_lang_ref_Reference *weak_reference) = 0;
	virtual void enqueue_phantom_ref (java_lang_ref_Reference *phantom_reference) = 0;
#endif
protected:

    Card_Table *_p_card_table;
	//
	// My container is an object which implements a GC Interface.
	// (A Garbage Collector for some ORP.)
	//
    Gc_Interface *_p_container;
	//
	// My unique generation number.
	//
    unsigned long _generation_number;

    //
    // The plan object which specifies the gc parameters.
    //
    Gc_Plan *_p_gc_plan;

	//
	// Location to record GC space that is being cheney scanned,
	// so that duplicate cheney scan requests don't get registered,
	// and recursive cheney scans don't get attempted.
	//
	Gc_Space *_p_space_being_scanned;
	//
	// Pointer to the upper generation I target object tenuring at.
	//
    Generation *_p_superior_generation;
	//
	// Repository for the pointers into older spaces.
	//
	Remembered_Set *_p_young_to_old_rs;

private:

    Generation();
};

#endif // _generation_H_

