// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/cheney_fetcher.h,v 1.7 2001/12/18 15:44:58 rlhudson Exp $
//

#ifndef _CHENEY_FETCHER_H_
#define _CHENEY_FETCHER_H_

//
// This file contains the interface to a few routines used to speed up the cheney scan on system that 
// have thread level parallelism hardware that share a common cache. This basic idea is one thread 
// the mover thread acts just like the traditional cheney scan thread, moving objects from 
// "from" space into "to" space and updating pointers to object already in "to" space. 
// The second thread, the fetcher thread implemented using this interface runs ahead fetching the
// interesting information into the L2 cache.
// Hopefully this will mean that cache misses are avoided.
//


#include <stdio.h>
#include <stdlib.h>
#include "gc_header.h"


// Call this to set up event and thread.
void init_fetcher_thread();

void start_fetcher_thread(block_info *block_to_fetch);

// Call to kill the fetcher_thread.
void stop_fetcher_thread();

// These are called at the start and at the end of each cheney scan. They
// can be used for collecting interesting information.

void start_cheney_clock();
void stop_cheney_clock();

#endif