// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/card_table.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//

#ifndef _CARD_TABLE_H_
#define _CARD_TABLE_H_

//
// A card is a 2-power-k-aligned region of memory of size 2-power-k
// for some compile time selected "k" (typically 128 bytes to 10K).
// It is necessary for a card to be smaller than a train car.
// 
// The JIT generates code to mark cards, and a concurrent thread
// converts the marked cards into remembered sets.
//

#include "platform.h"
#include <fstream.h>
#include <iostream.h>
#include "gc_globals.h"
#include "gc_header.h"
#include "gc_consts.h"

#ifdef __cplusplus 
extern "C" {
#endif

#ifdef __cplusplus 
}
#endif 
 
class Block_Store;
class Gc_Fast_Hooks;
class Gc_Plan;
class Generation;
class Remembered_Set;

#ifdef GC_PT_WB
UINT WINAPI dll_GetWriteWatch (IN DWORD dwFlags,          // write-tracking state
							  IN PVOID lpBaseAddress,    // base address of region
							  IN SIZE_T dwRegionSize,    // size of region
							  IN OUT PVOID  *lpAddresses,    // array of page addresses
							  IN OUT PULONG lpdwCount,   //  IN OUT PULONG_PTR lpdwCount,   // number of addresses returned
							  OUT PULONG lpdwGranularity  // page size
							  );
UINT WINAPI dll_ResetWriteWatch (PVOID lpBaseAddress,
                          SIZE_T dwRegionSize
                          );
#endif // GC_PT_WB
#endif // _CARD_TABLE_H


