// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/class_loader/Class_Loader.cpp,v 1.2 2001/08/03 03:13:40 xli18 Exp $
//


#ifdef ORP_POSIX
#include "Loader_Result.h"
#endif

#include "platform.h"
#include "nogc.h"
#include "jit_runtime_support.h"

#include "Class_Loader.h"



unsigned Class_Loader::_capacity = 0;
unsigned Class_Loader::_next_entry = 0;
Class_Loader **Class_Loader::_table = 0;


Class_Loader::Class_Loader(Java_java_lang_Object *loader)
{
    _loader = loader;
    class_table = new Class_Table();
} //Class_Loader::Class_Loader



Class_Loader *Class_Loader::lookup(Java_java_lang_Object *loader)
{
    Class_Loader *cl = find_if_exists(loader);
    if(cl) {
        return cl;
    } else {
        return add_class_loader(loader);
    }
} //Class_Loader::lookup



Class_Loader *Class_Loader::find_if_exists(Java_java_lang_Object *loader)
{
    for(unsigned i = 0; i < _next_entry; i++) {
        Class_Loader *cl = _table[i];
        if(loader == cl->_loader) {
            return cl;
        }
    }
    return 0;
} //Class_Loader::find_if_exists



Class_Loader *Class_Loader::add_class_loader(Java_java_lang_Object *loader)
{
    Class_Loader *cl = new Class_Loader(loader);
    if(_capacity <= _next_entry) {
        reallocate(_capacity ? (2 * _capacity) : 32);
    }
    _table[_next_entry++] = cl;
    return cl;
} //Class_Loader::add_class_loader



#if 0
void Class_Loader::init()
{
    _capacity   = 0;
    _next_entry = 0;
    _table      = 0;
    reallocate(32);
} //Class_Loader::init
#endif



void Class_Loader::reallocate(unsigned new_capacity)
{
    Class_Loader **new_table =
        (Class_Loader **)gc_malloc_fixed_data_C(new_capacity * sizeof(Class_Loader *));
    memcpy(new_table, _table, _next_entry * sizeof(Class_Loader *));
    assert(new_table);
    assert(_next_entry <= _capacity);
    assert(_next_entry < new_capacity);
    if(_table) {
        gc_free_fixed_data_C(_table);
    }
    _table = new_table;
    _capacity = new_capacity;
} //Class_Loader::reallocate



void Class_Loader::gc_enumerate()
{
    for(unsigned i = 0; i < _next_entry; i++) {
        orp_enumerate_root_reference(0, (void **)&(_table[i]->_loader));
    }
} //Class_Loader::gc_enumerate



void Class_Loader::insert_class(Class *clss)
{
    class_table->insert(clss);
} //Class_Loader::insert_class



Class *Class_Loader::lookup_class(String *name)
{
    return class_table->lookup(name);
} //Class_Loader::lookup_class



