// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/orp_stats.cpp,v 1.3 2001/11/07 01:14:21 michal Exp $
//


#ifdef ORP_STATS


#include "platform.h"
#include "environment.h"
#include "orp_utils.h"
#include "method_lookup.h"

#include "orp_stats.h"


ORP_Statistics orp_stats_total;

bool orp_print_total_stats = false;
int orp_print_total_stats_level = 0;



ORP_Statistics::ORP_Statistics()
{
    num_exceptions                          = 0;
    num_exceptions_caught_same_frame        = 0;
    num_exceptions_dead_object              = 0;
    num_exceptions_object_not_created       = 0;
    num_native_methods                      = 0;
    num_java_methods                        = 0;
    num_fill_in_stack_trace                 = 0;
    num_unwind_java_frames_gc               = 0;
    num_unwind_native_frames_gc             = 0;
    num_unwind_java_frames_non_gc           = 0;
    num_unwind_native_frames_all            = 0;
    max_stack_trace                         = 0;

    num_instanceof                          = 0;
    num_instanceof_non_null                 = 0;
    num_instanceof_equal                    = 0;
    num_instanceof_class                    = 0;
    num_instanceof_class_recursive          = 0;
    num_instanceof_s_is_array               = 0;
    num_instanceof_t_is_intf                = 0;
    num_instanceof_t_is_intf_success        = 0;
    num_instanceof_class_reversed           = 0;
    num_instanceof_class_reversed_recursive = 0;

    num_optimistic_depth_success            = 0;
    num_optimistic_depth_failure            = 0;
    num_method_lookup_cache_hit             = 0;
    num_method_lookup_cache_miss            = 0;

    num_aastores                            = 0;
    num_instanceof_in_aastore               = 0;
    num_aastore_exceptions                  = 0;
    num_aastore_instanceof                  = 0;
    
    num_invokeinterface_calls               = 0;
    num_invokeinterface_calls_size_1        = 0;
    num_invokeinterface_calls_searched_1    = 0;
    num_invokeinterface_calls_size_2        = 0;
    num_invokeinterface_calls_searched_2    = 0;
    num_invokeinterface_calls_size_many     = 0;
    num_invokeinterface_calls_searched_many = 0;
    invokeinterface_calls_size_max          = 0;
    invokeinterface_calls_searched_max      = 0;
    num_instantiate_cp_string_fast          = 0;
    num_instantiate_cp_string_fast_returned_interned        = 0;
    num_instantiate_cp_string_fast_success_long_path        = 0;
    num_instantiate_cp_string_slow          = 0;
    num_class_alloc_new_object_or_null      = 0;
    num_class_alloc_new_object              = 0;
    num_class_alloc_new_object_with_finalizer_or_null       = 0;
    num_class_alloc_new_object_with_finalizer               = 0;
    num_newarray                            = 0;
    num_multianewarray                      = 0;
    num_newarray_char                       = 0;
    num_newarray_float                      = 0;
    num_newarray_double                     = 0;
    num_newarray_boolean                    = 0;
    num_newarray_byte                       = 0;
    num_newarray_short                      = 0;
    num_newarray_int                        = 0;
    num_newarray_long                       = 0;
    num_array_index_throw                   = 0;
    num_is_class_initialized                = 0;
    num_get_addr_of_orp_last_java_frame     = 0;

    num_f2i                                 = 0;
    num_f2l                                 = 0;
    num_d2i                                 = 0;
    num_d2l                                 = 0;

#ifdef _DEBUG
    num_lazy_monitor_enter                  = 0;
    num_lazy_monitor_exit                   = 0;
#endif

    num_monitor_enter_fastcall              = 0;
    num_monitor_exit_fastcall               = 0;
    num_monitor_enter                       = 0;
    num_monitor_exit                        = 0;
    num_monitor_enters_with_zero_headers    = 0;  
    num_monitor_enters_with_nonzero_headers = 0;


    num_monitor_enter_wait           = 0;
    num_sleep_monitor_enter          = 0;
    num_sleep_monitor_exit           = 0;
    num_sleep_notify_all             = 0;
    num_sleep_notify                 = 0;
    num_sleep_interrupt_the_wait     = 0;
    num_sleep_wait                   = 0;
    num_wait_WaitForSingleObject     = 0;
    num_sleep_hashcode               = 0;
    num_sleep_monitor_ownership      = 0; 
    num_sleep_java_thread_yield      = 0;
} //ORP_Statistics::ORP_Statistics



static void print_classes()
{
    bool first_time = true;
    Class **ptrC = ORP_Global_State::loader_env->class_table.get_first_class();
    while(ptrC) {
        Class *c = *ptrC;
        if(c->num_throws) {
            if(first_time) {
                first_time = false;
                printf("Following exceptions were thrown:\n");
            }
            printf(" %40s  %11llu\n", c->name->bytes, c->num_throws);
        }
        ptrC = ORP_Global_State::loader_env->class_table.get_next_class(c);
    }
    if(first_time) {
        printf("\n");
    }

    first_time = true;
    ptrC = ORP_Global_State::loader_env->class_table.get_first_class();
    while(ptrC) {
        Class *c = *ptrC;
        if(c->num_class_init_checks) {
            if(first_time) {
                first_time = false;
                printf("Following classes were checked for init state:\n");
            }
            printf(" %60s  %11llu\n", c->name->bytes, c->num_class_init_checks);
        }
        ptrC = ORP_Global_State::loader_env->class_table.get_next_class(c);
    }
    if(first_time) {
        printf("\n");
    }

    first_time = true;
    ptrC = ORP_Global_State::loader_env->class_table.get_first_class();
    while(ptrC) {
        Class *c = *ptrC;
        if(c->num_instanceof_slow) {
            if(first_time) {
                first_time = false;
                printf("Following classes were used in the instanceof test:\n");
            }
            printf(" %50s [depth=%2d] %11llu\n", c->name->bytes, c->depth, c->num_instanceof_slow);
        }
        ptrC = ORP_Global_State::loader_env->class_table.get_next_class(c);
    }
    if(first_time) {
        printf("\n");
    }
} //print_classes



static void print_methods()
{
    printf("--------- begin method execution counts:\n");
    Class **ptrC = ORP_Global_State::loader_env->class_table.get_first_class();
    while(ptrC) {
        Class *c = *ptrC;
        int n_methods = c->n_methods;
        for(int i = 0; i < n_methods; i++) {
            Method *m = &(c->methods[i]);
            if(m->num_accesses) {
                const char *cname = c->name->bytes;
                const char *mname = m->get_name()->bytes;
                const char *descr = m->get_descriptor();
                printf("%11llu  %s%s.%s%s\n",
                       m->num_accesses,
                       (m->is_native() ? "native " : ""),
                       cname,
                       mname,
                       descr);
            }
        }
        ptrC = ORP_Global_State::loader_env->class_table.get_next_class(c);
    }
    printf("--------- end method execution counts:\n\n");
} //print_methods



void ORP_Statistics::print()
{
    if(!orp_print_total_stats)
        return;

    printf("\n==== begin ORP statistics\n");

    print_classes();

    if(orp_print_total_stats_level > 2) {
        print_methods();
    }

    methods.print_stats();

    printf("Number native methods:          %11llu\n", num_native_methods);
    printf("Number Java methods:            %11llu\n", num_java_methods);

    printf("Total exceptions thrown:        %11llu\n", num_exceptions);
    printf("  exc obj was dead:             %11llu\n", num_exceptions_dead_object);
    printf("  exc obj wasn't created:       %11llu\n", num_exceptions_object_not_created);
    printf("  caught in the same frame:     %11llu\n", num_exceptions_caught_same_frame);
    printf("  calls to array_index_throw:   %11llu\n", num_array_index_throw);

    printf("Number fillInStackTrace:        %11llu\n", num_fill_in_stack_trace);
    printf("Max stack trace depth:          %11llu\n", max_stack_trace);
    printf("Unwinds (GC)  java frames:      %11llu\n", num_unwind_java_frames_gc);
    printf("            native frames:      %11llu\n", num_unwind_native_frames_gc);
    printf("                    total:      %11llu\n", num_unwind_java_frames_gc + num_unwind_native_frames_gc);
    printf("Unwinds (non-GC)  java frames:  %11llu\n", num_unwind_java_frames_non_gc);
    printf("                native frames:  %11llu\n", (num_unwind_native_frames_all - num_unwind_native_frames_gc));
    printf("                        total:  %11llu\n", num_unwind_java_frames_non_gc + (num_unwind_native_frames_all - num_unwind_native_frames_gc));

    printf(" Optimistic depth success:      %11llu\n", num_optimistic_depth_success);
    printf("                  failure:      %11llu\n", num_optimistic_depth_failure);
    printf("Method lookup cache hit:        %11llu\n", num_method_lookup_cache_hit);
    printf("                   miss:        %11llu\n", num_method_lookup_cache_miss);

    printf("Instanceof calls:               %11llu\n", num_instanceof);
    printf("        non-null:               %11llu\n", num_instanceof_non_null);
    printf("           equal:               %11llu\n", num_instanceof_equal);
    printf("         (class):               %11llu\n", num_instanceof_class);
    printf("     (recursive):               %11llu\n", num_instanceof_class_recursive);
    printf("      S is array:               %11llu\n", num_instanceof_s_is_array);
    printf("  T is interface:               %11llu\n", num_instanceof_t_is_intf);
    printf("    intf success:               %11llu\n", num_instanceof_t_is_intf_success);
    printf("       (R class):               %11llu\n", num_instanceof_class_reversed);
    printf("   (R recursive):               %11llu\n", num_instanceof_class_reversed_recursive);

    printf("Numbers of calls to aastore:    %11llu\n", num_aastores);
    printf("      instanceof in aastore:    %11llu\n", num_instanceof_in_aastore);
    printf("      exceptions in aastore:    %11llu\n", num_aastore_exceptions);
    printf("# calls to aastore-instanceof:  %11llu\n", num_aastore_instanceof);

    printf("Numbers of invokeinterface:     %11llu\n", num_invokeinterface_calls);
    printf("                  max size:     %11llu\n", invokeinterface_calls_size_max);
    printf("                max search:     %11llu\n", invokeinterface_calls_searched_max);
    printf("                num size 1:     %11llu\n", num_invokeinterface_calls_size_1);
    printf("              num search 1:     %11llu\n", num_invokeinterface_calls_searched_1);
    printf("                num size 2:     %11llu\n", num_invokeinterface_calls_size_2);
    printf("              num search 2:     %11llu\n", num_invokeinterface_calls_searched_2);
    printf("                num size +:     %11llu\n", num_invokeinterface_calls_size_many);
    printf("              num search +:     %11llu\n", num_invokeinterface_calls_searched_many);

    printf("# instantiate_cp_string_fast:   %11llu\n", num_instantiate_cp_string_fast);
    printf("           returned interned:   %11llu\n", num_instantiate_cp_string_fast_returned_interned);
    printf("           success long path:   %11llu\n", num_instantiate_cp_string_fast_success_long_path);
    printf("# instantiate_cp_string_slow:   %11llu\n", num_instantiate_cp_string_slow);

    printf("# clss_alloc_new_object_or_nul: %11llu\n", num_class_alloc_new_object_or_null);
    printf("        class_alloc_new_object: %11llu\n", num_class_alloc_new_object);
    printf("        with_finalizer_or_null: %11llu\n", num_class_alloc_new_object_with_finalizer_or_null);
    printf("                with_finalizer: %11llu\n", num_class_alloc_new_object_with_finalizer);

    printf("Number of calls to anewarray:   %11llu\n", num_anewarray);
    printf("Number calls to multianewarray: %11llu\n", num_multianewarray);
    printf("Number of calls to newarray:    %11llu\n", num_newarray);
    if(num_newarray_boolean)
        printf("                    boolean:    %11llu\n", num_newarray_boolean);
    if(num_newarray_byte)
        printf("                       byte:    %11llu\n", num_newarray_byte);
    if(num_newarray_char)
        printf("                       char:    %11llu\n", num_newarray_char);
    if(num_newarray_short)
        printf("                      short:    %11llu\n", num_newarray_short);
    if(num_newarray_int)
        printf("                        int:    %11llu\n", num_newarray_int);
    if(num_newarray_long)
        printf("                       long:    %11llu\n", num_newarray_long);
    if(num_newarray_float)
        printf("                      float:    %11llu\n", num_newarray_float);
    if(num_newarray_double)
        printf("                     double:    %11llu\n", num_newarray_double);

    printf("# checks if class initialized:  %11llu\n", num_is_class_initialized);

    printf("# get ljf addr:                 %11llu\n", num_get_addr_of_orp_last_java_frame);

    printf("Number of f2i:                  %11llu\n", num_f2i);
    printf("          f2l:                  %11llu\n", num_f2l);
    printf("          d2i:                  %11llu\n", num_d2i);
    printf("          d2l:                  %11llu\n", num_d2l);

#ifdef _DEBUG
    printf("Number of lazy monenter:        %11llu\n", num_lazy_monitor_enter);
    printf("Number of lazy monexit:         %11llu\n", num_lazy_monitor_exit);
#endif
    printf("Number of monenter:             %11llu\n", num_monitor_enter);
    printf("          contested:            %11llu\n", num_monitor_enters_with_zero_headers);
    printf("          uncontested:          %11llu\n", num_monitor_enters_with_nonzero_headers);
    printf("          monexit:              %11llu\n", num_monitor_exit);
    printf("Number of monenter (fastcall):  %11llu\n", num_monitor_enter_fastcall);
    printf("          monexit (fastcall):   %11llu\n", num_monitor_exit_fastcall);
    
    printf("Number of monenter:             %11llu\n", num_monitor_enter);
    printf("Number of monenter waits:       %11llu\n", num_monitor_enter_wait);
    printf("Number of monenter sleeps:      %11llu\n", num_sleep_monitor_enter);
    printf("Number of monexit sleeps:       %11llu\n", num_sleep_monitor_exit);
    printf("Number of NotifyAll sleeps:     %11llu\n", num_sleep_notify_all);
    printf("Number of Sleep sleeps:         %11llu\n", num_sleep_notify);
    printf("Number of interrupt wait sleeps: %11llu\n", num_sleep_interrupt_the_wait);
    printf("Number of wait sleeps:          %11llu\n", num_sleep_wait);
    printf("Number of Java yield sleeps:    %11llu\n", num_sleep_java_thread_yield);
    printf("Number of wait for object:      %11llu\n", num_wait_WaitForSingleObject);
    printf("Number of hashcode sleeps:      %11llu\n", num_sleep_hashcode);
    printf("Number of mon owner sleeps:     %11llu\n", num_sleep_monitor_ownership);

    printf("==== end ORP statistics\n");
} //ORP_Statistics::print




#endif
