// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_Class.cpp,v 1.16 2002/01/04 21:07:50 ssubram5 Exp $
//



#include "platform.h"
#include <assert.h>
#include "environment.h"
#include "Class.h"
#include "exceptions.h"
#include "ini.h"


#include "jni_direct.h"
#include "orp_utils.h"
#include "gnu_specific.h"

#include "root_set_enum.h"
#include "stack_manipulation.h"
#include "method_lookup.h"
#include "jni_utils.h"
#include "native_utils.h"

#include "java_lang_Object.h"
#include "java_lang_Class.h"

#include "gnu_classpath_jni_utils.h"

#include "Class_Loader.h"

/*
 * Class:     java_lang_Class
 * Method:    isArray
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_java_lang_Class_isArray
  (JNIEnv *env, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	jboolean isArray = clss->is_array;
    return isArray;
} // Java_java_lang_Class_isArray




/*
 * Class:     java_lang_Class
 * Method:    getComponentType
 * Signature: ()Ljava/lang/Class;
 */
//This function is obsolete, Classpath implement it with java code
/*
JNIEXPORT jclass JNICALL Java_java_lang_Class_getComponentType
  (JNIEnv *jenv, jobject clazz)
{
	jclass compclazz = GetClassComponentType(jenv, clazz);
	assert(compclazz);
    return compclazz;
} // Java_java_lang_Class_getComponentType
*/


/*
 * Class:     java_lang_Class
 * Method:    isAssignableFrom
 * Signature: (Ljava/lang/Class;)Z
 */

JNIEXPORT jboolean JNICALL Java_java_lang_Class_isAssignableFrom
  (JNIEnv *jenv, jobject clazz, jclass clss)
{
	return jenv->IsAssignableFrom(clss, clazz);
} // Java_java_lang_Class_isAssignableFrom




/*
 * Class:     java_lang_Class
 * Method:    isPrimitive
 * Signature: ()Z
 */

JNIEXPORT jboolean JNICALL Java_java_lang_Class_isPrimitive
  (JNIEnv *env, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *cls = (Class *)clazz_h->java_reference;

	jboolean is_prim;
	if (cls->is_primitive) {
		is_prim = 1;
	} else {
		is_prim = 0;
	}
    return is_prim;
} // Java_java_lang_Class_isPrimitive



/*
 * Class:     java_lang_Class
 * Method:    forName
 * Signature: (Ljava/lang/String;)Ljava/lang/Class;
 */


Java_java_lang_Class *java_lang_Class_forName(Java_java_lang_Class *pClass, Java_java_lang_String *pString)
{
    if (!pString) {
        throw_java_exception("java/lang/IllegalArgumentException");
	}

    int32 count;
    int32 offset;
    JavaArrayOfChar *char_array;
    get_java_lang_string_fields(pString, &char_array, &offset, &count);
    // For class like '[B', the real class name is 'boolean', 
    // so we must malloc more space 
    char *buff = (char *)malloc(count + 20); 
    for(int i = 0; i < count; i++) {
        buff[i] = (unsigned char)char_array->body[offset + i];
        if(buff[i] == '.') {
            buff[i] = '/';
        }
    }
    buff[count] = '\0';

    if (strcmp(buff, "java/util/Date") == 0) { 
        // Optimization if java/util/Date is asked for a lot!
        free(buff);
        return (Java_java_lang_Class *) ORP_Global_State::loader_env->java_util_Date_Class;
    }

   	String * str = ORP_Global_State::loader_env->string_pool.lookup(buff);

    void *ip = get_last_j2n_saved_ip();
    JIT_Specific_Info *jit_info = methods.find(ip);
    assert(jit_info);
    Class *caller = jit_info->get_method()->get_class();

    Loader_Exception exc;
    Class *c = load_class_by_loader(ORP_Global_State::loader_env,
                                    str,
                                    caller->class_loader,
                                    &exc);

	//We gonna modify buff, but free on a modified pointer of buff will cause problems, 
	// so save it to bufp first 
	char *bufp = buff; 
	/* The patch is for Class.getComponentType()
	 *   A scenario:
	 *		Class: [Ljava.lang.String;
	 *		in Class.getComponentType():
	 *			if(isArray()) {
	 *				return Class.forName(getName().substring(1));
	 *		So the 'pString' argument here is 'Ljava.lang.String;';
	 *		So we must unquote it.
	 *   B scenario:
	 *		Class: [B
	 *		we must translate B to byte.
	 */
	BOOL modified = FALSE;
	if(!c){ //hasn't found the class, so we should check the class name
		// Original check is logically wrong
		/*
		if(buff[0] == 'L'){
			buff++;
			modified = TRUE;
		}
		if(buff[strlen(buff) - 1] == ';'){
			buff[strlen(buff) - 1] = '\0';
			modified = TRUE;
		}
		*/
		if(buff[0] == 'L' && buff[strlen(buff) - 1] == ';'){
			buff[strlen(buff) - 1] = '\0';
			buff++;
			modified = TRUE;
		}
		if(strlen(buff) == 1){
			switch(*buff){
			case 'Z': strcpy(buff, "boolean"); break;
			case 'B': strcpy(buff, "byte"); break;
			case 'C': strcpy(buff, "char"); break;
			case 'D': strcpy(buff, "double"); break;
			case 'F': strcpy(buff, "float"); break;
			case 'I': strcpy(buff, "int"); break;
			case 'J': strcpy(buff, "long"); break;
			case 'S': strcpy(buff, "short"); break;
			}
			modified = TRUE;
		}
	}
	
	if(modified){
		str = ORP_Global_State::loader_env->string_pool.lookup(buff);
		c = load_class_by_loader(ORP_Global_State::loader_env,
										str,
										caller->class_loader,
										&exc);
	}

	free(bufp);

    if(!c) {
        throw_java_exception("java/lang/ClassNotFoundException");
    }

	// Why should we suppose this?
	/*
	// We are not supposed to find primitive classes:
	if (c->is_primitive) {
        throw_java_exception("java/lang/ClassNotFoundException");
	}
	*/

    if(c->state != ST_Initialized) {
        class_prepare(c);
        class_initialize(c);
    }

    return (Java_java_lang_Class *)c;
} // java_lang_Class_forName




#if 0 

/*
 * Class:     java_lang_Class
 * Method:    forName
 * Signature: (Ljava/lang/String;)Ljava/lang/Class;
 */

JNIEXPORT jclass JNICALL Java_java_lang_Class_forName
  (JNIEnv *jenv, jclass p_this, jstring class_name)
{
    assert(class_name);
    assert(!IsNullRef(class_name));

    orp_disable_gc();       //---------------------------------v

    Java_java_lang_Object *str = ((Object_Handle)class_name)->java_reference;
    JavaArrayOfChar *value = ((Classpath_Java_java_lang_String *)str)->value;
    int count = ((Classpath_Java_java_lang_String *)str)->count;
    uint16 *ptr = value->body;
   
    char *name = (char *) malloc(count * sizeof(char) + 2);
    assert(name);

    name[count] = 0;
    for (int ii = 0; ii < count; ii++) {
        char c = ((char*)ptr)[ii + ii]; // 16 bit characters!
        name[ii] = (c == '.') ? '/' : c; 
    }
    
    orp_enable_gc();        //---------------------------------^   

    jclass new_class = jenv->FindClass(name);

	if(!new_class || jenv->ExceptionOccurred()) {
        set_current_thread_exception(0);
		throw_exception_from_jni(jenv, "java/lang/ClassNotFoundException", name);
        return 0;   
    }

	free(name);
    return new_class;
} //Java_java_lang_Class_forName


#endif



/*
 * Class:     java_lang_Class
 * Method:    newInstance
 * Signature: ()Ljava/lang/Object;
 */

Java_java_lang_Object *java_lang_Class_newInstance(Java_java_lang_Class *p_target_class)
{
    Class *clss = (Class *)p_target_class;
    Global_Env *env = ORP_Global_State::loader_env;
    Method *constructor = class_lookup_method(clss, env->Default_Constructor_Signature);
    if(!constructor){
        throw_java_exception( "java/lang/InstantiationException", clss->name->bytes);
    }

    volatile void *new_obj_volatile = class_alloc_new_object((Class *)p_target_class);

    if(constructor->is_nop()) {
        return (Java_java_lang_Object *)new_obj_volatile;
    }

    GC_Frame gcf;
    orp_push_gc_frame(&gcf, (void *)&new_obj_volatile, sizeof(volatile void *) ); 

    // Invoke the constructor
    orp_execute_java_method(constructor, 0, new_obj_volatile);

    orp_pop_gc_frame(&gcf);
    return (Java_java_lang_Object *)new_obj_volatile;
} //java_lang_Class_newInstance



/*
 * Class:     java_lang_Class
 * Method:    getName
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT jstring JNICALL Java_java_lang_Class_getName
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    
	// Is volatile needed here? If GC happens, cls will need to 
	// be refreshed...but the, Class data structures are not collected...
	volatile Class *cls = (Class *)clazz_h->java_reference;

	int str_len = cls->name->len;
	assert(str_len >= 0);
	char* dotname = (char*)malloc (sizeof(char) * (str_len + 1));
	assert (dotname);

	dotname[str_len] = 0;
	const char* clname = cls->name->bytes;
	for (int ii =0; ii < str_len; ii++) {
        if (clname[ii] == '/')  dotname[ii] = '.';
		else dotname[ii] = clname[ii];
    }

	jchar* clname_jchar = CToUnicode (jenv, dotname, str_len);
	assert (clname_jchar);

	free (dotname);
	jstring clname_jstring = jenv->NewString(clname_jchar, cls->name->len);
	
	//free memory allocated by CToUnicode
	free((void*)clname_jchar);
	return clname_jstring;
} // Java_java_lang_Class_getName

Class *load_class_from_cp_index(Class *clss, uint16 cp_index)
{
	String *cp_check_class(Const_Pool *cp, unsigned cp_size, unsigned class_index);

	String *clssname;
	if(cp_is_resolved(clss->const_pool, cp_index))
		clssname = (String*)clss->const_pool[cp_index].clss->name;
	else
		clssname = cp_check_class(clss->const_pool, clss->cp_size, cp_index);
	Loader_Exception exc = LD_NoException;
	Class *newclss = load_class_by_loader(ORP_Global_State::loader_env, clssname, clss->class_loader, &exc);
	if(clssname == NULL || exc != LD_NoException){
        cerr << "Error in loading declaring class " << clssname->bytes << endl;
		return NULL;
	}
	return newclss;
}

jobjectArray getClasses0(JNIEnv *jenv, jobject clazz, BOOL is_declared)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
	Class *clss = (Class *)clazz_h->java_reference;
	jclass clssclazz = FindClass(jenv, "java/lang/Class");
	int n_classes = 0;
    int i;
	for(i = 0; i < clss->n_innerclasses; i++){
		if(!is_declared && !(clss->innerclass_indexes[i*2+1] & ACC_PUBLIC))
			continue;
		n_classes++;
	}
	jarray carray = NewObjectArray(jenv, n_classes, clssclazz, 0);
	n_classes = 0;
	for(i = 0; i < clss->n_innerclasses; i++){
		if(!is_declared && !(clss->innerclass_indexes[i*2+1] & ACC_PUBLIC))
			continue;
		int gc_enabled = orp_disable_gc();
		Class *aclss = load_class_from_cp_index(clss, clss->innerclass_indexes[i*2]);
		if(gc_enabled)orp_enable_gc();
		if(!clss){
			//free(marray);
			return 0;
		}
		clazz_h = orp_create_local_object_handle();
		clazz_h->java_reference = (Java_java_lang_Object*)aclss;
		SetObjectArrayElement(jenv, carray, n_classes++, clazz_h);
	}
	return carray;
}

/*
 * Class:     java_lang_Class
 * Method:    getClasses
 * Signature: ()[Ljava/lang/Class;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getClasses
  (JNIEnv *jenv, jobject clazz)
{
    return getClasses0(jenv, clazz, FALSE);
} // Java_java_lang_Class_getClasses

/*
 * Class:     java_lang_Class
 * Method:    getDeclaredClasses
 * Signature: ()[Ljava/lang/Class;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getDeclaredClasses
  (JNIEnv *jenv, jobject clazz)
{
	return getClasses0(jenv, clazz, TRUE);
} // Java_java_lang_Class_getDeclaredClasses


/*
 * Class:     java_lang_Class
 * Method:    getDeclaringClass
 * Signature: ()Ljava/lang/Class;
 */

JNIEXPORT jclass JNICALL Java_java_lang_Class_getDeclaringClass
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
	Class *clss = (Class *)clazz_h->java_reference;
	if(clss->declaringclass_index == 0)
		return 0;
	clss = load_class_from_cp_index(clss, clss->declaringclass_index);
	if(!clss)
		return 0;
	clazz_h = orp_create_local_object_handle();
	clazz_h->java_reference = (Java_java_lang_Object*)clss;
	return clazz_h;
} // Java_java_lang_Class_getDeclaringClass

/*
 * Class:     java_lang_Class
 * Method:    getClassLoader
 * Signature: ()Ljava/lang/ClassLoader;
 */
JNIEXPORT jobject JNICALL Java_java_lang_Class_getClassLoader
  (JNIEnv *jenv, jobject clazz)
{
	Class *clss = (Class *)((Object_Handle)clazz)->java_reference;
    Class_Loader *class_loader = clss->class_loader;
    if(class_loader) {
        // Return a java.lang.ClassLoader object.
		orp_disable_gc();
		Object_Handle handle = orp_create_local_object_handle();
        handle->java_reference = class_loader->get_loader();
		orp_enable_gc();
	    return handle;
    } else {
        // The system class loader.  Return null.
	    return 0;
		/* 
		Many biz apps. need a system class loader object to be returned, 
		   we can create a ClassLoader object in native codes
		   (though ClassLoader is abstract class and can't be instantiated in java).
		But we prefer letting Classpath do this task.
		
		jclass clazz = FindClass(jenv, "java/lang/ClassLoader");
		Class *cl = (Class *)((Object_Handle)clazz)->java_reference;

		orp_disable_gc(); 
		Java_java_lang_Object *new_obj = (Java_java_lang_Object *)class_alloc_new_object(cl);
		Object_Handle clo = orp_create_local_object_handle();
		clo->java_reference = (Java_java_lang_Object *)new_obj;
		orp_enable_gc();  

		jmethodID cntr = GetMethodID (jenv, clazz, "<init>", "()V");
		CallVoidMethod(jenv, clo, cntr);
		return clo;
		*/
    }
} // Java_java_lang_Class_getClassLoader


//Make it reusable for both getConstructor and getDeclaredConstructor
jobject getConstructor0
  (JNIEnv *jenv, jobject clazz, jobjectArray parameterTypes, BOOL is_public)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

    /* wgs: why the class couldn't be java.lang.Object?
	if(!strcmp(clss->name->bytes, "java/lang/Object")){
		throw_exception_from_jni (jenv, "java/lang/NoSuchMethodException", 0);
		return (jobject)0;
	}
	*/

	char* msig = "()";

	if (parameterTypes) {
		msig = ParameterTypesToMethodSignature (jenv, parameterTypes);
	}
	
	// Should search in only this class, right??
	Method* m = LookupDeclaredMethod (clss, "<init>", msig);
	if (!m) {
		throw_exception_from_jni (jenv, "java/lang/NoSuchMethodException", 0);
		return (jobject)0;
	}
	if (is_public && !m->is_public()
#ifdef NON_ORP_NATIVE_LIBS
//BUGBUG
// this makes the default constructor also acceptable. But...it's inconsistent
// with the spec, which requires getConstructor return only the public one.
// we keep it here because Gnu Classpath implement newInstance with 
// Class.getConstructor(), which makes a class can only create object who type
// has publicly modified constructor.
        && ( m->is_protected() || m->is_private() )
#endif
     ){
		throw_exception_from_jni (jenv, "java/lang/NoSuchMethodException", 0);
		return (jobject)0;
	}

	Class_Loader *loader = clss->class_loader;
	jobject jconst = ConstructJavaConstructor (jenv, m, loader);
	assert(jconst);

	//free memory allocated by ParameterTypesToMethodSignature
	if(parameterTypes)
		free(msig);
	return jconst;
} // getConstructor0


/*
 * Class:     java_lang_Class
 * Method:    getConstructor
 * Signature: ([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;
 */


JNIEXPORT jobject JNICALL Java_java_lang_Class_getConstructor
  (JNIEnv *jenv, jobject clazz, jobjectArray parameterTypes)
{
	return getConstructor0(jenv, clazz, parameterTypes, TRUE);
} // Java_java_lang_Class_getConstructor

  /*
 * Class:     java_lang_Class
 * Method:    getDeclaredConstructor
 * Signature: ([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;
 */

JNIEXPORT jobject JNICALL Java_java_lang_Class_getDeclaredConstructor
  (JNIEnv *jenv, jobject clazz, jobjectArray parameterTypes)
{
	return getConstructor0(jenv, clazz, parameterTypes, FALSE);
} // Java_java_lang_Class_getDeclaredConstructor


//Make it reusable for both getConstructors and getDeclaredConstructors
jobjectArray getConstructors0
  (JNIEnv *jenv, jobject clazz, BOOL is_public)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	int n_consts =0;

	String *const_name = ORP_Global_State::loader_env->string_pool.lookup ("<init>");

	// Count all PUBLIC constructors:
	for (unsigned i=0;  i < clss->n_methods; i++) {
		if ((clss->methods[i].get_name() == const_name) &&
			(!is_public || clss->methods[i].is_public()))
			n_consts++;             
	}
	
	// Acquire handle to class for java/lang/reflect/Constructor :
	jclass cclazz = jenv->FindClass("java/lang/reflect/Constructor");
	if (!cclazz) {
		// Return without clearing exception; an exception is "rethrown", if any:
		return (jclass)0;   
	}

	// Create array of java/lang/reflect/Constructor elements:
	jobjectArray carray = (jobjectArray) jenv->NewObjectArray(n_consts, cclazz, 0);
	if (!carray) {
		// Return without clearing exception; an exception is "rethrown", if any:
		return (jobjectArray)0;
	}

	int ii = 0;
	Class_Loader *cl = clss->class_loader;
	// Fill the array with the constructors of the class:
	for (unsigned j = 0; j < clss->n_methods; j++) {
		if ((clss->methods[j].get_name() == const_name) &&
			(!is_public || clss->methods[j].is_public())) {
			//jobject jconst = ConstructJavaConstructor(jenv, &clss->methods[j]);
			jobject jconst = ConstructJavaConstructor(jenv, &clss->methods[j], cl);
			if (!jconst) return (jobjectArray)0;

			jenv->SetObjectArrayElement(carray, ii++, jconst);
			if (jenv->ExceptionOccurred()) return (jobjectArray)0;   
		}
	}
	return carray;
} //getConstructors0

/*
 * Class:     java_lang_Class
 * Method:    getConstructors
 * Signature: ()[Ljava/lang/reflect/Constructor;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getConstructors
  (JNIEnv *jenv, jobject clazz)
{
	return getConstructors0(jenv, clazz, TRUE);
} // Java_java_lang_Class_getConstructors

/*
 * Class:     java_lang_Class
 * Method:    getDeclaredConstructors
 * Signature: ()[Ljava/lang/reflect/Constructor;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getDeclaredConstructors
  (JNIEnv *jenv, jobject clazz)
{
	return getConstructors0(jenv, clazz, FALSE);
} // Java_java_lang_Class_getDeclaredConstructors

//Make it reusable for both getField and getDeclaredField
jobject getField0
  (JNIEnv *jenv, jobject clazz, jstring name, BOOL is_declared)
{
	// clazz is Class handle, not Field handle
	//WRONG: Field *f = GetField(jenv, clazz);
	const char* fname = jenv->GetStringUTFChars(name, NULL);

    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	// Find and return the field in the class definition. This field should exist
	// since the Field object is normally constructed by a call to Class.getField().

	Field *f = NULL;
	if(!is_declared)
		f = LookupField (clss, fname);
	else
		f = LookupDeclaredField(clss, fname);

	jenv->ReleaseStringUTFChars(name, fname);

	if (!f || (!is_declared && !f->is_public()) ) { 
		throw_exception_from_jni (jenv, "java/lang/NoSuchFieldException", 0);
		return (jobject)0;
	}

	jobject jconst = ConstructJavaField (jenv, f);
	assert(jconst);
	return jconst;
}//getField0

/*
 * Class:     java_lang_Class
 * Method:    getField
 * Signature: (Ljava/lang/String;I)Ljava/lang/reflect/Field;
 */

JNIEXPORT jobject JNICALL Java_java_lang_Class_getField
  (JNIEnv *jenv, jobject clazz, jstring name)
{
	return getField0(jenv, clazz, name, FALSE);
} // Java_java_lang_Class_getField


/*
 * Class:     java_lang_Class
 * Method:    getDeclaredField
 * Signature: (Ljava/lang/String;)Ljava/lang/reflect/Field;
 */

JNIEXPORT jobject JNICALL Java_java_lang_Class_getDeclaredField
  (JNIEnv *jenv, jobject clazz, jstring name)
{
	return getField0(jenv, clazz, name, TRUE); 
} // Java_java_lang_Class_getDeclaredField

//Make it reusable for both getFields and getDeclaredFields
jobjectArray getFields0
  (JNIEnv *jenv, jobject clazz, BOOL is_declared)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	// Acquire handle to class for java/lang/reflect/Field :
	jclass fclazz = jenv->FindClass("java/lang/reflect/Field");
	assert(fclazz);
	
	if (clss->is_array) {
		// Create array of java/lang/reflect/Field elements:
		jarray farray = jenv->NewObjectArray(0, fclazz, 0);
		return farray;
	}

	unsigned int n_fields =0;

	n_fields =0;	
	Class* cl = clss;		
	/*if is_declared, only do search once*/
	if(is_declared)
		n_fields = cl->n_fields;
	else
		for (; cl; cl = cl->super_class) {
			for (unsigned i=0;  i < cl->n_fields; i++) {
				if (cl->fields[i].is_public()) 
					n_fields++;             
			}
		}
	
	// Create array of java/lang/reflect/Field elements:
	jarray farray = jenv->NewObjectArray(n_fields, fclazz, 0);
	assert(farray);
	
	cl = clss;
	int ii =0;

	// Fill the array with the fields of the class:
	if(is_declared){
		for (unsigned i=0;  i < cl->n_fields; i++) {
			jobject jfield = ConstructJavaField(jenv, &cl->fields[i]);
			assert(jfield);
			jenv->SetObjectArrayElement(farray, ii++, jfield);
			if (jenv->ExceptionOccurred()) return (jobjectArray)0;   
		}
	}else
		for (; cl; cl = cl->super_class) {
			for (unsigned i=0;  i < cl->n_fields; i++) {
				if (cl->fields[i].is_public()){
					jobject jfield = ConstructJavaField(jenv, &cl->fields[i]);
					assert(jfield);
					jenv->SetObjectArrayElement(farray, ii++, jfield);
					if (jenv->ExceptionOccurred()) return (jobjectArray)0;   
				}
			}
		}
	return farray;
}//getFields0

/*
 * Class:     java_lang_Class
 * Method:    getFields
 * Signature: ()[Ljava/lang/reflect/Field;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getFields
  (JNIEnv *jenv, jobject clazz)
{
	return getFields0(jenv, clazz, FALSE); 
} // Java_java_lang_Class_getFields


/*
 * Class:     java_lang_Class
 * Method:    getDeclaredFields
 * Signature: ()[Ljava/lang/reflect/Field;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getDeclaredFields
  (JNIEnv *jenv, jobject clazz) 
{
	return getFields0(jenv, clazz, TRUE);
} // Java_java_lang_Class_getDeclaredFields

//Make it reusable for both getMethod and getDeclaredMethod
jobject getMethod0
  (JNIEnv *jenv, jobject clazz, jstring jname, jobjectArray parameterTypes, BOOL is_declared)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	char *msig = "()";

	if (parameterTypes) {
		msig = ParameterTypesToMethodSignature (jenv, parameterTypes);
	}

	jboolean is_copy;
	const char *name = jenv->GetStringUTFChars(jname, &is_copy);
	assert(name);

	Method* m;
	if(is_declared){
		// Use "LookupDeclaredMethod" from jni_utils.cpp to search only clss
		m = LookupDeclaredMethod (clss, name, msig);
	}else{
		// Use "LookupMethod" from jni_utils.cpp to search class and all its 
		// superclasses too.
		m = LookupMethod (clss, name, msig);
	}
	
	if (!m) {
		throw_exception_from_jni (jenv, "java/lang/NoSuchMethodException", 0);
		return (jobject)0;
	}

	if (!is_declared && !m->is_public()) { 
		throw_exception_from_jni (jenv, "java/lang/NoSuchMethodException", 0);
		return (jobject)0;
	}

	//Originally here is:
	//jobject jconst = ConstructJavaConstructor (jenv, m);
	//This is a serious fault.
	jobject jconst = ConstructJavaMethod(jenv, m);
	assert(jconst);

	//free memory allocated by ParameterTypesToMethodSignature
	if (parameterTypes)
		free(msig);
	return jconst;
} // getMethod0

/* parameter: minfo: the begin index to fill in;
			  count[in]: available space in minfo array;
			       [out]:total number of methods filled in
*/
// if the class is a interface, get the method array for it
BOOL fillIntfMethodInfo(Class* clss, Method **minfo, int &count){
	assert(class_is_interface(clss));
	int available = count;
	int filled = 0;
	int i;
	for(i = 0; i < clss->n_superinterfaces; i++){
		count = available;
		Class *intf = clss->superinterfaces[i].clss;
		if(!fillIntfMethodInfo(intf, minfo + filled, count))
			return FALSE;
		filled += count; 
		available -= count;
	}
	if(available < clss->n_methods)
		return FALSE;
	for(i = 0; i < clss->n_methods; i++)
		minfo[filled + i] = &clss->methods[i];
	count = filled + clss->n_methods;
	return TRUE;
}

/*
 * Class:     java_lang_Class
 * Method:    getMethod
 * Signature: (Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;
 */

JNIEXPORT jobject JNICALL Java_java_lang_Class_getMethod
  (JNIEnv *jenv, jobject clazz, jstring jname, jobjectArray parameterTypes)
{
	return getMethod0(jenv, clazz, jname, parameterTypes, FALSE);
} // Java_java_lang_Class_getMethod

 
/*
 * Class:     java_lang_Class
 * Method:    getDeclaredMethod
 * Signature: (Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;
 */

JNIEXPORT jobject JNICALL Java_java_lang_Class_getDeclaredMethod
  (JNIEnv *jenv, jobject clazz, jstring jname, jobjectArray parameterTypes)
{
	return getMethod0(jenv, clazz, jname, parameterTypes, TRUE);
} // Java_java_lang_Class_getDeclaredMethod


/*
 * Class:     java_lang_Class
 * Method:    getMethods
 * Signature: ()[Ljava/lang/reflect/Method;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getMethods
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	Class* cl = clss;		
	int n_methods = 0;

	// See the ORP Spec. 4.10 for array size used.
	//wgs: this method is frequently invoked, so we must figure out a more
	//efficient memory scheme
	int n_arraysize = 200;
	Method **m_array = (Method **) malloc(sizeof(Method *) * n_arraysize);

	String *const_name = ORP_Global_State::loader_env->string_pool.lookup ("<init>");
	assert(const_name);

	// Count the methods:
	// count all PUBLIC methods, declared or inherited
	if(!class_is_interface(clss)){
    	for (; cl; cl =	cl->super_class) {
    		int new_pos = n_methods;
    		for (unsigned i=0;  i < cl->n_methods; i++) {
    			Method* m = &cl->methods[i];
    
    			// Consider only public methods and non-constructors:
    			if (m->is_public() && (m->get_name() != const_name)) {  
    				Signature* sig = m->get_signature ();
    
    				// See if method is overridden:
    				int overridden =0;
    				for (int j =0; j < new_pos; j++) {
    					if (sig == m_array[j]->get_signature()) {
    						overridden = 1;
    						break;
    					}
    				}
    				if (!overridden){
    					m_array[n_methods] = m;
    					n_methods++;
						if(n_methods == n_arraysize){
							assert(n_arraysize <= 43690);
							n_arraysize = (int)(n_arraysize * 1.5);
							m_array = (Method **) realloc(m_array, sizeof(Method *) * n_arraysize);
						}
    				}
    			}
    		}
    	}
    }else{ //class_is_interface
		n_methods = n_arraysize;
		while(!fillIntfMethodInfo(clss, m_array, n_methods)){
			assert(n_arraysize <= 43690);
			n_arraysize = (int)(n_arraysize * 1.5);
			m_array = (Method **) realloc(m_array, sizeof(Method *) * n_arraysize);
			n_methods = n_arraysize;
		}
			
	}

	// Acquire handle to class for java/lang/reflect/Method :
	jclass mclazz = jenv->FindClass("java/lang/reflect/Method");
	assert(mclazz);

	// Create array of java/lang/reflect/Method elements:
	jarray marray = jenv->NewObjectArray(n_methods, mclazz, 0);
	assert(marray);

	for (int ii =0; ii < n_methods; ii++) {
		jobject jmethod = ConstructJavaMethod(jenv, m_array[ii]);
		assert(jmethod);
		jenv->SetObjectArrayElement(marray, ii, jmethod);
		if (jenv->ExceptionOccurred()) {
			free(m_array);
			free(marray);
			return (jobjectArray)0;
		}
	}
	
	free(m_array); //original code is free(marray): dangerous!
	return marray;
} // Java_java_lang_Class_getMethods


/*
 * Class:     java_lang_Class
 * Method:    getDeclaredMethods
 * Signature: ()[Ljava/lang/reflect/Method;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getDeclaredMethods
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	Class* cl = clss;		
	int n_methods = 0;

	// See the ORP Spec. 4.10 for array size used.
	//wgs: this method is frequently invoked, so we must figure out a more
	//efficient memory scheme
	int n_arraysize = 200;
	Method **m_array = (Method **) malloc(sizeof(Method *) * n_arraysize);
	
	String *const_name = ORP_Global_State::loader_env->string_pool.lookup ("<init>");
	assert(const_name);
	
	String *const_name1 = ORP_Global_State::loader_env->string_pool.lookup ("<clinit>");
	assert(const_name1);
	
	// count in "n_methods" and cache in "m_array" only methods 
	// DECLARED by this class
	for (unsigned int i=0;  i < cl->n_methods; i++) {
		// don't count constructors and class initializer
		if (cl->methods[i].get_name() != const_name &&
			cl->methods[i].get_name() != const_name1 ) {  
			m_array[n_methods] = &(cl->methods[i]);
			n_methods++;
            if(n_methods == n_arraysize){
                assert(n_arraysize <= 43690);
                n_arraysize = (int)(n_arraysize * 1.5);
                m_array = (Method **) realloc(m_array, sizeof(Method *) * n_arraysize);
            }
		}
	}
	
	// Acquire handle to class for java/lang/reflect/Method :
	jclass mclazz = jenv->FindClass("java/lang/reflect/Method");
	assert(mclazz);

	// Create array of java/lang/reflect/Method elements:
	jarray marray = jenv->NewObjectArray(n_methods, mclazz, 0);
	assert(marray);

	// Now, go ahead and build the array of methods and return it.
	for (int ii =0; ii < n_methods; ii++) {
		jobject jmethod = ConstructJavaMethod(jenv, m_array[ii]);
		assert(jmethod);
		jenv->SetObjectArrayElement(marray, ii, jmethod);
		if (jenv->ExceptionOccurred()) {
			free(m_array);
			free(marray);
			return (jobjectArray)0;
		}
	}
	
	free(m_array);//original code is free(marray): dangerous!
	return marray;
} // Java_java_lang_Class_getDeclaredMethods


/*
 * Class:     java_lang_Class
 * Method:    getInterfaces
 * Signature: ()[Ljava/lang/Class;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_Class_getInterfaces
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	unsigned int n_interfaces = clss->n_superinterfaces;

	// Create array of java/lang/Class elements to hold the interfaces:
	jclass cclazz = jenv->FindClass("java/lang/Class");
	assert(cclazz);

	jobjectArray interfaces = 
		(jobjectArray) (jenv->NewObjectArray(n_interfaces, cclazz, 0));
	assert(interfaces);

	for (unsigned i =0; i < n_interfaces; i++) {
	    //jclass intf = jenv->FindClass(clss->superinterfaces[i].clss->name->bytes);
		//assert(intf);
	    Class *_intf = NULL;
		/*
		Loader_Exception exception;
		if(clss->class_loader)
			_intf = load_class_by_loader(ORP_Global_State::loader_env,
										(String*)clss->superinterfaces[i].clss->name,
										clss->class_loader,
										&exception);
			//_intf = clss->class_loader->lookup_class((String*)clss->superinterfaces[i].clss->name);
		*/
		_intf = clss->superinterfaces[i].clss; 
		//if(!_intf)
		//	_intf = ORP_Global_State::loader_env->class_table.lookup(clss->superinterfaces[i].clss->name);
		//assert(_intf);
		if(!_intf){
			throw_java_exception("java/lang/IllegalArgumentException");
			return 0;
		}
		jclass intf = orp_create_local_object_handle();
		((Object_Handle)intf)->java_reference = (Java_java_lang_Object *)_intf;
		jenv->SetObjectArrayElement(interfaces, i, intf);
		if (jenv->ExceptionOccurred()) 
			return (jobjectArray)0;   
		
	}
	return interfaces;
} // Java_java_lang_Class_getInterfaces



/*
 * Class:     java_lang_Class
 * Method:    getModifiers
 * Signature: ()I
 */

JNIEXPORT jint JNICALL Java_java_lang_Class_getModifiers
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	return (jint) (clss->access_flags);
} // Java_java_lang_Class_getModifiers


/*
 * Class:     java_lang_Class
 * Method:    getSuperclass
 * Signature: ()Ljava/lang/Class;
 */


JNIEXPORT jclass JNICALL Java_java_lang_Class_getSuperclass
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	jclass superclazz =0;
	Class* superclass =0;

	if (class_is_interface (clss) || clss->is_primitive) {
		// Interfaces and primitive classes have no superclasses.
		return (jclass)0;
	}

	if (clss->super_class) {
		// superclazz = jenv->FindClass(clss->super_class->name->bytes);
		// assert(superclazz);
		superclazz = orp_create_local_object_handle();
        ((Object_Handle)superclazz)->java_reference = (Java_java_lang_Object *)clss->super_class;
	}
	return superclazz;
} // Java_java_lang_Class_getSuperclass


/*
 * Class:     java_lang_Class
 * Method:    isInstance
 * Signature: (Ljava/lang/Object;)Z
 */

JNIEXPORT jboolean JNICALL Java_java_lang_Class_isInstance
  (JNIEnv *jenv, jobject clazz, jobject obj)
{
	return jenv->IsInstanceOf(obj, clazz);
} // Java_java_lang_Class_isInstance


/*
 * Class:     java_lang_Class
 * Method:    isInterface
 * Signature: ()Z
 */

JNIEXPORT jboolean JNICALL Java_java_lang_Class_isInterface
  (JNIEnv *jenv, jobject clazz)
{
	// Acquire handle to internal class handle (Class):
    Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	return (jboolean)((class_is_interface (clss)) ? true : false);
} // Java_java_lang_Class_isInterface



/*
 * Class:     java_lang_Class
 * Method:    hackRunInitializers
 * Signature: ()V
 */

JNIEXPORT void JNICALL Java_java_lang_Class_hackRunInitializers
  (JNIEnv *, jobject)
{
	// Not implemented yet 
	assert(0);
} // Java_java_lang_Class_hackRunInitializers



/*
 * Class:     java_lang_Class
 * Method:    initializeClass
 * Signature: ()V
 */

JNIEXPORT void JNICALL Java_java_lang_Class_initializeClass
  (JNIEnv *jenv, jobject clazz)
{
	Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
    Class *clss = (Class *)clazz_h->java_reference;

	// This code needs to be verified!!!!
	void class_initialize_from_jni(Class *clss, bool throw_exception);
	
	class_initialize_from_jni(clss, false);
} // Java_java_lang_Class_initializeClass

