// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/level_3_jit_intf.h,v 1.2 2001/08/13 09:54:43 xhshi Exp $
//


#ifndef _LEVEL_3_JIT_INTF_H_
#define _LEVEL_3_JIT_INTF_H_


#include "jit_intf_cpp.h"


class Level_3_JIT: public JIT {

public:
    //
    // Initialize the JIT.
    //
    Level_3_JIT();
    ~Level_3_JIT();


    void next_command_line_argument(const char *, const char *);

    //
    // The ORP call into JIT to compile a method.
    //
    JIT_Result 
    compile_method(Compile_Handle     compilation,              // in
                   Method_Handle      method,                   // in
                   JIT_Flags          flags                     // in
                   );
    JIT_Result 
    gen_method_info(Compile_Handle     compilation,              // in
                    Method_Handle      method,                   // in
                    JIT_Flags          flags                     // in
                    )
    {
        assert(0); return JIT_FAILURE; // O3 JIT does not have this option
    }
#ifdef PLDI_OVERRIDDEN
    void
    method_was_overridden(Method_Handle         caller,
                          Method_Handle         callee
                          );
#endif

    //
    // For exception handling.
    // 
    void
    unwind_stack_frame(Method_Handle       method,               // in
                       Frame_Context      *context,              // in out
                       Boolean             is_first              // in
                       );


    /////////// begin GC support ///////////////

    //
    // Call from the ORP into the JIT.
    // The JIT:
    // 1. Enumerates all references for the current stack.
    //    The enumeration is precise, i.e., non-references are not
    //    enumerated.
    //    Enumeration can be done with either ORP::orp_enumerate_reference or
    //    ORP::orp_enumerate_references.  The enum_handle argument
    //    must be used in those callbacks.
    // 2. Unwinds the stack and modifies the context in-place.
    //
    void 
    get_root_set_from_stack_frame(Method_Handle         method,        // in
                                  GC_Enumeration_Handle enum_handle,   // in
                                  Frame_Context        *context,       // in out
                                  Boolean               is_first       // in
                                  );



    Boolean can_enumerate(Method_Handle method,
                          uint32        eip
                          );

    unsigned num_breakpoints(Method_Handle method,
                             uint32        eip
                             );

    // The JIT needs to write the breakpoint addresses into bp[],
    // and to make context->p_eip point to the return eip for the method.
    void get_breakpoints(Method_Handle method,      // in
                         uint32        *bp,         // out
                         Frame_Context *context     // in out
                         );



    /////////// end GC support ///////////////


    void
    fix_handler_context(Method_Handle      method,                     // in
                        Frame_Context     *context,                    // in out
                        Boolean            is_first                    // in
                        );


    void *
    get_address_of_this(Method_Handle       method,                     // in
                        const Frame_Context *context,                    // in
                        Boolean             is_first                    // in
                        );


    Boolean call_returns_a_reference(Method_Handle         method,              // in
                                     const Frame_Context  *context              // in
                                     );

    int
    get_break_point_offset(Compile_Handle compilation,         // in
                           Method_Handle  meth,                // in
                           JIT_Flags      flags,               // in
                           unsigned       bc_location          // in
                           ) 
    {
        assert(0); return 0; // O3 JIT does not have debugging support
    }

    void *
    get_address_of_var(Frame_Context   *context,
                       Boolean         is_first,
                       unsigned        var_no)
    {
        assert(0); return 0; // O3 JIT does not have debugging support
    }

    void 
    thread_recompile_methods()
    {
        assert(0); // O3 JIT does not recompile
    }
}; //Level_3_JIT



#endif
