// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/bitstream.cpp,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//

#include "defines.h"
#include "bitstream.h"
#include <iostream.h>
#include <string.h>

static unsigned bitcount[BitStream::stat_NUM];

BitStream::~BitStream()
{
    if (_dump_stats_in_destructor)
    {
        unsigned i;
        for (i=0; i<stat_NUM; i++)
        {
            switch (i)
            {
            //case stat_unknown:                   cout << "???                            "; break;
            case stat_bbcount_bits:              cout << "stat_bbcount_bits              "; break;
            case stat_bbcount:                   cout << "stat_bbcount                   "; break;
            case stat_max_inst_len_bits:         cout << "stat_max_inst_len_bits         "; break;
            case stat_n_spill_words:             cout << "stat_n_spill_words             "; break;
            case stat_n_callee_zero:             cout << "stat_n_callee_zero             "; break;
            case stat_n_callee:                  cout << "stat_n_callee                  "; break;
            case stat_push_pop_ret_offsets:      cout << "stat_push_pop_ret_offsets      "; break;
            case stat_sync:                      cout << "stat_sync                      "; break;
            case stat_gc_safe:                   cout << "stat_gc_safe                   "; break;
            case stat_eip_array:                 cout << "stat_eip_array                 "; break;
            case stat_mi_offset_array:           cout << "stat_mi_offset_array           "; break;
            case stat_num_inst_recs:             cout << "stat_num_inst_recs             "; break;
            case stat_adj_nonzero:               cout << "stat_adj_nonzero               "; break;
            case stat_adj_bits:                  cout << "stat_adj_bits                  "; break;
            case stat_initial_adj:               cout << "stat_initial_adj               "; break;
            case stat_init_reg_state:            cout << "stat_init_reg_state            "; break;
            case stat_bv_size_parms:             cout << "stat_bv_size_parms             "; break;
            case stat_esp_offset_parms:          cout << "stat_esp_offset_parms          "; break;
            case stat_rec_inst_len:              cout << "stat_rec_inst_len              "; break;
            case stat_rec_reg_parms:             cout << "stat_rec_reg_parms             "; break;
            case stat_rec_reg_stk_esp_change:    cout << "stat_rec_reg_stk_esp_change    "; break;
            case stat_rec_stk_change:            cout << "stat_rec_stk_change            "; break;
            case stat_rec_esp_change_op:         cout << "stat_rec_esp_change_op         "; break;
            case stat_rec_esp_change_adj:        cout << "stat_rec_esp_change_adj        "; break;
            default: continue; break;
            }
            cout << " = " << bitcount[i] << endl;
        }
    }
}

void BitStream::r__emit(unsigned value, unsigned num_bits
#ifdef PLDI
                        , StatType tag
#endif // PLDI
                        )
{
#ifdef PLDI
    if (_started_writing)
    {
        bitcount[tag] += num_bits;
    }
#endif // PLDI

    assert(!_read_only);  // we're allowed to write
    assert(num_bits > 0 && num_bits <= 32);
    if (_array == NULL)
    {
        _current_bit_ptr_global += num_bits;
    }
    else
    {
        assert(num_bits + get_offset() <= _final_array_size_bits);  // we're not writing too far
        unsigned n = num_bits;
        while (n > 0)
        {
            unsigned bits_to_write = n;
            unsigned can_be_written = 8*sizeof(*_array) - (_current_bit_ptr_global % (8*sizeof(*_array)));
            if (can_be_written < bits_to_write)
                bits_to_write = can_be_written;
            _array[_current_bit_ptr_global / (8*sizeof(*_array))] |=
                ((value & ((1u << bits_to_write) - 1)) << (_current_bit_ptr_global % (8*sizeof(*_array))));

            n -= bits_to_write;
            _current_bit_ptr_global += bits_to_write;
            value >>= bits_to_write;
        }
    }
}

void BitStream::r_emit_signed(int value, unsigned num_bits
#ifdef PLDI
                              , StatType tag
#endif // PLDI
                              )
{
    // Make sure the value really fits into the number of bits.
    if (num_bits < 32)
    {
        if (value < 0)
            assert((value | ((1u << (num_bits - 1)) - 1)) == ~0u);
        else
            assert((value & ~((1u << (num_bits - 1)) - 1)) == 0u);
    }
    _emit((unsigned)value, num_bits, tag);
}

void BitStream::r_emit_unsigned(unsigned value, unsigned num_bits
#ifdef PLDI
                                , StatType tag
#endif // PLDI
                                )
{
    if (num_bits < 32)
        assert((value & ~((1u << num_bits) - 1)) == 0u);
    _emit(value, num_bits, tag);
}

void BitStream::r_emit_signed_at_offset(int value, unsigned num_bits, unsigned offset
#ifdef PLDI
                                        , StatType tag
#endif // PLDI
                                        )
{
    unsigned old_offset = get_offset();
    set_offset(offset);
    emit_signed(value, num_bits, tag);
    set_offset(old_offset);
}

void BitStream::r_emit_unsigned_at_offset(unsigned value, unsigned num_bits, unsigned offset
#ifdef PLDI
                                          , StatType tag
#endif // PLDI
                                          )
{
    unsigned old_offset = get_offset();
    set_offset(offset);
    emit_unsigned(value, num_bits, tag);
    set_offset(old_offset);
}

unsigned BitStream::read_unsigned(unsigned num_bits)
{
    unsigned result = 0;
    assert(_read_only);
    assert(num_bits > 0 && num_bits <= 32);
    assert(_array != NULL);

    assert(num_bits + get_offset() <= _final_array_size_bits);  // we're not reading too far
    if (num_bits == 1) // optimize common case
    {
        if (_array[_current_bit_ptr_global / (8*sizeof(*_array))] & (1u << (_current_bit_ptr_global % (8*sizeof(*_array)))))
            result = 1;
        _current_bit_ptr_global ++;
        return result;
    }

    unsigned n = num_bits;
    while (n > 0)
    {
        unsigned bits_to_read = n;
        unsigned can_be_read = 8*sizeof(*_array) - (_current_bit_ptr_global % (8*sizeof(*_array)));
        if (can_be_read < bits_to_read)
            bits_to_read = can_be_read;
        result |=
            ((_array[_current_bit_ptr_global / (8*sizeof(*_array))] >> (_current_bit_ptr_global % (8*sizeof(*_array)))) << (num_bits - n));

        n -= bits_to_read;
        _current_bit_ptr_global += bits_to_read;
    }
    
    
    if (num_bits < 32)
        result &= ((1u << num_bits) - 1);
    return result;
}

int BitStream::read_signed(unsigned num_bits)
{
    unsigned val = read_unsigned(num_bits);
    // Sign-extend if necessary
    if (num_bits < 32 && (val & (1u << (num_bits - 1))))
        val |= ~((1u << num_bits) - 1);
    return val;
}

#if 0
unsigned BitStream::read_unsigned(unsigned num_bits)
{
    return _read(num_bits);
}
#endif // 0

int BitStream::read_signed_at_offset(unsigned num_bits, unsigned offset)
{
    unsigned old_offset = get_offset();
    set_offset(offset);
    int result = read_signed(num_bits);
    set_offset(old_offset);
    return result;
}

unsigned BitStream::read_unsigned_at_offset(unsigned num_bits, unsigned offset)
{
    unsigned old_offset = get_offset();
    set_offset(offset);
    unsigned result = read_unsigned(num_bits);
    set_offset(old_offset);
    return result;
}

void BitStream::start_writing(Mem_Manager &mem, unsigned total_bits)
{
    assert(!_read_only);
    assert(_array == NULL);
    _final_array_size_bits = total_bits;
    _array = (unsigned char *)mem.alloc((_final_array_size_bits + 8*sizeof(*_array) - 1) / (8*sizeof(*_array)));
    memset(_array, 0, (_final_array_size_bits + 8*sizeof(*_array) - 1) / (8*sizeof(*_array)));
    set_offset(0);
    _current_bit_ptr_global = 0;
    _started_writing = true;
}

void BitStream::copy_into(unsigned char *dest)
{
    assert(!_read_only);
    assert(_array != NULL);
    assert(get_offset() == _final_array_size_bits);
    memcpy(dest, _array, (_final_array_size_bits + 8*sizeof(*_array) - 1) / (8*sizeof(*_array)));
}

static unsigned char highest_bit_set[256] =
{
    0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};
unsigned BitStream::bits_required_for_unsigned(unsigned value)
{
#if 0
    unsigned result = 0;
    while (value != 0)
    {
        value >>= 1;
        result ++;
    }
    if (result == 0)
        result = 1;
    return result;
#else // 0
    if (value <= 0xff)
        return 1 + highest_bit_set[value];
    if (value <= 0xffff)
        return 9 + highest_bit_set[value >> 8];
    if (value <= 0xffffff)
        return 17 + highest_bit_set[value >> 16];
    return 25 + highest_bit_set[value >> 24];
#endif // 0
}

unsigned BitStream::bits_required_for_signed(int value)
{
    unsigned result = 0;
    if (value >= 0)
    {
        while (value != 0)
        {
            value >>= 1;
            result ++;
        }
    }
    else
    {
        while (value != -1)
        {
            value >>= 1;
            result ++;
        }
    }
    return result + 1;
}
