// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/profiling.h,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//



#ifndef _PROFILING_H_
#define _PROFILING_H_

class Code_Emitter;  // forward declaration
class Code_Patch;
class Bit_Vector;
struct Jit_Method_Info;

/*
   +---------------------------+
   |  n_back_edge              |
   |  m_entry                  |
   +---------------------------+
   |  back_edge[0]             |
   |   ...                     |
   |  back_edge[n_back_edge-1] |
   +---------------------------+
   |  bc_idx[0]                |
   |   ...                     |
   |  bc_idx[n_back_edge-1]    |
   +---------------------------+
*/
#define MIN_INNER_BRANCH_SIZE 200
#define INNER_BRANCH 10			//!!Note!! Be careful of lookupswitch! I wish there're less than basic_number * 50 sub-branches in one method, although maybe fails!
//typedef unsigned PROF_COUNTER;
typedef uint64 PROF_COUNTER;
typedef struct Profile_Rec {
    bool been_recompiled;
    unsigned short n_back_edge;
    PROF_COUNTER m_policy;       // initial value of method_policy
    PROF_COUNTER m_entry;        // count how many times is a method entered
    PROF_COUNTER back_edge[1];   // count how many times is a back edge taken/statistics: basic blocks
} Profile_Rec;

//
// We would like to generate Jit_Method_Info lazily (on demand).  The JIT
// compiler first creates Small_Method_Info with mi field is set to NULL.
// When VM requires Jit_Method_info for unwinding or enumerating root set,
// the JIT computes Jit_Method_Info.
//
typedef struct Small_Method_Info {
    Jit_Method_Info *mi;
    Profile_Rec *prof_rec;                  // record for holding profiling information
    unsigned class_initializer[1];          // bit vector that records which putstatic/getstatic
                                            // needs class initializer call
} Small_Method_Info;

class Profile_Patch {
public:
    unsigned entry;
    unsigned *IP_offset;
    char     **addr;   // needed to be patched with addr of recompilation call
    unsigned *bc_idx;  // bytecode that generates recompilation call
    Profile_Patch(Mem_Manager& mm, unsigned n) : entry(0) {
        IP_offset = (unsigned*)mm.alloc(n*sizeof(unsigned));
        addr = (char**)mm.alloc(n*sizeof(char*));
        bc_idx = (unsigned*)mm.alloc(n*sizeof(unsigned));
    }
};

class Recomp_Entry {
public:
    Bit_Vector *ref_bv;
    unsigned bc_index;
    unsigned IP_offset;
    Recomp_Entry *next;

    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    Recomp_Entry(Bit_Vector *bv, unsigned idx, Recomp_Entry *n) : 
      ref_bv(bv), next(n), bc_index(idx), IP_offset((unsigned)-1) {}
};

extern bool statistics;
extern bool inner_statistics ;
extern bool b_inner_counter ;
extern FILE* emitter_offset_fp;
//
// statistics call for inner bb instrument
//
extern void inner_bb_instrumenting_code(Code_Emitter& emitter, unsigned* cnt_addr) ;

extern void inserting_instrumenting_code(Code_Emitter& emitter, 
                                         Profile_Patch& prof_patch,
                                         unsigned bc_idx,
                                         unsigned* cnt_addr);

extern Profile_Rec *create_profile_rec(Method_Handle m_handle,
                                       Compile_Handle comp_handle,
                                       unsigned n_back_edges,
                                       unsigned bc_size);

extern void insert_call_recompilation(Mem_Manager& mm,
                                      Code_Emitter& emitter, 
                                      Code_Patch*& code_patch_list,
                                      Profile_Patch& prof_patch,
                                      JIT_Handle jit_handle,
                                      Method_Handle m_handle,
                                      Jit_Method_Info *m_info,
                                      Recomp_Entry *recomp_entries);

extern Profile_Rec *o1_method_get_profile_info(Method_Handle m_handle);

extern unsigned estimate_prof_rec_size(unsigned num_be_entries);

extern void print_profiling_info(JIT_Handle jit_handle);

#define recompilation_policy_method __UINT64_C(1000)
#define recompilation_policy_loop   __UINT64_C(10000)

#endif // _PROFILING_H_
